/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AuthCtx {
    protected List<String> via = new ArrayList<String>();
    protected String parentUser;
    protected final AuthSource authSource;
    protected String realUserLogin;
    protected String realUserEmail;
    protected Set<String> userGroups;
    protected transient String userAccessToken;
    protected String userProfile;
    protected APIKeyBase apiKey;
    protected AuthCtx immediateParent;

    public APIKeyBase getApiKey() {
        return this.apiKey;
    }

    public AuthCtx() {
        this.authSource = null;
    }

    public AuthCtx(AuthCtx authCtx) {
        this.via = new ArrayList<String>(authCtx.via);
        this.authSource = authCtx.authSource;
        this.realUserLogin = authCtx.realUserLogin;
        this.realUserEmail = authCtx.realUserEmail;
        this.userGroups = authCtx.userGroups != null ? Sets.newHashSet(authCtx.userGroups) : null;
        this.userAccessToken = authCtx.userAccessToken;
        this.parentUser = authCtx.parentUser;
        this.userProfile = authCtx.userProfile;
        this.apiKey = authCtx.apiKey != null ? authCtx.apiKey.deepCopy() : null;
    }

    public abstract AuthCtx deepCopy();

    protected AuthCtx(AuthSource authSource) {
        this.authSource = (AuthSource)((Object)Preconditions.checkNotNull((Object)((Object)authSource)));
    }

    public AuthSource getAuthSource() {
        return this.authSource;
    }

    public abstract String getIdentifier();

    public String getAssociatedDSSUserOrIdentifier() {
        String associated = this.getAssociatedDSSUser();
        return associated != null ? associated : this.getIdentifier();
    }

    public boolean isGroupsAware() {
        return this.authSource == AuthSource.USER_FROM_UI || this.authSource == AuthSource.PERSONAL_API_KEY || this.authSource == AuthSource.GLOBAL_API_KEY_WITH_GROUPS;
    }

    public Set<String> getGroups() throws DKUSecurityException {
        if (!this.isGroupsAware()) {
            throw new DKUSecurityException("User needs to be able to belong to some groups");
        }
        assert (this.userGroups != null);
        return this.userGroups;
    }

    public Set<String> getGroupsIfRelevant() {
        if (this.isGroupsAware() && this.userGroups != null) {
            return this.userGroups;
        }
        return new HashSet<String>();
    }

    public boolean isInGroup(String group) {
        assert (this.isGroupsAware());
        assert (this.userGroups != null);
        return this.userGroups.contains(group);
    }

    public boolean isGlobalApiKey() {
        return this.authSource == AuthSource.CONFIGURABLE_API_KEY_GLOBAL || this.authSource == AuthSource.GLOBAL_API_KEY_WITH_GROUPS;
    }

    public String toString() {
        Object base = null;
        switch (this.authSource) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: 
            case GLOBAL_API_KEY_WITH_GROUPS: {
                base = "api:" + this.apiKey.id;
                break;
            }
            case NONE: {
                base = "NONE";
                break;
            }
            case PERSONAL_API_KEY: {
                base = "papi:" + this.apiKey.id + ":" + this.getAssociatedDSSUser();
                break;
            }
            case USER_FROM_UI: {
                base = "user:" + this.getAssociatedDSSUser();
            }
        }
        String repr = "<AC:" + (String)base;
        if (this.via.size() > 0) {
            repr = repr + " via: " + StringUtils.join(this.via, (String)",via: ");
        }
        return repr + ">";
    }

    public String getAccessToken() {
        assert (this.authSource == AuthSource.USER_FROM_UI);
        return this.userAccessToken;
    }

    public void addVia(String via) {
        this.via.add(0, via);
    }

    public void addParent(AuthCtx parent) {
        this.immediateParent = parent;
        this.parentUser = parent.getIdentifier();
        this.via.add(0, parent.getIdentifier());
        this.via.addAll(0, parent.via);
    }

    public AuthCtx getImmediateParent() {
        return this.immediateParent;
    }

    public List<String> getVia() {
        return this.via;
    }

    public String getUserProfile() {
        return this.userProfile;
    }

    public String getUserEmail() {
        return this.realUserEmail;
    }

    public boolean isUserSameAsParent() {
        return StringUtils.isBlank((String)this.parentUser) || this.parentUser.equals(this.getIdentifier());
    }

    public abstract AuthCtx refresh() throws IOException, DKUSecurityException;

    public abstract String getAssociatedDSSUser();

    public abstract String getAssociatedDSSUserMand() throws DKUSecurityException;

    public abstract String getAssociatedDSSUserMandNoExc();

    public abstract String getDSSUserForImpersonation();

    public abstract void failIfNoSafeCode(String var1) throws UnauthorizedException;

    public abstract void failIfNoUnsafeCode(String var1) throws UnauthorizedException;

    public abstract boolean isSafeCodeAllowed();

    public abstract boolean isUnsafeCodeAllowed();

    public abstract boolean isAdmin();

    public static enum AuthSource {
        USER_FROM_UI,
        PERSONAL_API_KEY,
        CONFIGURABLE_API_KEY_GLOBAL,
        CONFIGURABLE_API_KEY_PROJECT,
        GLOBAL_API_KEY_WITH_GROUPS,
        NONE;

    }
}

