/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.azure;

import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.auth.GroupProfile;
import com.dataiku.dip.security.auth.UserRemappingRule;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.auth.UserSupplierSettings;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@UIModel
public class AzureADSettings
implements UserSupplierSettings {
    public boolean useGlobalProxy = true;
    public CredentialMethod credentialMethod = CredentialMethod.OAUTH2_SECRET;
    public String credentialsClientId;
    public String credentialsClientSecret;
    public String credentialsTenantId;
    public String credentialsCertificatePath;
    public String credentialsCertificatePassword;
    public String userQueryFilter = "mail eq '$login'";
    public String groupQueryFilter = "";
    public int groupsLimit = 5000;
    @JSON.FileTransient
    public boolean trustAllCerts = false;
    public boolean enabled = false;
    @UINullable
    public Integer order;
    public boolean autoProvisionUsersAtLoginTime = true;
    public boolean autoSyncUsersAtLoginTime = true;
    public boolean allowOnDemandUsersSync = true;
    public String defaultUserProfile;
    public List<GroupProfile> groupProfiles = new ArrayList<GroupProfile>();
    public List<String> authorizedGroups = new ArrayList<String>();
    public boolean allowOnDemandUsersProvisioning = false;
    public LoginAttribute loginAttributeRef = LoginAttribute.USER_PRINCIPAL_NAME;
    public List<UserRemappingRule> remappingRules = new ArrayList<UserRemappingRule>();
    public AzureADGroupsRetrievableBy azureADGroupsRetrievableBy = AzureADGroupsRetrievableBy.NOBODY;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isUsersAutoProvisioningAtLoginTimeEnabled() {
        return this.autoProvisionUsersAtLoginTime;
    }

    @Override
    public boolean isUsersAutoSyncAtLoginTimeEnabled() {
        return this.autoSyncUsersAtLoginTime;
    }

    @Override
    public boolean isOnDemandUsersSyncEnabled() {
        return this.allowOnDemandUsersSync;
    }

    @Override
    public String getDefaultUserProfile() {
        return this.defaultUserProfile;
    }

    @Override
    public Integer getOrder() {
        return this.order != null ? this.order.intValue() : this.getUserSourceType().getDefaultOrder();
    }

    @Override
    public UserSourceType getUserSourceType() {
        return UserSourceType.AZURE_AD;
    }

    public String getCredentialsClientSecretDecrypted(PasswordEncryptionService passwordEncryptionService) {
        return passwordEncryptionService.decryptIfEncrypted(this.credentialsClientSecret);
    }

    public String getCredentialsCertificatePasswordDecrypted(PasswordEncryptionService passwordEncryptionService) {
        return passwordEncryptionService.decryptIfEncrypted(this.credentialsCertificatePassword);
    }

    public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
        this.credentialsClientSecret = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.credentialsClientSecret);
        this.credentialsCertificatePassword = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.credentialsCertificatePassword);
    }

    @Override
    public List<GroupProfile> getProfileMappings() {
        return this.groupProfiles;
    }

    @Override
    public Set<String> getAuthorizedGroups() {
        return this.authorizedGroups.stream().map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    @Override
    public List<UserRemappingRule> getUserRemappingRules() {
        return this.remappingRules;
    }

    @Override
    public boolean isOnDemandUsersProvisioningEnabled() {
        return this.allowOnDemandUsersProvisioning;
    }

    public static enum CredentialMethod {
        OAUTH2_SECRET,
        OAUTH2_CERT;

    }

    public static enum LoginAttribute {
        EMAIL,
        USER_PRINCIPAL_NAME,
        DISPLAY_NAME;

    }

    public static enum AzureADGroupsRetrievableBy {
        NOBODY,
        EVERYBODY;

    }
}

