/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.IGitManager;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.impl.CloseShieldTransaction;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

public interface TransactionService {
    public RWTransaction beginWriteForUI(HttpServletRequest var1, boolean var2) throws IOException;

    public RWTransaction beginWriteForUI(HttpServletRequest var1) throws IOException;

    default public RWTransaction beginWriteAsLoggedInUser(AuthCtx usr) {
        return this.beginWriteAsLoggedInUser(usr, true);
    }

    public RWTransaction beginWriteAsLoggedInUser(AuthCtx var1, boolean var2);

    public Transaction beginRead(IsolationLevel var1, @Nullable String var2);

    default public Transaction beginRead(IsolationLevel isolationLevel) {
        return this.beginRead(isolationLevel, null);
    }

    default public Transaction beginRead() {
        return this.beginRead(IsolationLevel.ISOLATED);
    }

    default public RWTransaction beginWriteAsDSS() {
        return this.beginWriteAsDSS(true);
    }

    public RWTransaction beginWriteAsDSS(boolean var1);

    public File resolve(RelFile var1);

    public IGitManager getGitManager();

    public void performDirectCommit(DSSCommitDef var1) throws IOException;

    public void flushPendingCommits(String var1) throws IOException;

    public RWTransaction beginWriteForAPI(HttpServletRequest var1) throws IOException, DKUSecurityException;

    public RWTransaction beginWriteForTicket(HttpServletRequest var1) throws IOException, DKUSecurityException;

    public void clearCache();

    public void invalidateCache(RelFile var1);

    public CachedReadFS getCache();

    default public Transaction retrieveOrBeginRead() {
        return this.retrieveOrBeginRead(IsolationLevel.ISOLATED);
    }

    default public Transaction retrieveOrBeginRead(IsolationLevel isolationLevel) {
        if (!TransactionContext.hasAttachedTransaction()) {
            return this.beginRead(isolationLevel);
        }
        return new CloseShieldTransaction(TransactionContext.retrieveRead(), false);
    }

    default public RWTransaction beginNonCommittableWriteAsDSS() {
        return this.beginWriteAsDSS(false);
    }

    default public RWTransaction beginNonCommittableWriteAsLoggedInUser(AuthCtx usr) {
        return this.beginWriteAsLoggedInUser(usr, false);
    }
}

