/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.UrlRedactionUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;

public class GitModel {

    public static class GitWorkingTreeStatus {
        public boolean clean;
        public boolean hasUncommittedChanges;
        public Set<String> added;
        public Set<String> changed;
        public Set<String> removed;
        public Set<String> missing;
        public Set<String> modified;
        public Set<String> conflicting;
        public Set<String> untracked;
        public Set<String> untrackedFolders;
    }

    public static class GitTag {
        public final String commitId;
        public final String shortName;
        public final String name;
        public final GitTagAnnotations annotations;
        public final boolean readOnly;
        public static final String DSS_TAG_PREFIX = "dss-";
        public static final String DSS_VERSION_TAG_PREFIX = "dss-version-";
        public static final String BRANCH_TAG_PREFIX = "dss-branched-";

        public GitTag(RevTag revTag) {
            this.commitId = revTag.getObject().getName();
            this.name = revTag.getTagName();
            this.shortName = Repository.shortenRefName((String)revTag.getTagName());
            this.readOnly = GitTag.isReadOnly(this.shortName);
            this.annotations = new GitTagAnnotations(revTag);
        }

        public GitTag(Ref ref, RevCommit revCommit) {
            this.commitId = revCommit.getName();
            this.name = ref.getName();
            this.shortName = Repository.shortenRefName((String)ref.getName());
            this.readOnly = GitTag.isReadOnly(this.shortName);
            this.annotations = null;
        }

        public static boolean isReadOnly(String shortName) {
            return shortName.startsWith(DSS_TAG_PREFIX);
        }

        public String toString() {
            return "GitTag{commitId='" + this.commitId + "', shortName='" + this.shortName + "', name='" + this.name + "', annotations=" + String.valueOf(this.annotations) + ", readOnly=" + this.readOnly + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GitTag gitTag = (GitTag)o;
            return Objects.equals(this.annotations, gitTag.annotations) && Objects.equals(this.commitId, gitTag.commitId) && Objects.equals(this.name, gitTag.name);
        }

        public int hashCode() {
            return Objects.hash(this.commitId, this.shortName, this.name, this.annotations);
        }
    }

    public static class GitTagAnnotations {
        public final String message;
        public final long timestamp;
        public final String authorName;
        public final String authorEmail;

        public GitTagAnnotations(RevTag revTag) {
            this.message = revTag.getFullMessage();
            PersonIdent tagIdent = revTag.getTaggerIdent();
            this.timestamp = tagIdent.getWhen().toInstant().atZone(ZoneId.of(tagIdent.getTimeZone().getID())).toEpochSecond() * 1000L;
            this.authorName = tagIdent.getName();
            this.authorEmail = tagIdent.getEmailAddress();
        }

        public String toString() {
            return "GitTagAnnotations{message='" + this.message + "', timestamp=" + this.timestamp + ", authorName='" + this.authorName + "', authorEmail='" + this.authorEmail + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GitTagAnnotations annotations = (GitTagAnnotations)o;
            return Objects.equals(this.message, annotations.message) && Objects.equals(this.timestamp, annotations.timestamp) && Objects.equals(this.authorEmail, annotations.authorEmail) && Objects.equals(this.authorName, annotations.authorName);
        }

        public int hashCode() {
            return Objects.hash(this.authorName, this.authorEmail, this.timestamp, this.message);
        }
    }

    public static class GitAuthor {
        public static GitAuthor DATAIKU = new GitAuthor("dataiku", null);
        public final String name;
        public final String email;

        public GitAuthor(String name, String email) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            this.email = email;
        }

        public GitAuthor(AuthCtx authCtx) {
            this(authCtx.getIdentifier(), authCtx.getUserEmail());
        }

        public String getEmailOrName() {
            return StringUtils.isNotBlank((String)this.email) ? this.email : this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof GitAuthor && this.name.equals(((GitAuthor)o).name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static class GitReference {
        public String remote;
        public String checkout;
        public String remotePath;
        public String remoteLogin;
        public String remotePassword;
        public String lastHash;
        public Long lastTimestamp;
        public Set<String> conflictingFiles;
        public Set<String> resolvedFiles;
        public String faultyHash;
        public boolean isDirty;

        public String getSanitizedRemoteUrl() {
            return UrlRedactionUtils.sanitizeHttpUrls(this.remote);
        }
    }

    public static class LimitedDKULogEntryList
    extends ArrayList<DKULogEntry> {
        private static final long serialVersionUID = 1L;
        private int trueCount = 0;

        public void setTrueCount(int trueCount) {
            this.trueCount = trueCount;
        }

        public int getTrueCount() {
            return this.trueCount;
        }
    }

    public static class DKULogEntry {
        public String author;
        public long timestamp;
        public String commitId;
        public String message;
        public Set<GitTag> tags;

        public static DKULogEntry fromCommit(RevCommit revCommit, Map<String, Set<GitTag>> tags) {
            DKULogEntry ret = new DKULogEntry();
            ret.commitId = revCommit.getId().getName();
            ret.author = revCommit.getAuthorIdent().getName();
            ret.timestamp = 1000L * (long)revCommit.getCommitTime();
            ret.message = revCommit.getFullMessage();
            ret.tags = tags != null ? tags.getOrDefault(ret.commitId, Collections.emptySet()) : Collections.emptySet();
            return ret;
        }

        public static DKULogEntry fakeCommit(String commitId) {
            DKULogEntry ret = new DKULogEntry();
            ret.commitId = commitId;
            return ret;
        }

        public long estimatedFootprint() {
            long s = 50L;
            s += 10L;
            s += (long)this.author.length();
            s += (long)this.commitId.length();
            return s += (long)StringUtils.defaultIfEmpty((String)this.message, (String)"").length();
        }
    }

    public static class FileChange
    extends DiffStatEntry {
        public String s = "";
        public List<String> c = new ArrayList<String>();

        @Override
        public long estimatedFootprint() {
            long l = super.estimatedFootprint();
            l += 6L;
            l += (long)this.s.length();
            for (String x : this.c) {
                l += 4L;
                if (x == null) continue;
                l += (long)x.length();
            }
            return l;
        }
    }

    public static class GitBranches {
        public List<String> local = new ArrayList<String>();
        public List<String> remote = new ArrayList<String>();
    }

    public static class GitTrackingCount {
        public Integer ahead;
        public Integer behind;
    }

    public static class GitFullStatus {
        public List<GitRemote> remotes;
        public GitTrackingCount trackingCount;
        public String currentBranch;
        public String originProjectKey;
        public GitTrackingCount trackingCountWithOriginProject;
    }

    public static class GitRemote {
        public String name;
        public String url;
    }

    public static class DKULog {
        public List<DKULogEntry> logEntries;
        public String nextCommit;
        public int countUntil;
    }

    public static class MultiCommitDiffSummary
    extends DiffSummary {
        public DKULogEntry commitFrom;
        public DKULogEntry commitTo;
    }

    public static class MultiCommitDiff
    extends Diff {
        public DKULogEntry commitFrom;
        public DKULogEntry commitTo;

        public MultiCommitDiffSummary summarize() {
            MultiCommitDiffSummary ret = new MultiCommitDiffSummary();
            ret.commitFrom = this.commitFrom;
            ret.commitTo = this.commitTo;
            for (DKUDiffEntry e : this.diffEntries) {
                if (e.changeType == DiffEntry.ChangeType.ADD) {
                    ret.added.add(e.newPath);
                    continue;
                }
                if (e.changeType == DiffEntry.ChangeType.DELETE) {
                    ret.deleted.add(e.oldPath);
                    continue;
                }
                if (e.changeType == DiffEntry.ChangeType.MODIFY) {
                    ret.modified.add(e.newPath);
                    continue;
                }
                if (e.changeType != DiffEntry.ChangeType.RENAME) continue;
                ret.deleted.add(e.newPath);
                ret.added.add(e.newPath);
            }
            return ret;
        }
    }

    public static class SingleCommitObjectDiff
    extends Diff {
        public String projectKey;
        public DKULogEntry commit;
        public boolean isRevertable = true;
    }

    public static class DiffSummary {
        public Set<String> added = Sets.newHashSet();
        public Set<String> modified = Sets.newHashSet();
        public Set<String> deleted = Sets.newHashSet();
        public Set<String> authors = Sets.newHashSet();
        public Set<String> ignored = Sets.newHashSet();

        public void cleanJupyterLabCheckpointFiles() {
            Predicate<String> isCheckPoint = s -> s.contains(".ipynb_checkpoints");
            this.added.removeIf(isCheckPoint);
            this.modified.removeIf(isCheckPoint);
            this.deleted.removeIf(isCheckPoint);
        }
    }

    public static abstract class Diff {
        public List<DKUDiffEntry> diffEntries;
        public int addedLines = 0;
        public int removedLines = 0;
        public int changedFiles = 0;

        public void computeStats() {
            for (DKUDiffEntry diffEntry : this.diffEntries) {
                if (diffEntry.fileChange != null) {
                    this.addedLines += diffEntry.fileChange.addedLines;
                    this.removedLines += diffEntry.fileChange.removedLines;
                }
                ++this.changedFiles;
            }
        }
    }

    public static class LimitedDKUDiffEntryList
    extends ArrayList<DKUDiffEntry> {
        private static final long serialVersionUID = 1L;
        private int trueCount = 0;

        public void setTrueCount(int trueCount) {
            this.trueCount = trueCount;
        }

        public int getTrueCount() {
            return this.trueCount;
        }
    }

    public static class DKUDiffEntry {
        public DiffEntry.ChangeType changeType;
        public String oldPath;
        public String newPath;
        public FileChange fileChange;

        public long estimatedFootprint() {
            long s = 50L;
            s += 10L;
            s += (long)StringUtils.defaultIfEmpty((String)this.oldPath, (String)"").length();
            s += (long)StringUtils.defaultIfEmpty((String)this.newPath, (String)"").length();
            if (this.changeType != null) {
                s += 10L;
            }
            if (this.fileChange != null) {
                s += this.fileChange.estimatedFootprint();
            }
            return s;
        }
    }

    public static class DiffStatEntry {
        public int addedLines;
        public int removedLines;

        public long estimatedFootprint() {
            return 40L;
        }

        public boolean isEmpty() {
            return this.addedLines == 0 && this.removedLines == 0;
        }
    }
}

