/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.j3ts.PyFileEmitter;
import com.dataiku.dip.utils.polyjson.PolyClassMetadata;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class PyMappedType
implements Comparable<PyMappedType> {
    String polyJsonType;
    boolean hasJavaSubclasses;
    Type javaType;
    PyType type;
    RelFile definitionFileNoExt;
    boolean inspected;
    List<PyMappedType> typeParameters;
    PyMappedType rawJavaType;
    PyMappedType superclass;
    PyMappedType rawSuperclass;
    List<PyMappedType> implementedInterfaces = new ArrayList<PyMappedType>();
    boolean hasPolyJsonAnnotation;
    PolyClassMetadata polyJsonMeta;
    List<PyMappedType> polyJsonSubclasses;
    private String name;
    List<String> modules = new ArrayList<String>();
    List<MappedField> typeFields;
    List<PyMappedType> subclasses = new ArrayList<PyMappedType>();
    boolean generateUnion = false;
    String problem;
    List<MappedEnumValue> enumValues;
    boolean concrete;
    @Nullable
    PyMappedType translatedVia;
    int translatedViaDepth;

    PyMappedType() {
    }

    PersistedTypeMeta getPersistedTypeMeta() {
        PersistedTypeMeta typeMeta = new PersistedTypeMeta();
        typeMeta.javaType = this.javaType.getTypeName();
        typeMeta.definitionFileNoExt = this.definitionFileNoExt.getFullPath();
        typeMeta.name = this.name;
        typeMeta.type = this.type;
        typeMeta.modules = this.modules;
        typeMeta.concreteSubclasses = this.subclasses.stream().filter(mt -> mt.concrete).map(mt -> mt.javaType).map(Type::getTypeName).collect(Collectors.toList());
        return typeMeta;
    }

    String explainTranslation() {
        if (this.translatedVia == null) {
            return "PyModel annotation in the class hierarchy";
        }
        if (this.translatedVia.type == PyType.ENUM || this.translatedVia.type == PyType.CLASS) {
            return this.translatedVia.javaType.getTypeName();
        }
        return this.translatedVia.explainTranslation();
    }

    void logTranslationIssue(String message) {
        System.out.println("[!] " + message + " (" + this.javaType.getTypeName() + ")");
        PyMappedType current = this.translatedVia;
        while (current != null) {
            String line = "[!]     <- " + current.javaType.getTypeName();
            if (current.polyJsonMeta != null && current.polyJsonMeta.getAnnotatedClass() != current.javaType) {
                line = line + " (" + String.valueOf(current.polyJsonMeta.getAnnotatedClass()) + ")";
            }
            System.out.println(line);
            current = current.translatedVia;
        }
    }

    Set<PyMappedType> listHierarchyRecursivelyIncludingSelf() {
        TreeSet<PyMappedType> out = new TreeSet<PyMappedType>();
        if (!this.subclasses.isEmpty()) {
            for (PyMappedType subclass : this.subclasses) {
                out.addAll(subclass.listHierarchyRecursivelyIncludingSelf());
            }
        }
        out.add(this);
        return out;
    }

    public String getNameForFunctionalSyntax() {
        return "__" + this.getName();
    }

    public String getNameForInterface() {
        return "_" + this.getName();
    }

    public String getName() {
        if (PyFileEmitter.typingImports.contains(this.name)) {
            return "Reserved_" + this.name;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(PyMappedType o) {
        Type t1 = this.javaType;
        Type t2 = o.javaType;
        return t1.toString().compareTo(t2.toString());
    }

    static class PersistedTypeMeta {
        List<String> concreteSubclasses;
        String javaType;
        List<String> modules = new ArrayList<String>();
        String name;
        String definitionFileNoExt;
        PyType type;

        PersistedTypeMeta() {
        }
    }

    static enum PyType {
        CLASS,
        STRING,
        INT,
        FLOAT,
        LIST,
        MAP,
        BOOLEAN,
        ANY,
        UNKNOWN,
        ENUM,
        PARAMETRIZED_TYPE,
        TYPE_VARIABLE;

    }

    static class MappedEnumValue {
        String name;
        String value;

        MappedEnumValue() {
        }
    }

    static class MappedField {
        String name;
        PyMappedType mt;
        boolean optional;

        MappedField() {
        }
    }
}

