/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.polyjson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.UnsafeAllocator;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

public class RichJsonWriter
extends JsonWriter {
    private JsonWriter backingWriter;
    private int stackLevel;
    private FlattenContext flattenContext;
    private CaptureContext captureContext;
    private CaptureContext activeContext;
    private JsonWriter currentWriter;
    private String[] currentPath;
    private static final UnsafeAllocator UNSAFE_ALLOCATOR = UnsafeAllocator.create();

    private RichJsonWriter() {
        super(null);
    }

    public static RichJsonWriter fromWriter(JsonWriter backingWriter) {
        if (backingWriter instanceof RichJsonWriter) {
            return (RichJsonWriter)backingWriter;
        }
        RichJsonWriter richWriter = RichJsonWriter.newInstance();
        richWriter.backingWriter = backingWriter;
        richWriter.currentWriter = backingWriter;
        richWriter.currentPath = new String[16];
        return richWriter;
    }

    private void updateCurrentPath(String value) {
        if (this.stackLevel >= this.currentPath.length) {
            this.currentPath = Arrays.copyOf(this.currentPath, this.currentPath.length * 2);
        }
        this.currentPath[this.stackLevel] = value;
    }

    private static RichJsonWriter newInstance() {
        try {
            return (RichJsonWriter)((Object)UNSAFE_ALLOCATOR.newInstance(RichJsonWriter.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Can't allocate " + String.valueOf(RichJsonWriter.class), e);
        }
    }

    public void beginFlatten() {
        if (this.flattenContext != null && this.flattenContext.stackLevel == this.stackLevel) {
            throw new IllegalStateException("beginFlatten() must be immediately followed by beginObject()");
        }
        FlattenContext elt = new FlattenContext();
        elt.parent = this.flattenContext;
        elt.stackLevel = this.stackLevel;
        this.flattenContext = elt;
    }

    public void endFlatten() {
        if (this.flattenContext == null || this.flattenContext.stackLevel != this.stackLevel) {
            throw new IllegalStateException("Was not flattening an object");
        }
        this.flattenContext = this.flattenContext.parent;
    }

    public JsonWriter beginArray() throws IOException {
        ++this.stackLevel;
        this.updateCurrentPath("[*]");
        this.currentWriter.beginArray();
        return this;
    }

    public JsonWriter endArray() throws IOException {
        this.updateCurrentPath(null);
        --this.stackLevel;
        this.currentWriter.endArray();
        return this;
    }

    public void beginCapture(String propertyName) {
        CaptureContext newCaptureContext = new CaptureContext();
        newCaptureContext.parent = this.captureContext;
        newCaptureContext.stackLevel = this.stackLevel;
        newCaptureContext.property = propertyName;
        this.captureContext = newCaptureContext;
    }

    public JsonWriter beginObject() throws IOException {
        if (this.flattenContext != null && this.flattenContext.stackLevel == this.stackLevel && !this.flattenContext.objectStarted) {
            this.flattenContext.objectStarted = true;
            return this;
        }
        ++this.stackLevel;
        this.updateCurrentPath(null);
        this.currentWriter.beginObject();
        return this;
    }

    public JsonElement endCapture() {
        if (this.captureContext == null || this.captureContext.stackLevel != this.stackLevel) {
            throw new IllegalStateException("Not capturing at this level");
        }
        this.endCapturedProperty();
        JsonElement capturedElement = null;
        if (this.captureContext.writer != null) {
            capturedElement = this.captureContext.writer.get();
        }
        this.captureContext = this.captureContext.parent;
        return capturedElement;
    }

    public JsonWriter endObject() throws IOException {
        if (this.flattenContext != null && this.flattenContext.stackLevel == this.stackLevel && this.flattenContext.objectStarted) {
            this.flattenContext.objectStarted = false;
            return this;
        }
        this.endCapturedProperty();
        this.updateCurrentPath(null);
        --this.stackLevel;
        this.currentWriter.endObject();
        return this;
    }

    private void endCapturedProperty() {
        if (this.captureContext != null && this.captureContext.stackLevel > this.stackLevel) {
            throw new IllegalStateException("A capture was not closed");
        }
        if (this.activeContext != null && this.activeContext.stackLevel == this.stackLevel) {
            this.activeContext = this.activeContext.activeParent;
            this.currentWriter = this.activeContext == null ? this.backingWriter : this.activeContext.writer;
        }
    }

    public JsonWriter name(String name) throws IOException {
        this.endCapturedProperty();
        CaptureContext newCaptureToStart = this.captureContext;
        while (newCaptureToStart != null) {
            if (newCaptureToStart.stackLevel != this.stackLevel) {
                newCaptureToStart = null;
                break;
            }
            if (newCaptureToStart.writer == null && newCaptureToStart.property.equals(name)) break;
            newCaptureToStart = newCaptureToStart.parent;
        }
        if (newCaptureToStart == null) {
            this.currentWriter.name(name);
        } else {
            newCaptureToStart.activeParent = this.activeContext;
            newCaptureToStart.writer = new JsonTreeWriter();
            this.currentWriter = newCaptureToStart.writer;
            this.activeContext = newCaptureToStart;
        }
        this.updateCurrentPath(name);
        return this;
    }

    public JsonWriter value(String value) throws IOException {
        this.currentWriter.value(value);
        return this;
    }

    public JsonWriter jsonValue(String value) throws IOException {
        this.currentWriter.jsonValue(value);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        this.currentWriter.nullValue();
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.currentWriter.value(value);
        return this;
    }

    public JsonWriter value(Boolean value) throws IOException {
        this.currentWriter.value(value);
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        this.currentWriter.value(value);
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.currentWriter.value(value);
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        this.currentWriter.value(value);
        return this;
    }

    public String getCurrentPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("$");
        for (int i = 0; i <= this.stackLevel; ++i) {
            if (this.currentPath[i] == null) continue;
            if ("[*]".equals(this.currentPath[i])) {
                sb.append("[*]");
                continue;
            }
            sb.append(".");
            sb.append(this.currentPath[i]);
        }
        return sb.toString();
    }

    public <V, U extends V> void writeJsonElement(TypeAdapter<V> adapter, U value) throws IOException {
        RichJsonWriter writer = this.captureContext == null && this.flattenContext == null && this.activeContext == null ? this.backingWriter : this;
        adapter.write((JsonWriter)writer, value);
    }

    public void writeJsonElement(JsonElement jsonElement) throws IOException {
        this.writeJsonElement(TypeAdapters.JSON_ELEMENT, jsonElement);
    }

    public void flush() throws IOException {
        this.backingWriter.flush();
    }

    public void close() throws IOException {
        this.backingWriter.close();
    }

    public <V, U extends V> void writeProperty(TypeAdapter<V> adapter, String name, U value) throws IOException {
        if (value != null) {
            this.name(name);
            this.writeJsonElement(adapter, value);
        }
    }

    public void writeProperty(String name, JsonElement value) throws IOException {
        if (value != null && !value.isJsonNull()) {
            this.name(name);
            this.writeJsonElement(value);
        }
    }

    public void writeProperty(String name, String value) throws IOException {
        if (value != null) {
            this.name(name);
            this.value(value);
        }
    }

    public <U> void writeProperty(Gson gson, String name, U value) throws IOException {
        if (value != null) {
            TypeAdapter adapter = gson.getAdapter(value.getClass());
            this.writeProperty(adapter, name, value);
        }
    }

    public void writeProperty(String name, boolean value) throws IOException {
        this.name(name);
        this.value(value);
    }

    public void writeProperty(String name, double value) throws IOException {
        this.name(name);
        this.value(value);
    }

    public void writeProperty(String name, float value) throws IOException {
        this.name(name);
        this.value(value);
    }

    public void writeProperty(String name, int value) throws IOException {
        this.name(name);
        this.value(value);
    }

    public void writeProperty(String name, long value) throws IOException {
        this.name(name);
        this.value(value);
    }

    private static class FlattenContext {
        FlattenContext parent;
        boolean objectStarted;
        int stackLevel;

        private FlattenContext() {
        }
    }

    private static class CaptureContext {
        CaptureContext parent;
        CaptureContext activeParent;
        JsonTreeWriter writer;
        int stackLevel;
        String property;

        private CaptureContext() {
        }
    }
}

