/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.dataengine.utilities;

public class DSITimeSpan
implements Cloneable {
    private int m_intervalType;
    private int m_day = 0;
    private int m_hour = 0;
    private int m_minute = 0;
    private int m_second = 0;
    private int m_fraction = 0;
    private boolean m_isNegative = false;

    public DSITimeSpan(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.validate(n2, n3, n4, n5);
        this.m_intervalType = n;
        this.m_day = n2;
        this.m_hour = n3;
        this.m_minute = n4;
        this.m_second = n5;
        this.m_fraction = n6;
        this.m_isNegative = bl;
    }

    public int getDay() {
        return this.m_day;
    }

    public int getFraction() {
        return this.m_fraction;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getIntervalType() {
        return this.m_intervalType;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public int getSecond() {
        return this.m_second;
    }

    public boolean isNegative() {
        return this.m_isNegative;
    }

    public void setDay(int n) {
        this.validate(n, this.m_hour, this.m_minute, this.m_second);
        this.m_day = n;
    }

    public void setFraction(int n) {
        this.m_fraction = n;
    }

    public void setHour(int n) {
        this.validate(this.m_day, n, this.m_minute, this.m_second);
        this.m_hour = n;
    }

    public void setIsNegative(boolean bl) {
        this.m_isNegative = bl;
    }

    public void setMinute(int n) {
        this.validate(this.m_day, this.m_hour, n, this.m_second);
        this.m_minute = n;
    }

    public void setSecond(int n) {
        this.validate(this.m_day, this.m_hour, this.m_minute, n);
        this.m_second = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        if (this.m_isNegative) {
            stringBuilder.append("-");
        }
        stringBuilder.append(String.valueOf(this.m_day)).append(" ");
        stringBuilder.append(String.valueOf(this.m_hour)).append(":");
        stringBuilder.append(String.valueOf(this.m_minute)).append(":");
        stringBuilder.append(String.valueOf(this.m_second)).append(".");
        String string = String.valueOf(this.m_fraction);
        for (int i = 9 - string.length(); i > 0; --i) {
            stringBuilder.append("0");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private void validate(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = n != 0;
        boolean bl3 = bl2 || n2 != 0;
        boolean bl4 = bl = bl3 || n3 != 0;
        if (bl2 && (0 > n2 || 23 < n2)) {
            throw new IllegalArgumentException("Invalid hour value.");
        }
        if (bl3 && (0 > n3 || 59 < n3)) {
            throw new IllegalArgumentException("Invalid minute value.");
        }
        if (bl && (0 > n4 || 59 < n4)) {
            throw new IllegalArgumentException("Invalid second value.");
        }
    }

    public DSITimeSpan clone() {
        try {
            return (DSITimeSpan)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.m_day;
        n = 31 * n + this.m_fraction;
        n = 31 * n + this.m_hour;
        n = 31 * n + this.m_intervalType;
        n = 31 * n + (this.m_isNegative ? 1231 : 1237);
        n = 31 * n + this.m_minute;
        n = 31 * n + this.m_second;
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSITimeSpan)) {
            return false;
        }
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        return this.m_isNegative == dSITimeSpan.m_isNegative && this.m_day == dSITimeSpan.m_day && this.m_hour == dSITimeSpan.m_hour && this.m_minute == dSITimeSpan.m_minute && this.m_second == dSITimeSpan.m_second && this.m_fraction == dSITimeSpan.m_fraction && this.m_intervalType == dSITimeSpan.m_intervalType;
    }
}

