/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.dataengine.utilities;

import com.databricks.client.dsi.dataengine.interfaces.IArray;
import com.databricks.client.dsi.dataengine.utilities.DSIMonthSpan;
import com.databricks.client.dsi.dataengine.utilities.DSITimeSpan;
import com.databricks.client.dsi.dataengine.utilities.TimeTz;
import com.databricks.client.dsi.dataengine.utilities.TimestampTz;
import com.databricks.client.dsi.dataengine.utilities.TypeUtilities;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.conv.ConverterConstants;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public final class DataWrapper {
    private static Map<Integer, List<Class<?>>> TYPE_CLASSES_MAP = new HashMap();
    private static final Charset UTF8_CHARSET;
    private int m_type = 0;
    private Object m_value = null;
    private boolean m_bigIntWasSetAsLongThroughSetData;

    private static void addTypeClassesMap() {
        ArrayList<Class<Object>> arrayList = new ArrayList<Class<Object>>();
        arrayList.add(BigInteger.class);
        arrayList.add(Long.class);
        TYPE_CLASSES_MAP.put(-5, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Boolean.class);
        TYPE_CLASSES_MAP.put(-7, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Date.class);
        arrayList.add(java.util.Date.class);
        arrayList.add(Calendar.class);
        TYPE_CLASSES_MAP.put(91, arrayList);
        arrayList = new ArrayList();
        arrayList.add(BigDecimal.class);
        TYPE_CLASSES_MAP.put(3, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Double.class);
        TYPE_CLASSES_MAP.put(8, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Double.class);
        arrayList.add(Float.class);
        TYPE_CLASSES_MAP.put(6, arrayList);
        arrayList = new ArrayList();
        arrayList.add(UUID.class);
        TYPE_CLASSES_MAP.put(-11, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Long.class);
        arrayList.add(Integer.class);
        TYPE_CLASSES_MAP.put(4, arrayList);
        arrayList = new ArrayList();
        arrayList.add(BigDecimal.class);
        TYPE_CLASSES_MAP.put(2, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Float.class);
        TYPE_CLASSES_MAP.put(7, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Integer.class);
        arrayList.add(Short.class);
        TYPE_CLASSES_MAP.put(5, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Time.class);
        arrayList.add(TimeTz.class);
        arrayList.add(java.util.Date.class);
        arrayList.add(Calendar.class);
        TYPE_CLASSES_MAP.put(92, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Timestamp.class);
        arrayList.add(TimestampTz.class);
        arrayList.add(Date.class);
        arrayList.add(Time.class);
        arrayList.add(java.util.Date.class);
        arrayList.add(Calendar.class);
        TYPE_CLASSES_MAP.put(93, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Short.class);
        arrayList.add(Byte.class);
        TYPE_CLASSES_MAP.put(-6, arrayList);
        arrayList = new ArrayList();
        arrayList.add(byte[].class);
        arrayList.add(ByteArrayInputStream.class);
        TYPE_CLASSES_MAP.put(-2, arrayList);
        arrayList = new ArrayList();
        arrayList.add(byte[].class);
        arrayList.add(ByteArrayInputStream.class);
        TYPE_CLASSES_MAP.put(-4, arrayList);
        arrayList = new ArrayList();
        arrayList.add(byte[].class);
        arrayList.add(ByteArrayInputStream.class);
        TYPE_CLASSES_MAP.put(-3, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        arrayList.add(java.util.Date.class);
        arrayList.add(Calendar.class);
        arrayList.add(BigInteger.class);
        TYPE_CLASSES_MAP.put(1, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        arrayList.add(java.util.Date.class);
        arrayList.add(Calendar.class);
        arrayList.add(BigInteger.class);
        TYPE_CLASSES_MAP.put(-1, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        arrayList.add(java.util.Date.class);
        arrayList.add(Calendar.class);
        arrayList.add(BigInteger.class);
        TYPE_CLASSES_MAP.put(12, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Boolean.class);
        TYPE_CLASSES_MAP.put(16, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        TYPE_CLASSES_MAP.put(-8, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        TYPE_CLASSES_MAP.put(-9, arrayList);
        arrayList = new ArrayList();
        arrayList.add(String.class);
        TYPE_CLASSES_MAP.put(-10, arrayList);
        arrayList = new ArrayList();
        arrayList.add(DSITimeSpan.class);
        TYPE_CLASSES_MAP.put(103, arrayList);
        TYPE_CLASSES_MAP.put(108, arrayList);
        TYPE_CLASSES_MAP.put(109, arrayList);
        TYPE_CLASSES_MAP.put(110, arrayList);
        TYPE_CLASSES_MAP.put(104, arrayList);
        TYPE_CLASSES_MAP.put(111, arrayList);
        TYPE_CLASSES_MAP.put(112, arrayList);
        TYPE_CLASSES_MAP.put(105, arrayList);
        TYPE_CLASSES_MAP.put(113, arrayList);
        TYPE_CLASSES_MAP.put(106, arrayList);
        arrayList = new ArrayList();
        arrayList.add(DSIMonthSpan.class);
        TYPE_CLASSES_MAP.put(102, arrayList);
        TYPE_CLASSES_MAP.put(101, arrayList);
        TYPE_CLASSES_MAP.put(107, arrayList);
        arrayList = new ArrayList();
        arrayList.add(IArray.class);
        TYPE_CLASSES_MAP.put(2003, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Struct.class);
        TYPE_CLASSES_MAP.put(2002, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Object.class);
        TYPE_CLASSES_MAP.put(2000, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Object.class);
        TYPE_CLASSES_MAP.put(1111, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Object.class);
        TYPE_CLASSES_MAP.put(2012, arrayList);
    }

    public void copyData(DataWrapper dataWrapper) {
        this.m_type = dataWrapper.m_type;
        this.m_value = dataWrapper.m_value;
        this.m_bigIntWasSetAsLongThroughSetData = dataWrapper.m_bigIntWasSetAsLongThroughSetData;
    }

    public IArray getArray() throws IncorrectTypeException {
        if (2003 == this.m_type) {
            return (IArray)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public BigInteger getBigInt() throws IncorrectTypeException {
        if (-5 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof BigInteger) {
                return (BigInteger)this.m_value;
            }
            return BigInteger.valueOf((Long)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Long getBigIntAsLong() throws IncorrectTypeException {
        if (-5 == this.m_type) {
            if (this.m_value instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)this.m_value;
                return bigInteger.longValue();
            }
            return (Long)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public byte[] getBinary() throws IncorrectTypeException {
        if (-2 == this.m_type) {
            return this.getByteArray(this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Boolean getBit() throws IncorrectTypeException {
        if (-7 == this.m_type || 16 == this.m_type) {
            return (Boolean)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Boolean getBoolean() throws IncorrectTypeException {
        if (-7 == this.m_type || 16 == this.m_type) {
            return (Boolean)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public String getChar() throws IncorrectTypeException {
        if (1 == this.m_type || -8 == this.m_type) {
            return (String)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Date getDate() throws IncorrectTypeException {
        if (91 == this.m_type) {
            Date date = (Date)this.m_value;
            if (null == date) {
                return date;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(date.getTime());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return new Date(calendar.getTimeInMillis());
        }
        throw new IncorrectTypeException();
    }

    public BigDecimal getDecimal() throws IncorrectTypeException {
        if (3 == this.m_type) {
            return (BigDecimal)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Double getDouble() throws IncorrectTypeException {
        if (8 == this.m_type) {
            return (Double)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Double getFloat() throws IncorrectTypeException {
        if (6 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof Double) {
                return (Double)this.m_value;
            }
            return ((Float)this.m_value).floatValue();
        }
        throw new IncorrectTypeException();
    }

    public UUID getGuid() throws IncorrectTypeException {
        if (-11 == this.m_type) {
            return (UUID)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Long getInteger() throws IncorrectTypeException {
        if (4 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof Long) {
                return (Long)this.m_value;
            }
            return (long)((Integer)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Object getInterval() throws IncorrectTypeException {
        if (TypeUtilities.isIntervalType(this.m_type)) {
            return this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public byte[] getLongVarBinary() throws IncorrectTypeException {
        if (-4 == this.m_type) {
            return this.getByteArray(this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public String getLongVarChar() throws IncorrectTypeException {
        if (-1 == this.m_type || -10 == this.m_type) {
            return (String)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public BigDecimal getNumeric() throws IncorrectTypeException {
        if (2 == this.m_type) {
            return (BigDecimal)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Object getObject() {
        if (-5 == this.m_type && this.m_value instanceof Long && !this.m_bigIntWasSetAsLongThroughSetData) {
            this.m_value = BigInteger.valueOf((Long)this.m_value);
        }
        return this.m_value;
    }

    public Float getReal() throws IncorrectTypeException {
        if (7 == this.m_type) {
            return (Float)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Integer getSmallInt() throws IncorrectTypeException {
        if (5 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof Integer) {
                return (Integer)this.m_value;
            }
            return (int)((Short)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Time getTime() throws IncorrectTypeException {
        if (92 == this.m_type) {
            if (this.m_value instanceof TimeTz) {
                TimeTz timeTz = (TimeTz)this.m_value;
                Calendar calendar = timeTz.getTimezoneCalendar();
                calendar.clear();
                calendar.setTimeInMillis(timeTz.getTime());
                calendar.set(1, 1970);
                calendar.set(2, 0);
                calendar.set(5, 1);
                return new TimeTz(calendar.getTimeInMillis(), calendar);
            }
            if (this.m_value instanceof Time) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(((Time)this.m_value).getTime());
                calendar.set(1, 1970);
                calendar.set(2, 0);
                calendar.set(5, 1);
                Time time = (Time)((Time)this.m_value).clone();
                time.setTime(calendar.getTimeInMillis());
                return time;
            }
            if (null == this.m_value) {
                return (Time)this.m_value;
            }
        }
        throw new IncorrectTypeException();
    }

    public Timestamp getTimestamp() throws IncorrectTypeException {
        if (93 == this.m_type) {
            return (Timestamp)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public TimestampTz getTimestampTz() throws IncorrectTypeException {
        if (93 == this.m_type) {
            if (null == this.m_value) {
                return null;
            }
            if (this.m_value instanceof Timestamp && !(this.m_value instanceof TimestampTz)) {
                return new TimestampTz((Timestamp)this.m_value, Calendar.getInstance());
            }
            return (TimestampTz)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public TimeTz getTimeTz() throws IncorrectTypeException {
        if (92 == this.m_type) {
            if (null == this.m_value) {
                return null;
            }
            if (this.m_value instanceof Time && !(this.m_value instanceof TimeTz)) {
                return new TimeTz((Time)this.m_value, Calendar.getInstance());
            }
            return (TimeTz)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Short getTinyInt() throws IncorrectTypeException {
        if (-6 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof Short) {
                return (Short)this.m_value;
            }
            return (short)((Byte)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public int getType() {
        return this.m_type;
    }

    public byte[] getVarBinary() throws IncorrectTypeException {
        if (-3 == this.m_type) {
            return this.getByteArray(this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public String getVarChar() throws IncorrectTypeException {
        if (12 == this.m_type || -9 == this.m_type) {
            return (String)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public boolean isNull() {
        return null == this.m_value;
    }

    public boolean isSet() {
        return 0 != this.m_type;
    }

    public void setArray(IArray iArray) {
        this.m_type = 2003;
        this.m_value = iArray;
    }

    public void setBigInt(BigInteger bigInteger) {
        this.m_type = -5;
        this.m_value = bigInteger;
        this.m_bigIntWasSetAsLongThroughSetData = false;
    }

    public void setBigInt(long l) {
        this.m_type = -5;
        this.m_value = l;
        this.m_bigIntWasSetAsLongThroughSetData = false;
    }

    public void setBinary(byte[] byArray) {
        this.m_type = -2;
        this.m_value = byArray;
    }

    public void setBit(boolean bl) {
        this.m_type = -7;
        this.m_value = bl;
    }

    public void setBit(Boolean bl) {
        this.m_type = -7;
        this.m_value = bl;
    }

    public void setBoolean(boolean bl) {
        this.m_type = 16;
        this.m_value = bl;
    }

    public void setBoolean(Boolean bl) {
        this.m_type = 16;
        this.m_value = bl;
    }

    public void setChar(String string) {
        this.m_type = 1;
        this.m_value = string;
    }

    public void setData(int n, Object object) throws IncorrectTypeException {
        if (null == object) {
            this.setNull(n);
            return;
        }
        Object object2 = object;
        if (TypeUtilities.isCharacterType(n)) {
            if (object instanceof StringReader) {
                object2 = this.getString((StringReader)object);
            } else if (object instanceof ByteArrayInputStream || object instanceof byte[]) {
                byte[] byArray = this.getByteArray(object);
                object2 = TypeUtilities.isBinaryType(this.m_type) ? (Object)byArray : new String(byArray);
            } else {
                object2 = object.toString();
            }
        } else if (TypeUtilities.isBinaryType(n)) {
            object2 = this.getByteArray(object);
        } else {
            List<Class<?>> list = TYPE_CLASSES_MAP.get(n);
            if (null == list) {
                throw new IncorrectTypeException();
            }
            boolean bl = false;
            for (Class<?> clazz : list) {
                if (!clazz.isInstance(object2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IncorrectTypeException();
            }
            if (-5 == n) {
                this.m_bigIntWasSetAsLongThroughSetData = this.m_value instanceof Long;
            }
        }
        this.m_type = n;
        if (93 == n) {
            if (object2 instanceof Time) {
                this.m_value = new Timestamp(((Time)object2).getTime());
            } else if (object2 instanceof java.util.Date) {
                this.m_value = object2 instanceof Timestamp ? object2 : new Timestamp(((java.util.Date)object2).getTime());
            } else if (object2 instanceof Calendar) {
                this.m_value = new Timestamp(((Calendar)object2).getTime().getTime());
            }
        } else {
            this.m_value = object2;
        }
    }

    public void setDate(int n, int n2, int n3) {
        this.m_type = 91;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (n < 0) {
            n *= -1;
            calendar.set(0, 0);
        }
        calendar.set(n, n2, n3, 0, 0, 0);
        this.m_value = new Date(calendar.getTimeInMillis());
    }

    public void setDate(Date date) {
        this.m_type = 91;
        this.m_value = date;
    }

    public void setDecimal(BigDecimal bigDecimal) {
        this.m_type = 3;
        this.m_value = bigDecimal;
    }

    public void setDouble(double d) {
        this.m_type = 8;
        this.m_value = new Double(d);
    }

    public void setDouble(Double d) {
        this.m_type = 8;
        this.m_value = d;
    }

    public void setFloat(double d) {
        this.m_type = 6;
        this.m_value = new Double(d);
    }

    public void setFloat(Double d) {
        this.m_type = 6;
        this.m_value = d;
    }

    public void setGuid(UUID uUID) {
        this.m_type = -11;
        this.m_value = uUID;
    }

    public void setInteger(long l) {
        this.m_type = 4;
        this.m_value = l;
    }

    public void setInteger(Long l) {
        this.m_type = 4;
        this.m_value = l;
    }

    public void setInterval(Object object) {
        if (object instanceof DSIMonthSpan) {
            this.m_type = ((DSIMonthSpan)object).getIntervalType();
            this.m_value = object;
        } else if (object instanceof DSITimeSpan) {
            this.m_type = ((DSITimeSpan)object).getIntervalType();
            this.m_value = object;
        }
    }

    public void setLongVarBinary(byte[] byArray) {
        this.m_type = -4;
        this.m_value = byArray;
    }

    public void setLongVarChar(String string) {
        this.m_type = -1;
        this.m_value = string;
    }

    public void setNull(int n) {
        this.m_type = n;
        this.m_value = null;
    }

    public void setNumeric(BigDecimal bigDecimal) {
        this.m_type = 2;
        this.m_value = bigDecimal;
    }

    public void setReal(float f) {
        this.m_type = 7;
        this.m_value = new Float(f);
    }

    public void setReal(Float f) {
        this.m_type = 7;
        this.m_value = f;
    }

    public void setSmallInt(int n) {
        this.m_type = 5;
        this.m_value = n;
    }

    public void setSmallInt(Integer n) {
        this.m_type = 5;
        this.m_value = n;
    }

    public void setTime(int n, int n2, int n3) {
        this.m_type = 92;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, n, n2, n3);
        calendar.set(14, 0);
        this.m_value = new Time(calendar.getTimeInMillis());
    }

    public void setTime(int n, int n2, int n3, int n4) {
        this.m_type = 92;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, n, n2, n3);
        calendar.set(14, n4 / 1000000);
        this.m_value = new Time(calendar.getTimeInMillis());
    }

    public void setTime(Time time) {
        this.m_type = 92;
        this.m_value = time;
    }

    public void setTime(TimeTz timeTz) {
        this.m_type = 92;
        this.m_value = timeTz;
    }

    public void setTimestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.m_type = 93;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (n < 0) {
            n *= -1;
            calendar.set(0, 0);
        }
        calendar.set(n, n2, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n7);
        this.m_value = timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.m_type = 93;
        this.m_value = timestamp;
    }

    public void setTimestamp(TimestampTz timestampTz) {
        this.m_type = 93;
        this.m_value = timestampTz;
    }

    public void setTinyInt(short s) {
        this.m_type = -6;
        this.m_value = s;
    }

    public void setTinyInt(Short s) {
        this.m_type = -6;
        this.m_value = s;
    }

    public void setVarBinary(byte[] byArray) {
        this.m_type = -3;
        this.m_value = byArray;
    }

    public void setVarChar(String string) {
        this.m_type = 12;
        this.m_value = string;
    }

    public void setWVarChar(String string) {
        this.m_type = -9;
        this.m_value = string;
    }

    public void setWChar(String string) {
        this.m_type = -8;
        this.m_value = string;
    }

    public void setWLongVarChar(String string) {
        this.m_type = -10;
        this.m_value = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_type);
        stringBuilder.append("|");
        if (this.isNull()) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(this.m_value.toString());
        }
        return stringBuilder.toString();
    }

    private byte[] getByteArray(Object object) throws IncorrectTypeException {
        if (null == object || object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof ByteArrayInputStream) {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)object;
            byte[] byArray = new byte[byteArrayInputStream.available()];
            try {
                byteArrayInputStream.read(byArray);
            }
            catch (IOException iOException) {
                return null;
            }
            return byArray;
        }
        throw new IncorrectTypeException();
    }

    private String getString(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            while (-1 != (n = ((Reader)bufferedReader).read())) {
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private final byte[] getCharAsUTF8() {
        return ((String)this.m_value).getBytes(UTF8_CHARSET);
    }

    private final byte[] getVarCharAsUTF8() throws IncorrectTypeException {
        return ((String)this.m_value).getBytes(UTF8_CHARSET);
    }

    private final byte[] getLongVarCharAsUTF8() throws IncorrectTypeException {
        return ((String)this.m_value).getBytes(UTF8_CHARSET);
    }

    private final void setCharWithUTF8(byte[] byArray) {
        this.m_type = 1;
        this.m_value = null != byArray ? new String(byArray, UTF8_CHARSET) : null;
    }

    private final void setVarCharWithUTF8(byte[] byArray) {
        this.m_type = 12;
        this.m_value = null != byArray ? new String(byArray, UTF8_CHARSET) : null;
    }

    private final void setLongVarCharWithUTF8(byte[] byArray) {
        this.m_type = -1;
        this.m_value = null != byArray ? new String(byArray, UTF8_CHARSET) : null;
    }

    private final String getUnsignedBigintAsString() {
        return this.m_value.toString();
    }

    private final long getSignedBigint() {
        return ((Number)this.m_value).longValue();
    }

    private final boolean getBitPrimitive() {
        return (Boolean)this.m_value;
    }

    private final double getDoublePrimitive() {
        return ((Number)this.m_value).doubleValue();
    }

    private final double getFloatPrimitive() {
        return ((Number)this.m_value).doubleValue();
    }

    private final long getUnsignedInteger() {
        return ((Number)this.m_value).longValue();
    }

    private final int getSignedInteger() {
        return ((Number)this.m_value).intValue();
    }

    private final float getRealPrimitive() {
        return ((Number)this.m_value).floatValue();
    }

    private final int getUnsignedSmallint() {
        return ((Number)this.m_value).intValue();
    }

    private final short getSignedSmallint() {
        return ((Number)this.m_value).shortValue();
    }

    private final short getUnsignedTinyint() {
        return ((Number)this.m_value).shortValue();
    }

    private final byte getSignedTinyint() {
        return ((Number)this.m_value).byteValue();
    }

    private final void setMonthSpan(int n, int n2, int n3, boolean bl) {
        this.m_value = new DSIMonthSpan(n, n2, n3, bl);
        this.m_type = n;
    }

    private final void setTimeSpan(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.m_value = new DSITimeSpan(n, n2, n3, n4, n5, n6, bl);
        this.m_type = n;
    }

    private final void setTimestamp(long l, int n) {
        long l2 = l * 1000L;
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        int n2 = timeZone.getOffset(l2 - (long)timeZone.getRawOffset());
        l2 -= (long)n2;
        if (93 == this.m_type && null != this.m_value) {
            ((Timestamp)this.m_value).setTime(l2);
        } else {
            this.m_value = new Timestamp(l2);
            this.m_type = 93;
        }
        ((Timestamp)this.m_value).setNanos(n);
    }

    private final void setUnsignedBigInt(long l) {
        this.setBigInt(BigInteger.valueOf(l).and(ConverterConstants.UNSIGNED_BIGINT_MAX));
    }

    private final void unpackDate(long l) throws IncorrectTypeException {
        assert (0L != l) : "The given native pointer should not be NULL.";
        if (91 != this.m_type) {
            throw new IncorrectTypeException();
        }
        Date date = (Date)this.m_value;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        boolean bl = calendar.get(0) == 0;
        int n = bl ? calendar.get(1) * -1 : calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        this.unpackDateNative(l, n, n2, n3);
    }

    private final native void unpackDateNative(long var1, int var3, int var4, int var5);

    private final void unpackTime(long l) throws IncorrectTypeException {
        Time time;
        assert (0L != l) : "The given native pointer should not be NULL.";
        Calendar calendar = Calendar.getInstance();
        if (92 == this.m_type) {
            time = (Time)this.m_value;
            if (this.m_value instanceof TimeTz) {
                calendar = ((TimeTz)this.m_value).getTimezoneCalendar();
                calendar.clear();
            }
        } else {
            throw new IncorrectTypeException();
        }
        calendar.setTimeInMillis(time.getTime());
        this.unpackTimeNative(l, calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
    }

    private final native void unpackTimeNative(long var1, int var3, int var4, int var5, int var6);

    private final void unpackTimestamp(long l) throws IncorrectTypeException {
        assert (0L != l) : "The given native pointer should not be NULL.";
        Timestamp timestamp = this.getTimestamp();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        boolean bl = calendar.get(0) == 0;
        int n = bl ? calendar.get(1) * -1 : calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = timestamp.getNanos();
        this.unpackTimestampNative(l, n, n2, n3, n4, n5, n6, n7);
    }

    private final native void unpackTimestampNative(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private final void unpackInterval(long l) {
        assert (0L != l) : "The given native pointer should not be NULL.";
        assert (null != this.m_value) : "The stored value should be non-null.";
        switch (this.m_type) {
            case 101: 
            case 102: 
            case 107: {
                DSIMonthSpan dSIMonthSpan = (DSIMonthSpan)this.m_value;
                DataWrapper.unpackMonthSpan(l, this.m_type, dSIMonthSpan.getYear(), dSIMonthSpan.getMonth(), dSIMonthSpan.isNegative());
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                DSITimeSpan dSITimeSpan = (DSITimeSpan)this.m_value;
                DataWrapper.unpackTimeSpan(l, this.m_type, dSITimeSpan.getDay(), dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction(), dSITimeSpan.isNegative());
                break;
            }
            default: {
                assert (false) : this.m_type + " is not an interval type!";
                break;
            }
        }
    }

    private static final native void unpackMonthSpan(long var0, int var2, int var3, int var4, boolean var5);

    private static final native void unpackTimeSpan(long var0, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    static {
        DataWrapper.addTypeClassesMap();
        UTF8_CHARSET = Charset.forName("UTF-8");
    }
}

