/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.activity.IDSSUsageStatsInternalDB;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.LongDataMatrix;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.queries.CreateIndexQueryBuilder;
import com.dataiku.dip.sql.queries.CreateTableQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import com.dataiku.dip.sql.queries.UpsertQueryBuilder;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.LazyHashMap;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DSSUsageStatsInternalDB
extends AbstractDSSDBService
implements IDSSUsageStatsInternalDB {
    private static final String DB_NAME = "dss_usage";
    public static final int SCHEMA_VERSION = 3;
    private static final int CACHE_EXPIRES = 3600;
    private static final String TIMESTAMP_COLUMN = "TIMESTAMP";
    private static final String AUTHOR_COLUMN = "AUTHOR";
    private static final String ADDED_LINES_COLUMN = "ADDED_LINES";
    private static final String REMOVED_LINES_COLUMN = "REMOVED_LINES";
    private static final String PROJECT_KEY_COLUMN = "PROJECT_KEY";
    private static final String COMMIT_ID_COLUMN = "COMMIT_ID";
    private static final String DAY_COLUMN = "DAY";
    private static final String COUNT_COLUMN = "COUNT";
    private static final String HOUR_COLUMN = "HOUR";
    private static final String TIME_COLUMN = "TIME";
    private static final String PRESENCE_COLUMN = "PRESENCE";
    private static final String NB_DISTINCT_HOURS_COLUMN = "NB_DISTINCT_HOURS";
    private static final String NB_COMMITS_COLUMN = "NB_COMMITS";
    private static final String USER_COLUMN = "USER";
    private static final String TASK_TYPE_COLUMN = "TASK_TYPE";
    private static final String START_TIME_COLUMN = "START_TIME";
    private static final String END_TIME_COLUMN = "END_TIME";
    private static final String CONNECTION_COLUMN = "CONNECTION";
    private static final String TASK_DATA_COLUMN = "TASK_DATA";
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private final String storeUserPresences = InsertQueryBuilder.insertInto(this.resolveTable("USER_PRESENCE_HISTORY")).addColumns(userPresenceHistoryColumns).toSQL(this.getDialect());
    private final String storeProjectSave = UpsertQueryBuilder.into(this.resolveTable("PROJECT_SAVES_BY_HOUR")).addColumns(projectSavesByHourColumns).addKeyColumns(projectSavesByHourIndex).toSQL(this.getDialect());
    private final String storeCommitsAnalysis = UpsertQueryBuilder.into(this.resolveTable("COMMITS_STATS")).addColumns(commitStatsColumns).addKeyColumns(commitStatsIndex).toSQL(this.getDialect());
    private final String updateLastAnalyzedCommitsTable = UpsertQueryBuilder.into(this.resolveTable("LAST_ANALYZED_COMMITS")).addColumns(lastAnalyzedCommitsColumns).addKeyColumns(lastAnalyzedCommitsIndex).toSQL(this.getDialect());
    private final String minHourFromUserPresenceHistory = SimpleSelectQueryBuilder.select("HOUR").from(this.resolveTable("USER_PRESENCE_HISTORY"), "USER_PRESENCE_HISTORY").wheres("PROJECT_KEY").orderedBy("HOUR").first().toSQL(this.getDialect());
    private final String minHourFromProjectSavesByHour = SimpleSelectQueryBuilder.select("HOUR").from(this.resolveTable("PROJECT_SAVES_BY_HOUR"), "PROJECT_SAVES_BY_HOUR").wheres("PROJECT_KEY").orderedBy("HOUR").first().toSQL(this.getDialect());
    private final String minTimestampFromCommitStats = SimpleSelectQueryBuilder.select("TIMESTAMP").from(this.resolveTable("COMMITS_STATS"), "COMMITS_STATS").wheres("PROJECT_KEY").orderedBy("TIMESTAMP").first().toSQL(this.getDialect());
    private final String timestampFromLastAnalyzedCommits = SimpleSelectQueryBuilder.select("TIMESTAMP").from(this.resolveTable("LAST_ANALYZED_COMMITS"), "LAST_ANALYZED_COMMITS").wheres("PROJECT_KEY").toSQL(this.getDialect());
    private static final String commitStatsTable = "COMMITS_STATS";
    private static final SchemaColumn[] commitStatsColumns = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("COMMIT_ID", Type.STRING), new SchemaColumn("AUTHOR", Type.STRING), new SchemaColumn("TIMESTAMP", Type.BIGINT), new SchemaColumn("ADDED_FILES", Type.INT), new SchemaColumn("ADDED_LINES", Type.INT), new SchemaColumn("REMOVED_FILES", Type.INT), new SchemaColumn("REMOVED_LINES", Type.INT), new SchemaColumn("CHANGED_FILES", Type.INT)};
    private static final String[] commitStatsIndex = new String[]{"PROJECT_KEY", "COMMIT_ID"};
    private static final String lastAnalyzedCommitsTable = "LAST_ANALYZED_COMMITS";
    private static final SchemaColumn[] lastAnalyzedCommitsColumns = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("TIMESTAMP", Type.BIGINT)};
    private static final String[] lastAnalyzedCommitsIndex = new String[]{"PROJECT_KEY"};
    private static final String connectionTasksTable = "CONNECTION_TASKS";
    private static final SchemaColumn[] connectionTasksColumns = new SchemaColumn[]{new SchemaColumn("CONNECTION", Type.STRING), new SchemaColumn("TASK_TYPE", Type.STRING), new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("TASK_DATA", Type.STRING), new SchemaColumn("USER", Type.STRING), new SchemaColumn("START_TIME", Type.BIGINT), new SchemaColumn("END_TIME", Type.BIGINT)};
    private static final String userPresenceHistoryTable = "USER_PRESENCE_HISTORY";
    private static final SchemaColumn[] userPresenceHistoryColumns = new SchemaColumn[]{new SchemaColumn("INSERT_TIME", Type.BIGINT), new SchemaColumn("USER", Type.STRING), new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("HOUR", Type.BIGINT), new SchemaColumn("PRESENCE", Type.INT)};
    private static final String projectSavesByHourTable = "PROJECT_SAVES_BY_HOUR";
    private static final SchemaColumn[] projectSavesByHourColumns = new SchemaColumn[]{new SchemaColumn("USER", Type.STRING), new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("HOUR", Type.BIGINT)};
    private static final String[] projectSavesByHourIndex = new String[]{"USER", "PROJECT_KEY", "HOUR"};
    public static final List<String> TABLES = ImmutableList.of((Object)"COMMITS_STATS", (Object)"LAST_ANALYZED_COMMITS", (Object)"CONNECTION_TASKS", (Object)"USER_PRESENCE_HISTORY", (Object)"PROJECT_SAVES_BY_HOUR");
    private LoadingCache<String, Long> firstDataTimeCache = CacheBuilder.newBuilder().expireAfterWrite(3600L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Long>(){

        public Long load(String projectKey) throws Exception {
            return DSSUsageStatsInternalDB.this.getFirstDataTime(projectKey);
        }
    });
    private LoadingCache<String, IDSSUsageStatsInternalDB.TimeSeries> globalCommitsCache = CacheBuilder.newBuilder().expireAfterWrite(3600L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, IDSSUsageStatsInternalDB.TimeSeries>(){

        public IDSSUsageStatsInternalDB.TimeSeries load(String ckey) throws Exception {
            String[] chunks = ckey.split("@@@");
            return DSSUsageStatsInternalDB.this.getGlobalCommits(chunks[0], Long.parseLong(chunks[1]));
        }
    });
    private static DKULogger logger = DKULogger.getLogger((String)"dku.stats.db");

    public DSSUsageStatsInternalDB() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 3, true);
    }

    @PostConstruct
    public void init() throws SQLException {
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws CodedSQLException {
        block25: {
            try {
                if (currentSchemaVersion == 0) {
                    try (Statement st2 = conn.createStatement();){
                        CreateTableQueryBuilder.createTable(this.resolveTable(commitStatsTable)).addColumns(commitStatsColumns).addKeyColumns(commitStatsIndex).execute(st2, this.getDialect());
                        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(commitStatsTable)).addColumns(PROJECT_KEY_COLUMN, TIMESTAMP_COLUMN).execute(st2, this.getDialect());
                        CreateTableQueryBuilder.createTable(this.resolveTable(lastAnalyzedCommitsTable)).addColumns(lastAnalyzedCommitsColumns).addKeyColumns(lastAnalyzedCommitsIndex).execute(st2, this.getDialect());
                        CreateTableQueryBuilder.createTable(this.resolveTable(connectionTasksTable)).addColumns(connectionTasksColumns).execute(st2, this.getDialect());
                        CreateTableQueryBuilder.createTable(this.resolveTable(userPresenceHistoryTable)).addColumns(userPresenceHistoryColumns).execute(st2, this.getDialect());
                        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(userPresenceHistoryTable)).addColumns(PROJECT_KEY_COLUMN, HOUR_COLUMN).execute(st2, this.getDialect());
                        CreateTableQueryBuilder.createTable(this.resolveTable(projectSavesByHourTable)).addColumns(projectSavesByHourColumns).addKeyColumns(projectSavesByHourIndex).execute(st2, this.getDialect());
                        break block25;
                    }
                }
                if (currentSchemaVersion == 1) {
                    try (Statement st3 = conn.createStatement();){
                        st3.execute("select index_name from information_schema.indexes where table_name = 'COMMITS_STATS'");
                        ResultSet rs2 = st3.getResultSet();
                        if (rs2 != null) {
                            HashSet<String> indexesToDelete = new HashSet<String>();
                            while (rs2.next()) {
                                indexesToDelete.add(rs2.getString(1));
                            }
                            logger.info((Object)("Deleting " + indexesToDelete.size() + " indexes"));
                            for (String index : indexesToDelete) {
                                st3.execute("drop index " + index);
                            }
                        }
                        st3.execute("create index on commits_stats (project_key, timestamp);");
                        this.switchAllTimestampColumns(st3);
                        break block25;
                    }
                }
                if (currentSchemaVersion != 2) break block25;
                try (Statement st4 = conn.createStatement();){
                    this.switchAllTimestampColumns(st4);
                }
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access internal database", (Throwable)e);
            }
        }
    }

    @Override
    public void storeUserPresences(List<IDSSUsageStatsInternalDB.UserPresenceItem> items) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement insert = this.getPreparedStatement(ac, this.storeUserPresences);
            for (IDSSUsageStatsInternalDB.UserPresenceItem item : items) {
                insert.setLong(1, System.currentTimeMillis());
                insert.setString(2, item.user);
                insert.setString(3, item.projectKey);
                insert.setLong(4, item.hourTimestamp);
                insert.setInt(5, (int)item.presenceTime);
                insert.addBatch();
            }
            insert.executeBatch();
            ac.commit();
        }
    }

    @Override
    public void storeProjectSave(String projectKey, String user, long hourTimestamp) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement insert = this.getPreparedStatement(ac, this.storeProjectSave);
            insert.setString(1, user);
            insert.setString(2, projectKey);
            insert.setLong(3, hourTimestamp);
            insert.execute();
            ac.commit();
        }
    }

    @Override
    public void storeCommitsAnalysis(String projectKey, List<IDSSUsageStatsInternalDB.CommitAnalysis> commits, long newLast) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement insert = this.getPreparedStatement(ac, this.storeCommitsAnalysis);
            for (IDSSUsageStatsInternalDB.CommitAnalysis ca : commits) {
                insert.setString(1, ca.projectKey);
                insert.setString(2, ca.commitId);
                insert.setString(3, ca.author);
                insert.setLong(4, ca.timestamp);
                insert.setInt(5, ca.addedFiles);
                insert.setInt(6, ca.addedLines);
                insert.setInt(7, ca.removedFiles);
                insert.setInt(8, ca.removedLines);
                insert.setInt(9, ca.changedFiles);
                insert.addBatch();
            }
            insert.executeBatch();
            PreparedStatement st2 = this.getPreparedStatement(ac, this.updateLastAnalyzedCommitsTable);
            st2.setString(1, projectKey);
            st2.setLong(2, newLast);
            st2.execute();
            ac.commit();
        }
    }

    protected String getList(SchemaColumn[] ... columnGroups) {
        return this.getList("", columnGroups);
    }

    protected String getList(String prefix, SchemaColumn[] ... columnGroups) {
        ArrayList columns = Lists.newArrayList();
        SchemaColumn[][] schemaColumnArray = columnGroups;
        int n = schemaColumnArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaColumn[] columnGroup;
            for (SchemaColumn column : columnGroup = schemaColumnArray[i]) {
                columns.add(this.getDialect().quoteIdentifier(column.getName()));
            }
        }
        return prefix + Joiner.on((String)(", " + prefix)).join((Iterable)columns);
    }

    private long timeStampForProjectQuery(String query, String projectKey, DSSDBConnection ac, long defaultTS) throws SQLException {
        PreparedStatement st2 = this.getPreparedStatement(ac, query);
        st2.setString(1, projectKey);
        st2.execute();
        ResultSet rs2 = st2.getResultSet();
        if (rs2.next()) {
            return rs2.getLong(1);
        }
        return defaultTS;
    }

    @Override
    public long getFirstDataTime_cached(String projectKey) throws ExecutionException {
        return (Long)this.firstDataTimeCache.get((Object)projectKey);
    }

    @Override
    public long getFirstDataTime(String projectKey) throws SQLException {
        long min = System.currentTimeMillis();
        try (DSSDBConnection ac = this.acquireConnection(true);){
            min = Math.min(min, this.timeStampForProjectQuery(this.minHourFromUserPresenceHistory, projectKey, ac, min));
            min = Math.min(min, this.timeStampForProjectQuery(this.minHourFromProjectSavesByHour, projectKey, ac, min));
            long l = min = Math.min(min, this.timeStampForProjectQuery(this.minTimestampFromCommitStats, projectKey, ac, min));
            return l;
        }
    }

    @Override
    public long getLastAnalyzedHour(String projectKey) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection(true);){
            long l = this.timeStampForProjectQuery(this.timestampFromLastAnalyzedCommits, projectKey, ac, 0L);
            return l;
        }
    }

    @Override
    public void storeConnectionTask(IDSSUsageStatsInternalDB.ConnectionTask connTask) throws SQLException {
        logger.debugV("Storing connection task %s", new Object[]{JSON.json((Object)connTask)});
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable(connectionTasksTable)).addColumns(connectionTasksColumns).toSQL(this.getDialect()));){
                insert.setString(1, connTask.connectionId);
                insert.setString(2, connTask.taskType.toString());
                insert.setString(3, connTask.projectKey);
                insert.setString(4, JSON.json((Object)connTask.taskData));
                insert.setString(5, connTask.initiator);
                insert.setLong(6, connTask.startTime);
                insert.setLong(7, connTask.endTime);
                insert.execute();
            }
            ac.commit();
        }
    }

    @Override
    public IDSSUsageStatsInternalDB.ContributorsChartData getContributorsChart(String projectKey) throws SQLException, ParseException {
        try (DSSDBConnection ac = this.acquireConnection();){
            logger.infoV("Computing contributors chart data for %s", new Object[]{projectKey});
            SimpleDateFormat sdf = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM-dd");
            long minTS = Long.MAX_VALUE;
            long maxTS = Long.MIN_VALUE;
            HashSet<String> authors = new HashSet<String>();
            ExpressionBuilder timestampDayBuilder = this.dayBuilder(TIMESTAMP_COLUMN);
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(commitStatsTable), commitStatsTable);
            sqb.select(EBF.col(AUTHOR_COLUMN));
            sqb.select(timestampDayBuilder, DAY_COLUMN);
            sqb.where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.col(AUTHOR_COLUMN).nullUnsafeEq(EBF.cst("no:auth")).not())).group(AUTHOR_COLUMN).group(timestampDayBuilder);
            try (PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                st2.setString(1, projectKey);
                st2.execute();
                ResultSet rs2 = st2.getResultSet();
                while (rs2.next()) {
                    String author = rs2.getString(AUTHOR_COLUMN);
                    String day = rs2.getString(DAY_COLUMN);
                    long dayTS = sdf.parse(day).getTime();
                    minTS = Math.min(minTS, dayTS);
                    maxTS = Math.max(maxTS, dayTS);
                    authors.add(author);
                }
            }
            int nbBuckets = DKUDateUtils.daysBetweenUTC((long)minTS, (long)maxTS) + 1;
            logger.infoV("have %d day buckets between %s and %s ", new Object[]{nbBuckets, DKUDateUtils.isoFormatUTC((long)minTS), DKUDateUtils.isoFormatUTC((long)maxTS)});
            IDSSUsageStatsInternalDB.ContributorsChartData ret = new IDSSUsageStatsInternalDB.ContributorsChartData();
            ret.minTS = minTS;
            ret.maxTS = maxTS;
            for (String author : authors) {
                IDSSUsageStatsInternalDB.ContributorData cd = new IDSSUsageStatsInternalDB.ContributorData();
                cd.contributor = author;
                cd.commits = LongDataList.createNoMinMax(nbBuckets);
                cd.added = LongDataList.createNoMinMax(nbBuckets);
                cd.removed = LongDataList.createNoMinMax(nbBuckets);
                ret.perContributor.put(author, cd);
            }
            ret.global = new IDSSUsageStatsInternalDB.ContributorData();
            ret.global.commits = LongDataList.createNoMinMax(nbBuckets);
            ret.global.added = LongDataList.createNoMinMax(nbBuckets);
            ret.global.removed = LongDataList.createNoMinMax(nbBuckets);
            ret.bucketsTS = IDSSUsageStatsInternalDB.TimeSeries.daily((long)minTS, (int)nbBuckets).dayTS;
            sqb.select(EBF.count("*"), COUNT_COLUMN);
            sqb.select(EBF.col(ADDED_LINES_COLUMN).sum(), ADDED_LINES_COLUMN);
            sqb.select(EBF.col(REMOVED_LINES_COLUMN).sum(), REMOVED_LINES_COLUMN);
            sqb.where(EBF.col(AUTHOR_COLUMN).nullUnsafeEq(EBF.cst("no:auth")).not());
            try (PreparedStatement st3 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                st3.setString(1, projectKey);
                st3.execute();
                ResultSet rs3 = st3.getResultSet();
                while (rs3.next()) {
                    String author = rs3.getString(AUTHOR_COLUMN);
                    IDSSUsageStatsInternalDB.ContributorData cd = ret.perContributor.get(author);
                    assert (cd != null);
                    String day = rs3.getString(DAY_COLUMN);
                    long dayTS = sdf.parse(day).getTime();
                    int bucket = DKUDateUtils.daysBetweenUTC((long)minTS, (long)dayTS);
                    ret.bucketsTS.data[bucket] = dayTS;
                    long commits = rs3.getLong(COUNT_COLUMN);
                    long added = rs3.getLong(ADDED_LINES_COLUMN);
                    long removed = rs3.getLong(REMOVED_LINES_COLUMN);
                    int n = bucket;
                    ret.global.commits.data[n] = ret.global.commits.data[n] + commits;
                    int n2 = bucket;
                    cd.commits.data[n2] = cd.commits.data[n2] + commits;
                    int n3 = bucket;
                    ret.global.added.data[n3] = ret.global.added.data[n3] + added;
                    int n4 = bucket;
                    cd.added.data[n4] = cd.added.data[n4] + added;
                    int n5 = bucket;
                    ret.global.removed.data[n5] = ret.global.removed.data[n5] + removed;
                    int n6 = bucket;
                    cd.removed.data[n6] = cd.removed.data[n6] + removed;
                }
            }
            logger.infoV("Done computing contributors chart data", new Object[0]);
            IDSSUsageStatsInternalDB.ContributorsChartData contributorsChartData = ret;
            return contributorsChartData;
        }
    }

    @Override
    public IDSSUsageStatsInternalDB.TimeSeries getProjectPresenceData(String projectKey, long since) throws SQLException, ParseException {
        try (DSSDBConnection ac = this.acquireConnection();){
            SimpleDateFormat sdf = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM-dd");
            long now = System.currentTimeMillis();
            int nbBuckets = DKUDateUtils.daysBetweenUTC((long)since, (long)now) + 1;
            IDSSUsageStatsInternalDB.TimeSeries ret = IDSSUsageStatsInternalDB.TimeSeries.daily(since, nbBuckets);
            ExpressionBuilder dayBuilder = this.dayBuilder(HOUR_COLUMN);
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(userPresenceHistoryTable), userPresenceHistoryTable);
            sqb.select(dayBuilder, DAY_COLUMN);
            sqb.select(EBF.col(PRESENCE_COLUMN).sum(), TIME_COLUMN);
            sqb.where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(HOUR_COLUMN, QueryUtils.OperatorType.GT))).group(dayBuilder);
            try (PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                st2.setString(1, projectKey);
                st2.setLong(2, since);
                logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
                st2.execute();
                ResultSet rs2 = st2.getResultSet();
                while (rs2.next()) {
                    long dayTS = sdf.parse(rs2.getString(DAY_COLUMN)).getTime();
                    int bucket = DKUDateUtils.daysBetweenUTC((long)since, (long)dayTS);
                    ret.dayTS.data[bucket] = dayTS;
                    ret.value.data[bucket] = rs2.getLong(TIME_COLUMN);
                }
            }
            logger.infoV("Done computing user presence project data", new Object[0]);
            IDSSUsageStatsInternalDB.TimeSeries timeSeries = ret;
            return timeSeries;
        }
    }

    @Override
    public IDSSUsageStatsInternalDB.TimeSeries getGlobalProjectHoursWithWrites(String projectKey, long since) throws SQLException, ParseException {
        try (DSSDBConnection ac = this.acquireConnection();){
            SimpleDateFormat sdf = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM-dd");
            long now = System.currentTimeMillis();
            int nbBuckets = DKUDateUtils.daysBetweenUTC((long)since, (long)now) + 1;
            IDSSUsageStatsInternalDB.TimeSeries ret = IDSSUsageStatsInternalDB.TimeSeries.daily(since, nbBuckets);
            ExpressionBuilder dayBuilder = this.dayBuilder(HOUR_COLUMN);
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(projectSavesByHourTable), projectSavesByHourTable);
            sqb.select(dayBuilder, DAY_COLUMN);
            sqb.select(this.dateBuilder(HOUR_COLUMN).format(Type.DATE, "HH").distinct().count(), NB_DISTINCT_HOURS_COLUMN);
            sqb.where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(HOUR_COLUMN, QueryUtils.OperatorType.GT))).group(dayBuilder);
            try (PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                st2.setString(1, projectKey);
                st2.setLong(2, since);
                logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
                st2.execute();
                ResultSet rs2 = st2.getResultSet();
                while (rs2.next()) {
                    long dayTS = sdf.parse(rs2.getString(DAY_COLUMN)).getTime();
                    int bucket = DKUDateUtils.daysBetweenUTC((long)since, (long)dayTS);
                    ret.dayTS.data[bucket] = dayTS;
                    ret.value.data[bucket] = rs2.getLong(NB_DISTINCT_HOURS_COLUMN);
                }
            }
            if (logger.isTraceEnabled()) {
                logger.traceV("Done computing user presence project data: " + JSON.json((Object)ret), new Object[0]);
            }
            IDSSUsageStatsInternalDB.TimeSeries timeSeries = ret;
            return timeSeries;
        }
    }

    @Override
    public LongDataMatrix getTotalCommitsPerHour(String projectKey, long since) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            LongDataMatrix ret = new LongDataMatrix(24, 7);
            ExpressionBuilder dateBuilder = this.dateBuilder(TIMESTAMP_COLUMN);
            ExpressionBuilder dayOfWeekBuilder = dateBuilder.datePart(DatePart.DAY_OF_WEEK.name()).mod(7).plus(1);
            ExpressionBuilder hourOfDayBuilder = dateBuilder.datePart(DatePart.HOUR_OF_DAY.name());
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(commitStatsTable), commitStatsTable);
            sqb.select(dayOfWeekBuilder, DAY_COLUMN);
            sqb.select(hourOfDayBuilder, HOUR_COLUMN);
            sqb.select(EBF.count("*"), NB_COMMITS_COLUMN);
            sqb.where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(TIMESTAMP_COLUMN, QueryUtils.OperatorType.GT)).and(EBF.col(AUTHOR_COLUMN).nullUnsafeEq(EBF.cst("no:auth")).not())).group(dayOfWeekBuilder).group(hourOfDayBuilder);
            try (PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                st2.setString(1, projectKey);
                st2.setLong(2, since);
                logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
                st2.execute();
                ResultSet rs2 = st2.getResultSet();
                while (rs2.next()) {
                    ret.put(rs2.getInt(HOUR_COLUMN), rs2.getInt(DAY_COLUMN) - 1, rs2.getLong(NB_COMMITS_COLUMN));
                }
            }
            if (logger.isTraceEnabled()) {
                logger.traceV("Done computing total commits per hour: " + JSON.json((Object)ret), new Object[0]);
            }
            LongDataMatrix longDataMatrix = ret;
            return longDataMatrix;
        }
    }

    @Override
    public IDSSUsageStatsInternalDB.TimeSeries getGlobalCommits(String projectKey, long since) throws SQLException, ParseException {
        try (DSSDBConnection ac = this.acquireConnection(true);){
            SimpleDateFormat sdf = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM-dd");
            long now = System.currentTimeMillis();
            int nbBuckets = DKUDateUtils.daysBetweenUTC((long)since, (long)now) + 1;
            IDSSUsageStatsInternalDB.TimeSeries ret = IDSSUsageStatsInternalDB.TimeSeries.daily(since, nbBuckets);
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(commitStatsTable), commitStatsTable);
            ExpressionBuilder dayBuilder = this.dayBuilder(TIMESTAMP_COLUMN);
            sqb.select(dayBuilder, DAY_COLUMN);
            sqb.select(EBF.count("*"), NB_COMMITS_COLUMN);
            sqb.where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(TIMESTAMP_COLUMN, QueryUtils.OperatorType.GT))).group(dayBuilder);
            try (PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                st2.setString(1, projectKey);
                st2.setLong(2, since);
                logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
                st2.execute();
                ResultSet rs2 = st2.getResultSet();
                while (rs2.next()) {
                    long dayTS = sdf.parse(rs2.getString(DAY_COLUMN.toLowerCase())).getTime();
                    int bucket = DKUDateUtils.daysBetweenUTC((long)since, (long)dayTS);
                    ret.dayTS.data[bucket] = dayTS;
                    ret.value.data[bucket] = rs2.getLong(NB_COMMITS_COLUMN.toLowerCase());
                }
            }
            if (logger.isTraceEnabled()) {
                logger.traceV("Done computing user presence project data: " + JSON.json((Object)ret), new Object[0]);
            }
            IDSSUsageStatsInternalDB.TimeSeries timeSeries = ret;
            return timeSeries;
        }
    }

    @Override
    public IDSSUsageStatsInternalDB.TimeSeries getGlobalCommits_cached(String projectKey, long since) throws ExecutionException {
        return (IDSSUsageStatsInternalDB.TimeSeries)this.globalCommitsCache.get((Object)(projectKey + "@@@" + since));
    }

    @Override
    public IDSSUsageStatsInternalDB.CommitsSummary getCommitsSummary(String projectKey, long since) throws SQLException {
        IDSSUsageStatsInternalDB.CommitsSummary ret = new IDSSUsageStatsInternalDB.CommitsSummary();
        try (DSSDBConnection ac = this.acquireConnection();){
            IDSSUsageStatsInternalDB.CommitsSummary commitsSummary;
            block13: {
                PreparedStatement st2 = ac.prepareNonPersistedStatement("SELECT " + this.quote(PROJECT_KEY_COLUMN) + ", COUNT(DISTINCT " + this.quote(AUTHOR_COLUMN) + ") as nb_authors, COUNT(*) as nb_commits, SUM(" + this.quote(ADDED_LINES_COLUMN) + ") as added, SUM(" + this.quote(REMOVED_LINES_COLUMN) + ") as removed  FROM " + this.getQuotedFullResolvedTableName(commitStatsTable) + " WHERE " + this.quote(PROJECT_KEY_COLUMN) + "=? AND " + this.quote(TIMESTAMP_COLUMN) + " > ? AND " + this.quote(AUTHOR_COLUMN) + " <> " + this.quoteString("no:auth") + " GROUP BY " + this.quote(PROJECT_KEY_COLUMN));
                try {
                    st2.setString(1, projectKey);
                    st2.setLong(2, since);
                    logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
                    st2.execute();
                    ResultSet rs2 = st2.getResultSet();
                    if (rs2.next()) {
                        ret.nbAuthors = rs2.getInt("nb_authors");
                        ret.nbCommits = rs2.getInt("nb_commits");
                        ret.added = rs2.getInt("added");
                        ret.removed = rs2.getInt("removed");
                    }
                    commitsSummary = ret;
                    if (st2 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (st2 != null) {
                        try {
                            st2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                st2.close();
            }
            return commitsSummary;
        }
    }

    @Override
    public List<IDSSUsageStatsInternalDB.ProjectContributor> getPerContributorSummary(String projectKey, long since) throws SQLException {
        LazyHashMap lazyMap = new LazyHashMap(IDSSUsageStatsInternalDB.ProjectContributor.class);
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolveTable(commitStatsTable), commitStatsTable);
        sqb.select(EBF.col(AUTHOR_COLUMN));
        sqb.select(EBF.count("*"), "nb_commits");
        sqb.select(EBF.col(ADDED_LINES_COLUMN).sum(), "nb_added_lines");
        sqb.select(EBF.col(REMOVED_LINES_COLUMN).sum(), "nb_removed_lines");
        sqb.where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(TIMESTAMP_COLUMN, QueryUtils.OperatorType.GT)).and(EBF.col(AUTHOR_COLUMN).nullUnsafeEq(EBF.cst("no:auth")).not()));
        sqb.group(AUTHOR_COLUMN);
        try (DSSDBConnection ac = this.acquireConnection();){
            IDSSUsageStatsInternalDB.ProjectContributor pc;
            ResultSet rs2;
            try (PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                st2.setString(1, projectKey);
                st2.setLong(2, since);
                logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
                st2.execute();
                rs2 = st2.getResultSet();
                while (rs2.next()) {
                    pc = (IDSSUsageStatsInternalDB.ProjectContributor)lazyMap.getOrCreate((Object)rs2.getString("author"));
                    pc.user = rs2.getString(AUTHOR_COLUMN);
                    pc.commits = rs2.getInt("nb_commits");
                    pc.addedLines = rs2.getInt("nb_added_lines");
                    pc.removedLines = rs2.getInt("nb_removed_lines");
                }
            }
            sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(projectSavesByHourTable), projectSavesByHourTable);
            sqb.select(USER_COLUMN);
            sqb.select(this.dateBuilder(HOUR_COLUMN).format(Type.DATE, "yyyy-MM-dd-HH").distinct().count(), NB_DISTINCT_HOURS_COLUMN);
            sqb.where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(HOUR_COLUMN, QueryUtils.OperatorType.GT)).and(EBF.col(USER_COLUMN).nullUnsafeEq(EBF.cst("no:auth")).not())).group(USER_COLUMN);
            st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));
            try {
                st2.setString(1, projectKey);
                st2.setLong(2, since);
                logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
                st2.execute();
                rs2 = st2.getResultSet();
                while (rs2.next()) {
                    pc = (IDSSUsageStatsInternalDB.ProjectContributor)lazyMap.getOrCreate((Object)rs2.getString(USER_COLUMN));
                    pc.user = rs2.getString(USER_COLUMN);
                    pc.writeHours = rs2.getInt(NB_DISTINCT_HOURS_COLUMN);
                }
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
            sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(userPresenceHistoryTable), userPresenceHistoryTable);
            sqb.select(EBF.col(USER_COLUMN));
            sqb.select(EBF.col(PRESENCE_COLUMN).sum(), "time");
            sqb.where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(HOUR_COLUMN, QueryUtils.OperatorType.GT)).and(EBF.col(USER_COLUMN).nullUnsafeEq(EBF.cst("no:auth")).not()));
            sqb.group(USER_COLUMN);
            st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));
            try {
                st2.setString(1, projectKey);
                st2.setLong(2, since);
                logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
                st2.execute();
                rs2 = st2.getResultSet();
                while (rs2.next()) {
                    pc = (IDSSUsageStatsInternalDB.ProjectContributor)lazyMap.getOrCreate((Object)rs2.getString(USER_COLUMN));
                    pc.user = rs2.getString(USER_COLUMN);
                    pc.totalPresence = rs2.getLong("time");
                }
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
            ArrayList arrayList = Lists.newArrayList((Iterable)lazyMap.values());
            return arrayList;
        }
    }

    public List<ConnectionTasksService.PerProjectDataPoint> getConnectionTasksPerProject(String connectionId, long since) throws SQLException {
        LazyHashMap lazyMap = new LazyHashMap(ConnectionTasksService.PerProjectDataPoint.class);
        try (DSSDBConnection ac = this.acquireConnection();){
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(connectionTasksTable), connectionTasksTable);
            sqb.select(PROJECT_KEY_COLUMN);
            sqb.select(TASK_TYPE_COLUMN);
            sqb.select(EBF.count("*"), "nb_tasks");
            sqb.select(EBF.col(END_TIME_COLUMN).minus(EBF.col(START_TIME_COLUMN)).sum(), "elapsed");
            sqb.where(EBF.parameterizedColumnOperation(CONNECTION_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(START_TIME_COLUMN, QueryUtils.OperatorType.GT)));
            sqb.group(PROJECT_KEY_COLUMN).group(TASK_TYPE_COLUMN);
            try (PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                st2.setString(1, connectionId);
                st2.setLong(2, since);
                logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
                st2.execute();
                ResultSet rs2 = st2.getResultSet();
                while (rs2.next()) {
                    ConnectionTasksService.PerProjectDataPoint pp = (ConnectionTasksService.PerProjectDataPoint)lazyMap.getOrCreate((Object)rs2.getString(PROJECT_KEY_COLUMN));
                    pp.project = rs2.getString(PROJECT_KEY_COLUMN);
                    ConnectionTasksService.PerTypeDataPoint pt = new ConnectionTasksService.PerTypeDataPoint();
                    pt.type = ConnectionTasksService.ConnectionTaskType.valueOf(rs2.getString(TASK_TYPE_COLUMN));
                    pt.nbTasks = rs2.getInt("nb_tasks");
                    pt.totalElapsedTime = rs2.getLong("elapsed");
                    pp.types.add(pt);
                }
            }
        }
        return Lists.newArrayList((Iterable)lazyMap.values());
    }

    public List<ConnectionTasksService.PerUserDataPoint> getConnectionTasksPerUser(String connectionId, long since) throws SQLException {
        LazyHashMap lazyMap = new LazyHashMap(ConnectionTasksService.PerUserDataPoint.class);
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolveTable(connectionTasksTable), connectionTasksTable);
        sqb.select(USER_COLUMN);
        sqb.select(TASK_TYPE_COLUMN);
        sqb.select(EBF.count("*"), "nb_tasks");
        sqb.select(EBF.col(END_TIME_COLUMN).minus(EBF.col(START_TIME_COLUMN)).sum(), "elapsed");
        sqb.where(EBF.parameterizedColumnOperation(CONNECTION_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(START_TIME_COLUMN, QueryUtils.OperatorType.GT)));
        sqb.group(USER_COLUMN).group(TASK_TYPE_COLUMN);
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
            st2.setString(1, connectionId);
            st2.setLong(2, since);
            logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
            st2.execute();
            ResultSet rs2 = st2.getResultSet();
            while (rs2.next()) {
                ConnectionTasksService.PerUserDataPoint pp = (ConnectionTasksService.PerUserDataPoint)lazyMap.getOrCreate((Object)rs2.getString(USER_COLUMN));
                pp.user = rs2.getString(USER_COLUMN);
                ConnectionTasksService.PerTypeDataPoint pt = new ConnectionTasksService.PerTypeDataPoint();
                pt.type = ConnectionTasksService.ConnectionTaskType.valueOf(rs2.getString(TASK_TYPE_COLUMN));
                pt.nbTasks = rs2.getInt("nb_tasks");
                pt.totalElapsedTime = rs2.getLong("elapsed");
                pp.types.add(pt);
            }
        }
        return Lists.newArrayList((Iterable)lazyMap.values());
    }

    public List<ConnectionTasksService.PerTypeDataPoint> getConnectionTasksSummary(String connectionId, long since) throws SQLException {
        ArrayList<ConnectionTasksService.PerTypeDataPoint> ret = new ArrayList<ConnectionTasksService.PerTypeDataPoint>();
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolveTable(connectionTasksTable), connectionTasksTable);
        sqb.select(TASK_TYPE_COLUMN);
        sqb.select(EBF.count("*"), "nb_tasks");
        sqb.select(EBF.col(END_TIME_COLUMN).minus(EBF.col(START_TIME_COLUMN)).sum(), "elapsed");
        sqb.where(EBF.parameterizedColumnOperation(CONNECTION_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(START_TIME_COLUMN, QueryUtils.OperatorType.GT)));
        sqb.group(TASK_TYPE_COLUMN);
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
            st2.setString(1, connectionId);
            st2.setLong(2, since);
            logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
            st2.execute();
            ResultSet rs2 = st2.getResultSet();
            while (rs2.next()) {
                ConnectionTasksService.PerTypeDataPoint pt = new ConnectionTasksService.PerTypeDataPoint();
                pt.type = ConnectionTasksService.ConnectionTaskType.valueOf(rs2.getString(TASK_TYPE_COLUMN));
                pt.nbTasks = rs2.getInt("nb_tasks");
                pt.totalElapsedTime = rs2.getLong("elapsed");
                ret.add(pt);
            }
        }
        return ret;
    }

    private long genericPush(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, String tableName, String orderColumn, List<Filter> filters) throws Exception {
        try (DSSDBConnection ac = this.acquireConnection();){
            long l;
            block14: {
                ArrayList<String> filtersToApply = new ArrayList<String>();
                SelectQueryBuilder sqb = new SelectQueryBuilder();
                sqb.from(this.resolveTable(tableName), tableName);
                for (Filter filter : filters) {
                    String filterValue = filter.value;
                    if (!StringUtils.isNotBlank((String)filterValue)) continue;
                    filtersToApply.add(filterValue);
                    sqb.where(EBF.parameterizedColumnOperation(filter.column, QueryUtils.OperatorType.NULL_UNSAFE_EQ));
                }
                sqb.order(orderColumn, QueryAst.OrderType.DESC);
                PreparedStatement st2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));
                try {
                    for (int i = 0; i < filtersToApply.size(); ++i) {
                        String filter = (String)filtersToApply.get(i);
                        st2.setString(i + 1, filter);
                    }
                    l = this.pushPStatement(st2, out, cf, rf, limit);
                    if (st2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (st2 != null) {
                        try {
                            st2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                st2.close();
            }
            return l;
        }
    }

    public long pushLastConnectionTasks(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, String projectKey, String connection) throws Exception {
        return this.genericPush(out, cf, rf, limit, connectionTasksTable, START_TIME_COLUMN, (List<Filter>)ImmutableList.of((Object)new Filter(PROJECT_KEY_COLUMN, projectKey), (Object)new Filter(CONNECTION_COLUMN, connection)));
    }

    public long pushCommits(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, String projectKey) throws Exception {
        return this.genericPush(out, cf, rf, limit, commitStatsTable, TIMESTAMP_COLUMN, (List<Filter>)ImmutableList.of((Object)new Filter(PROJECT_KEY_COLUMN, projectKey)));
    }

    public List<IDSSUsageStatsInternalDB.ConnectionTask> getLastConnectionTasks(String connectionId, int maxNb) throws SQLException {
        ArrayList<IDSSUsageStatsInternalDB.ConnectionTask> ret = new ArrayList<IDSSUsageStatsInternalDB.ConnectionTask>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement st2 = ac.prepareNonPersistedStatement("SELECT *  FROM " + this.getQuotedFullResolvedTableName(connectionTasksTable) + " WHERE " + this.quote(CONNECTION_COLUMN) + "=?  ORDER BY " + this.quote(START_TIME_COLUMN) + " DESC LIMIT ?");){
            st2.setString(1, connectionId);
            st2.setInt(2, maxNb);
            logger.debug((Object)("Execute SQL: " + String.valueOf(st2)));
            st2.execute();
            ResultSet rs2 = st2.getResultSet();
            while (rs2.next()) {
                IDSSUsageStatsInternalDB.ConnectionTask ct = new IDSSUsageStatsInternalDB.ConnectionTask();
                ct.connectionId = connectionId;
                ct.taskType = ConnectionTasksService.ConnectionTaskType.valueOf(rs2.getString(TASK_TYPE_COLUMN));
                ct.projectKey = rs2.getString(PROJECT_KEY_COLUMN);
                ct.taskData = (JsonObject)JSON.parse((String)rs2.getString(TASK_DATA_COLUMN), JsonObject.class);
                ct.initiator = rs2.getString(USER_COLUMN);
                ct.startTime = rs2.getLong(START_TIME_COLUMN);
                ct.endTime = rs2.getLong(END_TIME_COLUMN);
                ret.add(ct);
            }
        }
        return ret;
    }

    public static SchemaColumn[] getCommitStatsColumnsForInternalStatsDataset() {
        return DSSUsageStatsInternalDB.toLowerCase(commitStatsColumns);
    }

    public static SchemaColumn[] getConnectionTasksColumnsForInternalStatsDataset() {
        return DSSUsageStatsInternalDB.toLowerCase(connectionTasksColumns);
    }

    private void switchAllTimestampColumns(Statement st2) throws SQLException {
        HashMap columnsToSwitch = Maps.newHashMap();
        columnsToSwitch.put("commits_stats", Lists.newArrayList((Object[])new String[]{"timestamp"}));
        columnsToSwitch.put("last_analyzed_commits", Lists.newArrayList((Object[])new String[]{"timestamp"}));
        columnsToSwitch.put("connection_tasks", Lists.newArrayList((Object[])new String[]{"start_time", "end_time"}));
        columnsToSwitch.put("user_presence_history", Lists.newArrayList((Object[])new String[]{"insert_time", "hour"}));
        columnsToSwitch.put("project_saves_by_hour", Lists.newArrayList((Object[])new String[]{"hour"}));
        this.switchTimestampsToLong(st2, columnsToSwitch);
    }

    private ExpressionBuilder dayBuilder(String timeColumnName) {
        return this.dateBuilder(timeColumnName).format(Type.DATE, "yyyy-MM-dd");
    }

    private ExpressionBuilder dateBuilder(String timeColumnName) {
        ExpressionBuilder originBuilder = EBF.cst("1970-01-01 00:00:00").stringToDate();
        ExpressionBuilder timeInMillisBuilder = EBF.col(timeColumnName);
        return originBuilder.dateAdd(timeInMillisBuilder, "MILLISECOND");
    }

    private long pushPStatement(PreparedStatement st2, ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit) throws Exception {
        logger.debug((Object)("Pushing dss_usage results from prepared statement:" + String.valueOf(st2) + " with limit " + JSON.json((Object)limit)));
        st2.execute();
        ResultSet rs2 = st2.getResultSet();
        return this.pushRS(rs2, out, cf, rf, limit);
    }

    private long pushRS(ResultSet rs2, ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit) throws Exception {
        long pushed = 0L;
        ResultSetMetaData rsmd = rs2.getMetaData();
        ArrayList<String> orderedColumnNames = new ArrayList<String>();
        HashMap<String, Column> columns = new HashMap<String, Column>();
        HashMap<String, Type> dkuTypes = new HashMap<String, Type>();
        HashMap<String, Integer> sqlTypes = new HashMap<String, Integer>();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            String colName = rsmd.getColumnName(i + 1);
            colName = colName.toLowerCase();
            orderedColumnNames.add(colName);
            columns.put(colName, cf.column(colName));
            int sqlType = rsmd.getColumnType(i + 1);
            SchemaColumn rawColumn = this.getDialect().fromSQLType(rsmd.getColumnName(i + 1), sqlType, rsmd.getColumnTypeName(i + 1), rsmd.getPrecision(i + 1), rsmd.getScale(i + 1), AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS);
            dkuTypes.put(colName, rawColumn.getType());
            sqlTypes.put(colName, sqlType);
        }
        while (rs2.next()) {
            out.emitRow(this.pushOneRow(cf, rf, rs2, orderedColumnNames, dkuTypes, sqlTypes));
            if (limit == null || limit.maxRecords < 0L || ++pushed < limit.maxRecords) continue;
            break;
        }
        return pushed;
    }

    @VisibleForTesting
    Row pushOneRow(ColumnFactory cf, RowFactory rf, ResultSet rs2, List<String> orderedColumnNames, Map<String, Type> dkuTypes, Map<String, Integer> sqlTypes) throws SQLException {
        Row row = rf.row();
        for (int i = 0; i < orderedColumnNames.size(); ++i) {
            String columnName = orderedColumnNames.get(i);
            SchemaColumn schemaColumn = new SchemaColumn(columnName, dkuTypes.get(columnName));
            row.put(cf.column(columnName), this.getDialect().getValueAsDSSString(rs2, sqlTypes.get(columnName), i + 1, schemaColumn, true, true, DateTimeZone.getDefault()));
        }
        return row;
    }

    private class Filter {
        String column;
        String value;

        public Filter(@Nullable String column, String value) {
            this.column = column;
            this.value = value;
        }
    }
}

