/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AIRecipe {
    public String type;

    private Map<SQLAggregateType, SQLAggregateAbility> getAggregationCapabilities() {
        return new VisualSQLRecipesBaseService().makeDSSBasedEngineStatus().aggregabilities;
    }

    public void validateAggregationFunctions(List<AIRecipeGenerationService.CreationMessage> creationMessages, List<Aggregation> aggregations, Dataset dataset, boolean windowRecipeAggregation, String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        Map<SQLAggregateType, SQLAggregateAbility> aggregationCapabilities = this.getAggregationCapabilities();
        Map<String, Type> datasetColumnNameToSchemaColumn = dataset.getSchema().columns.stream().collect(Collectors.toMap(SchemaColumn::getName, SchemaColumn::getType));
        aggregations.stream().filter(agg -> datasetColumnNameToSchemaColumn.containsKey(agg.column) && agg.function != null).forEach(agg -> {
            SQLAggregateType aggType = this.getSQLAggregateTypeFromComputationFunction(agg.function);
            if (aggType == null) {
                creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.UNSUPPORTED_AGG_FUNC", String.format("The following aggregation function %s is not currently supported on the column %s", agg.function, agg.column), "function", agg.function, "column", agg.column)));
                return;
            }
            SQLAggregateAbility ability = (SQLAggregateAbility)aggregationCapabilities.get((Object)aggType);
            Type columnType = (Type)datasetColumnNameToSchemaColumn.get(agg.column);
            if (!this.isDataTypeCompatibleWithAggregationFunction(columnType, ability)) {
                creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.INCOMPATIBLE_DATA_FOR_AGG_FUNC", String.format("The following column %s has the wrong data type and can't be aggregated using the function %s", agg.column, agg.function), "function", agg.function, "column", agg.column)));
            } else if (!ability.usableInWindow && windowRecipeAggregation) {
                creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.INCOMPATIBLE_AGG_FUNC_FOR_RECIPE", String.format("The following column aggregation function %s can't be computed with the recipe suggested", agg.function), "function", agg.function)));
            }
        });
    }

    private boolean isDataTypeCompatibleWithAggregationFunction(Type columnType, SQLAggregateAbility ability) {
        return columnType.isNumeric() && ability.numerics || columnType.equals((Object)Type.BOOLEAN) && ability.booleans || columnType.isTemporal() && ability.dates || columnType.equals((Object)Type.STRING) && ability.strings;
    }

    private SQLAggregateType getSQLAggregateTypeFromComputationFunction(String cf) {
        switch (cf) {
            case "AVG": {
                return SQLAggregateType.AVG;
            }
            case "LAG": {
                return SQLAggregateType.LAG;
            }
            case "MAX": {
                return SQLAggregateType.MAX;
            }
            case "MIN": {
                return SQLAggregateType.MIN;
            }
            case "SUM": {
                return SQLAggregateType.SUM;
            }
            case "LAST": {
                return SQLAggregateType.LAST;
            }
            case "LEAD": {
                return SQLAggregateType.LEAD;
            }
            case "COUNT": {
                return SQLAggregateType.COUNT;
            }
            case "COUNT_DISTINCT": {
                return SQLAggregateType.DISTINCT;
            }
            case "FIRST": {
                return SQLAggregateType.FIRST;
            }
            case "CONCAT": {
                return SQLAggregateType.CONCAT;
            }
            case "CONCAT_DISTINCT": {
                return SQLAggregateType.CONCAT_DISTINCT;
            }
            case "STD_DEV": {
                return SQLAggregateType.STDDEV;
            }
            case "RETRIEVE": {
                return SQLAggregateType.RETRIEVE;
            }
            case "LAG_DIFF": {
                return SQLAggregateType.LAG_DIFF;
            }
            case "LEAD_DIFF": {
                return SQLAggregateType.LEAD_DIFF;
            }
        }
        return null;
    }

    protected abstract List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> var1, String var2, String var3);

    public abstract AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext var1) throws Exception;

    public static class Aggregation {
        public String column;
        public String function;

        public Aggregation(String column, String function) {
            this.column = column;
            this.function = function;
        }
    }

    public static class FilterCondition {
        public String column;
        public String type;
        public String value;

        public FilterCondition(String column, String type, String value) {
            this.column = column;
            this.type = type;
            this.value = value;
        }
    }

    public static class OrderingColumn {
        public String column;
        public Boolean asc;

        public OrderingColumn(String column, boolean asc) {
            this.column = column;
            this.asc = asc;
        }
    }

    public static class AIRecipeParams {
        public List<String> input_datasets;
        public String input_dataset;
        public List<String> output_datasets;
        public String output_dataset;

        public static Dataset getDataset(List<Dataset> datasets, String inputDataset, String contextProjectKey) {
            for (Dataset d : datasets) {
                if (!d.getSmartName(contextProjectKey).equals(inputDataset)) continue;
                return d;
            }
            return null;
        }

        public static List<String> getValidDatasetNames(List<Dataset> datasets, List<String> inputDatasets, String contextProjectKey) {
            ArrayList<String> ret = new ArrayList<String>();
            Set datasetsName = datasets.stream().map(d -> d.getSmartName(contextProjectKey)).collect(Collectors.toSet());
            for (String name : inputDatasets) {
                if (!datasetsName.contains(name)) continue;
                ret.add(name);
            }
            return ret;
        }

        public void checkSingleInputDataset(List<Dataset> datasets, String type, String contextProjectKey) throws CodedRuntimeException {
            if (StringUtils.isBlank((CharSequence)this.input_dataset)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CREATION_FROM_TEXT_TO_RECIPE, type + " recipe requires one input dataset to work");
            }
            Dataset d = AIRecipeParams.getDataset(datasets, this.input_dataset, contextProjectKey);
            if (d == null) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CREATION_FROM_TEXT_TO_RECIPE, "Provided input dataset is not part of the selected datasets: " + this.input_dataset);
            }
        }

        public void checkMultipleInputDatasets(List<Dataset> datasets, String type, String contextProjectKey) throws CodedRuntimeException {
            if (this.input_datasets == null) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CREATION_FROM_TEXT_TO_RECIPE, type + " recipe  requires at least one input dataset to be defined");
            }
            List<String> validDatasets = AIRecipeParams.getValidDatasetNames(datasets, this.input_datasets, contextProjectKey);
            if (validDatasets.isEmpty()) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CREATION_FROM_TEXT_TO_RECIPE, type + " recipe requires at least one valid input dataset to work");
            }
        }

        public void checkSingleOutputDataset(String type) throws CodedRuntimeException {
            if (StringUtils.isBlank((CharSequence)this.output_dataset)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CREATION_FROM_TEXT_TO_RECIPE, type + " recipe requires one output dataset to be defined");
            }
        }

        public void checkMultipleOutputDatasets(String type) throws CodedRuntimeException {
            if (this.output_datasets == null || this.output_datasets.isEmpty()) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CREATION_FROM_TEXT_TO_RECIPE, type + " recipe requires at least one output dataset to be defined");
            }
        }
    }
}

