/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.sort.SortRecipePayloadParams;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AISort
extends AIRecipe {
    public static final String type = "sort";
    public Params params;

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        if (this.params.ordering_columns == null || this.params.ordering_columns.isEmpty()) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SORT.EMPTY_ORDER_COLUMN", "We were unable to determine which column(s) to use to order your dataset", new Object[0])));
        }
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        SortRecipePayloadParams sortRecipePayloadParams = new SortRecipePayloadParams();
        this.enrichParams(recipeGenerationContext.datasets, sortRecipePayloadParams, recipeGenerationContext.contextProjectKey);
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)sortRecipePayloadParams);
        return metaCreation;
    }

    public void enrichParams(List<Dataset> datasets, SortRecipePayloadParams recipeParams, String contextProjectKey) {
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(datasets, this.params.input_dataset, contextProjectKey);
        Set validColumnNames = dataset.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        recipeParams.rank = this.params.include_rank != null && this.params.include_rank != false;
        recipeParams.denseRank = this.params.include_dense_rank != null && this.params.include_dense_rank != false;
        recipeParams.rowNumber = this.params.include_row_number != null && this.params.include_row_number != false;
        recipeParams.orders = this.params.ordering_columns == null ? Collections.emptyList() : this.params.ordering_columns.stream().filter(oc -> validColumnNames.contains(oc.column)).map(oc -> {
            SortRecipePayloadParams.Order ret = new SortRecipePayloadParams.Order();
            ret.column = oc.column;
            ret.desc = oc.asc != null && oc.asc == false;
            return ret;
        }).collect(Collectors.toList());
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public List<AIRecipe.OrderingColumn> ordering_columns;
        public Boolean include_rank;
        public Boolean include_dense_rank;
        public Boolean include_row_number;
    }
}

