/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.scoring.pipelines.DatetimeCyclicalEncoder;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class NumFeaturePreprocessingParams
extends FeaturePreprocessingParams {
    public boolean generate_derivative = false;
    public NumericalHandlingMethod numerical_handling;
    public MissingHandlingMethod missing_handling;
    public NumericalImputationMethod missing_impute_with;
    public double impute_constant_value;
    public boolean keep_regular;
    public RescalingMethod rescaling;
    public MonotonicConstraintMethod monotonic = MonotonicConstraintMethod.NONE;
    public int quantile_bin_nb_bins = 4;
    public BinarizeThresholdMode binarize_threshold_mode = BinarizeThresholdMode.MEDIAN;
    public double binarize_constant_threshold;
    public Set<DatetimeCyclicalEncoder.Period> datetime_cyclical_periods = new HashSet<DatetimeCyclicalEncoder.Period>();

    public static NumFeaturePreprocessingParams buildStandardHandling() {
        NumFeaturePreprocessingParams ret = new NumFeaturePreprocessingParams();
        ret.role = FeaturePreprocessingParams.Role.INPUT;
        ret.numerical_handling = NumericalHandlingMethod.REGULAR;
        ret.missing_handling = MissingHandlingMethod.IMPUTE;
        ret.missing_impute_with = NumericalImputationMethod.MEAN;
        ret.rescaling = RescalingMethod.AVGSTD;
        return ret;
    }

    public static NumFeaturePreprocessingParams buildDateHandling() {
        NumFeaturePreprocessingParams ret = new NumFeaturePreprocessingParams();
        ret.role = FeaturePreprocessingParams.Role.INPUT;
        ret.numerical_handling = NumericalHandlingMethod.DATETIME_CYCLICAL;
        ret.missing_handling = MissingHandlingMethod.DROP_ROW;
        ret.rescaling = RescalingMethod.AVGSTD;
        return ret;
    }

    public static NumFeaturePreprocessingParams buildBooleanHandling() {
        NumFeaturePreprocessingParams ret = new NumFeaturePreprocessingParams();
        ret.role = FeaturePreprocessingParams.Role.INPUT;
        ret.numerical_handling = NumericalHandlingMethod.REGULAR;
        ret.missing_handling = MissingHandlingMethod.IMPUTE;
        ret.missing_impute_with = NumericalImputationMethod.CONSTANT;
        ret.impute_constant_value = 0.0;
        ret.rescaling = RescalingMethod.NONE;
        return ret;
    }

    public static NumFeaturePreprocessingParams buildReject(FeaturePreprocessingParams.FeatureHandlingReason reason) {
        NumFeaturePreprocessingParams ret = new NumFeaturePreprocessingParams();
        ret.role = FeaturePreprocessingParams.Role.REJECT;
        ret.autoReason = reason;
        return ret;
    }

    public NumFeaturePreprocessingParams() {
        this.type = FeaturePreprocessingParams.FeatureType.NUMERIC;
    }

    @Override
    public void check(String featureName, MLTask task) throws Exception {
        if (!this.role.isInput() && this.role != FeaturePreprocessingParams.Role.WEIGHT) {
            return;
        }
        if (this.missing_handling == null) {
            throw ErrorContext.iaef((String)"Feature '%s' has no missing handling method", (Object)featureName, (Object[])new Object[0]);
        }
        if (this.missing_handling == MissingHandlingMethod.IMPUTE && this.missing_impute_with == null) {
            throw ErrorContext.iaef((String)"Feature '%s' has no missing_impute_with parameter", (Object)featureName, (Object[])new Object[0]);
        }
        if (this.numerical_handling == null) {
            throw ErrorContext.iaef((String)"Feature '%s' has no numerical handling method", (Object)featureName, (Object[])new Object[0]);
        }
        if (this.rescaling == null) {
            throw ErrorContext.iaef((String)"Feature '%s' has no rescaling method", (Object)featureName, (Object[])new Object[0]);
        }
    }

    @Override
    public boolean usesCustomHandling() {
        if (!this.role.isInput()) {
            return false;
        }
        return !StringUtils.isBlank((String)this.customHandlingCode) && this.numerical_handling == NumericalHandlingMethod.CUSTOM;
    }

    public static enum NumericalHandlingMethod {
        REGULAR,
        FLAG_PRESENCE,
        BINARIZE,
        QUANTILE_BIN,
        DATETIME_CYCLICAL,
        CUSTOM;

    }

    public static enum MissingHandlingMethod {
        IMPUTE,
        DROP_ROW,
        KEEP_NAN_OR_IMPUTE,
        KEEP_NAN_OR_DROP;

    }

    public static enum NumericalImputationMethod {
        MEAN,
        MEDIAN,
        CONSTANT;

    }

    public static enum RescalingMethod {
        NONE,
        AVGSTD,
        MINMAX;

    }

    public static enum MonotonicConstraintMethod {
        NONE,
        INCREASE,
        DECREASE;

    }

    public static enum BinarizeThresholdMode {
        MEAN,
        MEDIAN,
        CONSTANT;

    }
}

