/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.common.stereotype.MightBeUnsafe;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.OverrideTable;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class Dataset
implements Partitionable,
MightBeUnsafe {
    private String fullName;
    private SerializedDataset model;
    private PartitioningScheme partitioning = new PartitioningScheme();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.model.dataset");

    public static Dataset fromSerialized(SerializedDataset sd) {
        return Dataset.fromSerialized(sd.getFullName(), sd, false);
    }

    public static Dataset fromSerializedUnsafe(SerializedDataset sd) {
        return Dataset.fromSerialized(sd.getFullName(), sd, true);
    }

    public static Dataset fromSerialized(String fullName, SerializedDataset sd) {
        return Dataset.fromSerialized(fullName, sd, false);
    }

    public static Dataset fromSerializedUnsafe(String fullName, SerializedDataset sd) {
        return Dataset.fromSerialized(fullName, sd, true);
    }

    private static Dataset fromSerialized(String fullName, SerializedDataset s, boolean unsafe) {
        Preconditions.checkArgument((s.type != null ? 1 : 0) != 0, (Object)("Dataset with no type:" + fullName));
        Dataset out = new Dataset();
        out.setFullName(fullName);
        out.model = unsafe ? s : (SerializedDataset)JSON.deepCopy((Object)s);
        if (s.partitioning != null) {
            out.setPartitioningScheme(s.partitioning);
        } else {
            out.setPartitioningScheme(new PartitioningScheme());
        }
        return out;
    }

    public SerializedDataset serialize() {
        SerializedDataset out = (SerializedDataset)JSON.deepCopy((Object)this.model);
        out.partitioning = this.partitioning;
        out.projectKey = DatasetLocUtils.resolveSmart(null, this.fullName).getProjectKey();
        out.name = DatasetLocUtils.resolveSmart(null, this.fullName).getName();
        return out;
    }

    public SerializedDataset getModel() {
        return this.model;
    }

    public Dataset() {
        this.model = new SerializedDataset();
    }

    public String getDescription() {
        return this.model.description;
    }

    public DatasetLocUtils.DatasetLoc getLoc() {
        return DatasetLocUtils.resolveFull(this.fullName);
    }

    @Override
    public String getName() {
        return this.getLoc().getName();
    }

    @Override
    public String getProjectKey() {
        return this.getLoc().getProjectKey();
    }

    public String getSmartName(String contextProjectKey) {
        return this.getLoc().getSmartName(contextProjectKey);
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        Preconditions.checkArgument((boolean)fullName.contains("."), (Object)"Dataset fullname should contain '.'");
        String[] chunks = fullName.split("\\.");
        if (chunks.length != 2 || chunks[0].length() == 0 || chunks[1].length() == 0) {
            throw new IllegalArgumentException("Invalid dataset name '" + fullName + "'");
        }
        this.fullName = fullName;
    }

    public String getType() {
        return this.model.type;
    }

    public void setType(String type) {
        this.model.type = type;
    }

    public DatasetHandler.DatasetParams getParams() {
        return this.model.getParams();
    }

    public <T extends DatasetHandler.DatasetParams> T getParamsAs(Class<T> clazz) {
        return this.model.getParamsAs(clazz);
    }

    public void setParams(DatasetHandler.DatasetParams params) {
        this.model.setParams(params);
    }

    public String getFormatType() {
        return this.model.formatType;
    }

    public void setFormatType(String formatType) {
        this.model.formatType = formatType;
    }

    public FormatParams getFormatParams() {
        return this.model.getFormatParams();
    }

    public <T extends FormatParams> T getFormatParamsAs(Class<T> clazz) {
        return (T)((FormatParams)clazz.cast(this.model.getFormatParams()));
    }

    public void setFormatParams(FormatParams formatParams) {
        this.model.setFormatParams(formatParams);
    }

    public Schema getSchema() {
        return this.model.getSchema();
    }

    public SerializedDataset.TypeSystemVersion getTypeSystemVersion() {
        return this.model.typeSystemVersion;
    }

    public void setSchema(Schema schema) {
        this.model.setSchema(schema);
    }

    public void setTypeSystemVersion(SerializedDataset.TypeSystemVersion typeSystemVersion) {
        this.model.typeSystemVersion = typeSystemVersion;
    }

    public Dataset withSchema(Schema schema) {
        this.model.setSchema(schema);
        return this;
    }

    @Override
    public PartitioningScheme getPartitioningSchema() {
        return this.partitioning;
    }

    public void setPartitioningScheme(PartitioningScheme scheme) {
        this.partitioning = scheme;
    }

    public List<SerializedDataset.SerializedCheck> getChecks() {
        return this.model.checks;
    }

    public void setChecks(List<SerializedDataset.SerializedCheck> checks) {
        this.model.checks = checks;
    }

    public boolean isManaged() {
        return this.model.managed;
    }

    public void setManaged(boolean managed) {
        this.model.managed = managed;
    }

    public Dataset withFullName(String name) {
        this.setFullName(name);
        return this;
    }

    public Dataset withType(String type) {
        this.setType(type);
        return this;
    }

    public SerializedDataset.RemoteFiles getRemoteFiles() {
        return this.model.remoteFiles;
    }

    public void setRemoteFiles(SerializedDataset.RemoteFiles remoteFiles) {
        this.model.remoteFiles = remoteFiles;
    }

    @Override
    public SerializedDataset.FlowOptions getFlowOptions() {
        return this.model.flowOptions;
    }

    public OverrideTable getOverrideTable() {
        return this.model.overrideTable;
    }

    public Params getDkuPropertiesAsParams() {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.getModel().dkuProperties);
    }

    @Override
    public PartitionableHandler buildHandler(AuthCtx authCtx) {
        return DatasetHandlerFactory.build(authCtx, this);
    }

    public String getSerializedJSONForSemanticComparison() {
        return this.getSerializedForSemanticComparison().toJSONAndFixupForDataQuality(false);
    }

    private SerializedDataset getSerializedForSemanticComparison() {
        SerializedDataset sd = this.serialize();
        sd.description = null;
        sd.tags = null;
        sd.versionTag = null;
        if (sd.getSchema() != null && sd.getSchema().columns != null) {
            for (SchemaColumn col : sd.getSchema().columns) {
                col.comment = null;
                col.customFields = null;
            }
        }
        sd.manualDataLineage = null;
        return sd;
    }

    public InfoMessage.InfoMessages fixupSchemaPerDatasetConstraint(AuthCtx authCtx, Schema schema) throws IOException, DKUSecurityException {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (DatasetInspector.isSQLOrHive(this)) {
            String connectionName = ((AbstractSQLDatasetHandler.AbstractSQLConfig)this.getParams()).connection;
            AbstractSQLConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, connectionName, AbstractSQLConnection.class);
            this.fixupSchema(schema, connection, ret);
        }
        return ret;
    }

    public InfoMessage.InfoMessages fixupSchemaPerDatasetConstraint(Schema schema, DSSConnection connection) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (DatasetInspector.isSQLOrHive(this) && connection instanceof AbstractSQLConnection) {
            this.fixupSchema(schema, (AbstractSQLConnection)connection, ret);
        }
        return ret;
    }

    private void fixupSchema(Schema schema, AbstractSQLConnection connection, InfoMessage.InfoMessages ret) {
        SchemaUtils.fixupExistingStringColumnsMaxLengths(schema, connection.getDialect());
        connection.getDialect().setDefaultLengthForSchemaColumn(schema, Collections.emptyList(), ret);
        SchemaUtils.fixupImplicitColumns(connection.getType(), schema);
    }

    public InfoMessage.InfoMessages fixupManagedDatasetPartitioning(@Nullable SerializedDataset preExisting) {
        if (this.model == null || !this.model.managed || this.getParams() == null) {
            return new InfoMessage.InfoMessages();
        }
        try {
            InfoMessage.InfoMessages autoConfigureMessage = ManagedDatasetsHelper.autoConfigureNativePartitioningIfRelevant(preExisting, this.getParams(), this.getPartitioningSchema(), this.getSchema());
            if (autoConfigureMessage != null && !autoConfigureMessage.isEmpty()) {
                return autoConfigureMessage;
            }
            return ManagedDatasetsHelper.checkPartitioningConfiguration(preExisting, this.getParams(), this.getPartitioningSchema(), this.getSchema());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to fixup partitioning", (Throwable)e);
            return new InfoMessage.InfoMessages();
        }
    }
}

