/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.selectionexecutors.CandidateSelectionAlgorithm;
import com.dataiku.dip.dataflow.exec.joinlike.JoinDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FuzzyJoinRecipePayloadParams
extends JoinLikeRecipePayloadParams<JoinInputDescBase, MatchingCondition, JoinDesc>
implements ParamsWithContainerizable {
    public boolean withMetaColumn = false;
    public boolean debugMode = false;

    @Override
    public void validateJoinCondition(MatchingCondition cond) {
        if (!this.isValidColumnDesc(cond.column1) || !this.isValidColumnDesc(cond.column2)) {
            throw ErrorContext.iae((String)"Invalid column in matching conditions.");
        }
    }

    public JoinDesc getJoinDescriptor() {
        return (JoinDesc)this.joins.get(0);
    }

    public Map<Integer, String> getMapIndexToDataset() {
        HashMap<Integer, String> mapTableToDataset = new HashMap<Integer, String>();
        for (JoinInputDescBase virtualInput : this.virtualInputs) {
            mapTableToDataset.put(virtualInput.index, virtualInput.alias);
        }
        return mapTableToDataset;
    }

    @Override
    public void initializeJoinDesc() {
        JoinDesc join = new JoinDesc();
        join.table1 = 0;
        join.table2 = 1;
        this.joins = Lists.newArrayList((Object[])new JoinDesc[]{join});
    }

    @Override
    protected JoinDesc newJoinDesc() {
        return new JoinDesc();
    }

    @Override
    public JoinInputDescBase newInputDesc() {
        return new JoinInputDescBase();
    }

    @Override
    public ContainerExecSelection getContainerSelection() {
        return this.engineParams.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        this.engineParams.containerSelection = selection;
    }

    public static class MatchingCondition
    extends MatchingConditionBase {
        public NormaliseDesc normaliseDesc;
        public FuzzyMatchDesc fuzzyMatchDesc;

        public MatchingCondition() {
            this.normaliseDesc = new NormaliseDesc();
            this.fuzzyMatchDesc = new FuzzyMatchDesc();
        }

        public MatchingCondition(FuzzyMatchDesc fuzzyMatchDesc) {
            this.fuzzyMatchDesc = fuzzyMatchDesc;
        }

        @Override
        public boolean isEqualityCondition() {
            return this.fuzzyMatchDesc.distanceType == DistanceType.EXACT;
        }
    }

    public static class JoinDesc
    extends JoinDescBase<MatchingCondition> {
    }

    public static enum DistanceType {
        EXACT_HASH("Strict equality", CandidateSelectionAlgorithm.EXACT_HASH),
        EXACT("Strict equality", CandidateSelectionAlgorithm.EXACT_HASH),
        EUCLIDEAN("Euclidean", CandidateSelectionAlgorithm.KD),
        GEO("Geospatial", CandidateSelectionAlgorithm.KD),
        HAMMING("Hamming", CandidateSelectionAlgorithm.KD),
        LEVENSHTEIN("Damerau-Levenshtein", CandidateSelectionAlgorithm.KD),
        COSINE("Cosine", CandidateSelectionAlgorithm.DUMMY),
        JACCARD("Jaccard", CandidateSelectionAlgorithm.DUMMY);

        private final List<CandidateSelectionAlgorithm> candidateSelectionAlgorithms;
        private final String displayName;

        public List<CandidateSelectionAlgorithm> getCandidateSelectionAlgorithms() {
            return this.candidateSelectionAlgorithms;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        private DistanceType(String displayName, CandidateSelectionAlgorithm ... candidateSelectorType) {
            this.displayName = displayName;
            this.candidateSelectionAlgorithms = Collections.unmodifiableList(Arrays.asList(candidateSelectorType));
        }
    }

    public static class FuzzyMatchDesc {
        public DistanceType distanceType = DistanceType.EXACT;
        public double threshold;
        public Integer relativeTo;

        public FuzzyMatchDesc() {
        }

        public FuzzyMatchDesc(DistanceType distanceType, double threshold) {
            this.distanceType = distanceType;
            this.threshold = threshold;
        }

        public boolean isRelative() {
            return this.relativeTo != null;
        }
    }

    public static class NormaliseDesc {
        public boolean normaliseText = false;
        public boolean caseInsensitive = false;
        public boolean unicodeCasting = false;
        public boolean clearSalutations = false;
        public boolean clearStopWords = false;
        public boolean transformToStem = false;
        public boolean sortAlphabetically = false;
        public String language = "english";
    }
}

