/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.Record;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Matcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Verifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MetaComputer {
    private final FuzzyJoinRecipePayloadParams.JoinDesc joinDesc;
    private final Map<Integer, String> mapIndexToDataset;
    public final boolean hasMeta;

    public MetaComputer(FuzzyJoinRecipePayloadParams payload) {
        this.hasMeta = payload.debugMode || payload.withMetaColumn;
        this.joinDesc = payload.getJoinDescriptor();
        this.mapIndexToDataset = payload.getMapIndexToDataset();
    }

    public List<Meta> getMeta(Verifier.VerifierResult result) {
        Record query = result.query;
        Record candidate = result.candidate;
        List<Matcher.MatchResult> matchResults = result.matchResults;
        ArrayList<Meta> metas = new ArrayList<Meta>();
        for (int idxCondition = 0; idxCondition < this.joinDesc.on.size(); ++idxCondition) {
            FuzzyJoinRecipePayloadParams.MatchingCondition condition = (FuzzyJoinRecipePayloadParams.MatchingCondition)this.joinDesc.on.get(idxCondition);
            if (condition.fuzzyMatchDesc.distanceType == FuzzyJoinRecipePayloadParams.DistanceType.EXACT_HASH) continue;
            Meta meta = new Meta();
            meta.pairs = this.buildPairs(query, candidate, idxCondition, condition);
            Matcher.MatchResult matchResult = idxCondition < matchResults.size() ? matchResults.get(idxCondition) : new Matcher.MatchResult();
            meta.isMatch = matchResult.isMatch;
            meta.distance = matchResult.distance;
            meta.threshold = condition.fuzzyMatchDesc.threshold;
            meta.distanceType = condition.fuzzyMatchDesc.distanceType.name();
            meta.relativeTo = condition.fuzzyMatchDesc.relativeTo;
            metas.add(meta);
        }
        return metas;
    }

    private List<JoinKeyValuePair> buildPairs(Record recordA, Record recordB, int idxCondition, FuzzyJoinRecipePayloadParams.MatchingCondition condition) {
        ArrayList<JoinKeyValuePair> pairs = new ArrayList<JoinKeyValuePair>();
        for (int table = 0; table < 2; ++table) {
            JoinKeyValuePair pair = new JoinKeyValuePair();
            pair.dataset = this.mapIndexToDataset.get(table);
            pair.joinKey = condition.column1.table == table ? condition.column1.name : condition.column2.name;
            pair.joinValue = recordA.getTable() == table ? recordA.getJoinValue(idxCondition) : recordB.getJoinValue(idxCondition);
            pairs.add(pair);
        }
        return pairs;
    }

    public static class Meta {
        List<JoinKeyValuePair> pairs;
        boolean isMatch;
        double distance;
        double threshold;
        String distanceType;
        Integer relativeTo;
    }

    private static class JoinKeyValuePair {
        String dataset;
        String joinKey;
        String joinValue;

        private JoinKeyValuePair() {
        }
    }
}

