/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.AbstractStagedThreadedBuiltinRunner;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.grouping.Grouper2;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.AbstractPivotRecipeExecutor;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifier;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifiers;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotedModality;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.UniversalSingleThreadPuller;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PivotRecipeBuiltinExecutor
extends AbstractPivotRecipeExecutor {
    private static final Boolean booleanMeaning = new Boolean();
    private static final LongMeaning longMeaning = new LongMeaning();
    private static final DoubleMeaning doubleMeaning = new DoubleMeaning();
    private static final String COUNT_COLUMN_NAME = "__dku_count";
    private static Logger logger = Logger.getLogger((String)"dip.recipe.pivot.builtin.executor");

    public PivotRecipeBuiltinExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, JobActivity activity, PivotRecipePayloadParams params) {
        super(engine, activity, params);
    }

    @Override
    protected void execute(List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities) throws Exception {
        final PivoterBuiltinRunner subRunner = new PivoterBuiltinRunner(this.activity, pivotElementsModalities);
        try (AutoCloseable hook = this.startAbortableTask(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Aborting pivoting query");
                subRunner.notifyBeforeAborting();
            }
        });){
            subRunner.init();
            subRunner.run();
        }
    }

    @Override
    protected List<PivotedModality> doCollectModalities(PivotElement pivotElement) throws Exception {
        final PivotModalityCollectorBuiltinRunner subRunner = new PivotModalityCollectorBuiltinRunner(this.activity, pivotElement);
        try (AutoCloseable hook = this.startAbortableTask(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Aborting modality collection query");
                subRunner.notifyBeforeAborting();
            }
        });){
            subRunner.init();
            subRunner.run();
        }
        return subRunner.getCollectedModalities();
    }

    public class PivoterBuiltinRunner
    extends AbstractStagedThreadedBuiltinRunner {
        private final List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities;

        public PivoterBuiltinRunner(JobActivity activity, List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities) {
            super(activity);
            this.pivotElementsModalities = pivotElementsModalities;
        }

        @Override
        public List<AbstractInitializedRunner.Output> prepareStages(File tempDirectory) throws Exception {
            assert (this.inputs.containsKey("main"));
            assert (!((List)this.inputs.get("main")).isEmpty());
            assert (this.outputs.containsKey("main"));
            assert (!((List)this.outputs.get("main")).isEmpty());
            AbstractInitializedRunner.Input input = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
            AbstractInitializedRunner.Output output = (AbstractInitializedRunner.Output)((List)this.outputs.get("main")).get(0);
            GrelExpression preFilterExpression = FilterDescUtils.willFilter(PivotRecipeBuiltinExecutor.this.params.preFilter) ? FilterDescUtils.getGrelFilterExpression(PivotRecipeBuiltinExecutor.this.params.preFilter) : null;
            if (PivotRecipeBuiltinExecutor.this.params.preFilter != null && PivotRecipeBuiltinExecutor.this.params.preFilter.distinct) {
                this.stages.add(new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread(input.schema, new File(tempDirectory, "prefilter")));
            }
            if (preFilterExpression != null) {
                this.stages.add(new AbstractStagedThreadedBuiltinRunner.FilteringThread(preFilterExpression));
            }
            Schema schemaAfterComputedCols = new Schema(input.schema);
            if (PivotRecipeBuiltinExecutor.this.params.computedColumns != null && !PivotRecipeBuiltinExecutor.this.params.computedColumns.isEmpty()) {
                this.stages.add(new AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread(PivotRecipeBuiltinExecutor.this.params.computedColumns));
                for (ComputedColumn computedColumn : PivotRecipeBuiltinExecutor.this.params.computedColumns) {
                    ComputedColumnUtils.addToSchema(schemaAfterComputedCols, computedColumn);
                }
            }
            ArrayList pivotedColumns = Lists.newArrayList();
            for (PivotElementsModalitiesSnapshot.PivotElementsModalities pivotElementsModalities : this.pivotElementsModalities) {
                List<PivotedModality> modalities = pivotElementsModalities.pivotedModalities;
                PivotElement pivotElement = pivotElementsModalities.pivotElement;
                for (PivotedModality modality : modalities) {
                    String condition = modality.asExpression(pivotElement.keyColumns, schemaAfterComputedCols);
                    for (PivotedModality.PivotedColumn pivotedColumn : modality.valueColumns) {
                        ComputedColumn computedColumn = new ComputedColumn();
                        computedColumn.name = pivotedColumn.pivoted;
                        computedColumn.type = schemaAfterComputedCols.getColumn(pivotedColumn.source).getType().getName();
                        computedColumn.mode = ComputedColumn.Mode.GREL;
                        computedColumn.expr = "if(" + condition + ",strval(" + FilterDescUtils.getGrelQuotedString(pivotedColumn.source) + "),null)";
                        pivotedColumns.add(computedColumn);
                    }
                    if (!StringUtils.isNotBlank((String)modality.globalCountColumn)) continue;
                    ComputedColumn computedColumn = new ComputedColumn();
                    computedColumn.name = modality.globalCountColumn;
                    computedColumn.type = Type.BIGINT.getName();
                    computedColumn.mode = ComputedColumn.Mode.GREL;
                    computedColumn.expr = "if(" + condition + ",1,null)";
                    pivotedColumns.add(computedColumn);
                }
            }
            logger.info((Object)("Compute " + pivotedColumns.size() + " pivoted columns "));
            Schema schema = new Schema(schemaAfterComputedCols);
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread(pivotedColumns));
            for (ComputedColumn cc : pivotedColumns) {
                ComputedColumnUtils.addToSchema(schema, cc);
            }
            GroupingRecipePayloadParams groupingRecipePayloadParams = PivotRecipeBuiltinExecutor.this.params.generateGroupingRecipeParams(PivotRecipeBuiltinExecutor.this.identifiers, this.pivotElementsModalities, schema);
            Grouper2 grouper = Grouper2.withSchemalessSuffixing(groupingRecipePayloadParams.getRawGroupingKeys(), groupingRecipePayloadParams.values, null, new File(tempDirectory, "grouper"), this.mergeSortParams, PivotRecipeBuiltinExecutor.this.params.getModalityMaxLength(PivotRecipeBuiltinExecutor.this.getOutputDialect()));
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.GrouperThread(grouper, schema));
            return Lists.newArrayList((Object[])new AbstractInitializedRunner.Output[]{output});
        }
    }

    public class PivotModalityCollectorBuiltinRunner
    extends AbstractStagedThreadedBuiltinRunner {
        private final PivotElement pivotElement;
        private CollectorRowProcessor collector;
        private Schema schemaAfterComputedCols;

        public PivotModalityCollectorBuiltinRunner(JobActivity activity, PivotElement pivotElement) {
            super(activity);
            this.pivotElement = pivotElement;
        }

        public List<PivotedModality> getCollectedModalities() {
            ArrayList modalities = Lists.newArrayList();
            ModalitySlugifier modalitySlugifier = ModalitySlugifiers.getSlugifier(PivotRecipeBuiltinExecutor.this.params.modalitySlugification);
            for (List<String> values : this.collector.getModalities()) {
                modalities.add(PivotedModality.fromModalities(values, this.pivotElement, modalitySlugifier));
            }
            return modalities;
        }

        @Override
        protected void initInputs() throws IOException {
            String role = "main";
            SerializedRecipe.RecipeInput recipeInput = this.recipe.getModel().getInputsForRole(role).get(0);
            AbstractInitializedRunner.Input input = new AbstractInitializedRunner.Input();
            Dataset inputDS = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(recipeInput.getLoc(this.recipe.getProjectKey())));
            input.fullId = inputDS.getFullName();
            input.schema = inputDS.getSchema();
            StreamableDatasetSelection ds = StreamableDatasetSelection.full();
            input.cf = new StreamColumnFactory(input.schema);
            input.is = UniversalSingleThreadPuller.pull(this.authCtxService.getAuthCtx(), inputDS, ds, (ColumnFactory)input.cf, this.activity.warnContext);
            if (!this.inputs.containsKey(role)) {
                this.inputs.put(role, new ArrayList());
            }
            ((List)this.inputs.get(role)).add(input);
            this.schemaAfterComputedCols = new Schema(input.schema);
            if (PivotRecipeBuiltinExecutor.this.params.computedColumns != null && !PivotRecipeBuiltinExecutor.this.params.computedColumns.isEmpty()) {
                for (ComputedColumn cc : PivotRecipeBuiltinExecutor.this.params.computedColumns) {
                    ComputedColumnUtils.addToSchema(this.schemaAfterComputedCols, cc);
                }
            }
        }

        @Override
        protected void initOutputs() throws Exception {
            String role = "main";
            AbstractInitializedRunner.Output output = new AbstractInitializedRunner.Output();
            output.cf = new StreamColumnFactory();
            output.rf = new StreamRowFactory();
            if (this.pivotElement.valueLimit == PivotElement.PivotValueLimit.NO_LIMIT) {
                this.collector = new CollectAllRowProcessor((ColumnFactory)output.cf, this.pivotElement.keyColumns, this.schemaAfterComputedCols);
            } else if (this.pivotElement.valueLimit == PivotElement.PivotValueLimit.AT_LEAST_N_OCC) {
                this.collector = new AtLeastNCollectorRowProcessor((ColumnFactory)output.cf, this.pivotElement.keyColumns, this.schemaAfterComputedCols, this.pivotElement.minOccLimit);
            } else if (this.pivotElement.valueLimit == PivotElement.PivotValueLimit.TOP_N) {
                this.collector = new TopNCollectorRowProcessor((ColumnFactory)output.cf, this.pivotElement.keyColumns, this.schemaAfterComputedCols, this.pivotElement.topnLimit);
            } else {
                throw new Error("Unexpected value limit on modality collection");
            }
            output.out = this.collector;
            this.outputs.put(role, Lists.newArrayList((Object[])new AbstractInitializedRunner.Output[]{output}));
        }

        @Override
        public List<AbstractInitializedRunner.Output> prepareStages(File tempDirectory) throws Exception {
            assert (this.inputs.containsKey("main"));
            assert (!((List)this.inputs.get("main")).isEmpty());
            assert (this.outputs.containsKey("main"));
            assert (!((List)this.outputs.get("main")).isEmpty());
            AbstractInitializedRunner.Input input = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
            AbstractInitializedRunner.Output output = (AbstractInitializedRunner.Output)((List)this.outputs.get("main")).get(0);
            GrelExpression preFilterExpression = FilterDescUtils.willFilter(PivotRecipeBuiltinExecutor.this.params.preFilter) ? FilterDescUtils.getGrelFilterExpression(PivotRecipeBuiltinExecutor.this.params.preFilter) : null;
            if (PivotRecipeBuiltinExecutor.this.params.preFilter != null && PivotRecipeBuiltinExecutor.this.params.preFilter.distinct) {
                this.stages.add(new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread(input.schema, new File(tempDirectory, "prefilter")));
            }
            if (preFilterExpression != null) {
                this.stages.add(new AbstractStagedThreadedBuiltinRunner.FilteringThread(preFilterExpression));
            }
            if (PivotRecipeBuiltinExecutor.this.params.computedColumns != null && !PivotRecipeBuiltinExecutor.this.params.computedColumns.isEmpty()) {
                this.stages.add(new AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread(PivotRecipeBuiltinExecutor.this.params.computedColumns));
            }
            ArrayList keysDesc = Lists.newArrayList();
            ArrayList valuesDesc = Lists.newArrayList();
            for (String key : this.pivotElement.keyColumns) {
                keysDesc.add(new GroupingRecipePayloadParams.GroupingKey(key));
            }
            Grouper2 grouper = new Grouper2(keysDesc, valuesDesc, PivotRecipeBuiltinExecutor.COUNT_COLUMN_NAME, new File(tempDirectory, "collector"), this.mergeSortParams, null);
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.GrouperThread(grouper, this.schemaAfterComputedCols));
            return Lists.newArrayList((Object[])new AbstractInitializedRunner.Output[]{output});
        }
    }

    private static class TopNCollectorRowProcessor
    extends CollectorRowProcessor {
        private final int topnLimit;
        private final PriorityQueue<CollectedRow> collected;

        public TopNCollectorRowProcessor(ColumnFactory cf, List<String> keys, Schema schema, int topnLimit) {
            super(cf, keys, schema);
            this.topnLimit = topnLimit;
            this.collected = new PriorityQueue<CollectedRow>(Math.max(topnLimit, 1), new Comparator<CollectedRow>(){

                @Override
                public int compare(CollectedRow a, CollectedRow b) {
                    return a.count < b.count ? -1 : (a.count > b.count ? 1 : 0);
                }
            });
        }

        public void processRow(Row row) throws Exception {
            String countStr = row.get(this.cf.column(PivotRecipeBuiltinExecutor.COUNT_COLUMN_NAME));
            if (StringUtils.isNotBlank((String)countStr)) {
                long count = Long.parseLong(countStr);
                this.collected.add(new CollectedRow(row, count));
                while (this.collected.size() > this.topnLimit) {
                    this.collected.poll();
                }
            }
        }

        @Override
        public List<List<String>> getModalities() {
            CollectedRow row = this.collected.poll();
            while (row != null) {
                this.collect(row.row);
                row = this.collected.poll();
            }
            return super.getModalities();
        }

        private static class CollectedRow {
            private final Row row;
            private final long count;

            public CollectedRow(Row row, long count) {
                this.row = row;
                this.count = count;
            }
        }
    }

    private static class AtLeastNCollectorRowProcessor
    extends CollectorRowProcessor {
        private final int minOccLimit;

        public AtLeastNCollectorRowProcessor(ColumnFactory cf, List<String> keys, Schema schema, int minOccLimit) {
            super(cf, keys, schema);
            this.minOccLimit = minOccLimit;
        }

        public void processRow(Row row) throws Exception {
            long count;
            String countStr = row.get(this.cf.column(PivotRecipeBuiltinExecutor.COUNT_COLUMN_NAME));
            if (StringUtils.isNotBlank((String)countStr) && (count = Long.parseLong(countStr)) >= (long)this.minOccLimit) {
                this.collect(row);
            }
        }
    }

    private static class CollectAllRowProcessor
    extends CollectorRowProcessor {
        public CollectAllRowProcessor(ColumnFactory cf, List<String> keys, Schema schema) {
            super(cf, keys, schema);
        }

        public void processRow(Row row) throws Exception {
            this.collect(row);
        }
    }

    private static abstract class CollectorRowProcessor
    implements SingleInputRowProcessor {
        private final List<String> keys;
        protected final ColumnFactory cf;
        private final Schema schema;
        private final List<List<String>> modalities = Lists.newArrayList();

        public CollectorRowProcessor(ColumnFactory cf, List<String> keys, Schema schema) {
            this.cf = cf;
            this.keys = keys;
            this.schema = schema;
        }

        public void collect(Row row) {
            ArrayList values = Lists.newArrayList();
            for (String key : this.keys) {
                Column column = this.cf.column(key);
                SchemaColumn schemaColumn = this.schema.getColumn(key);
                String value = row.get(column);
                if (value != null) {
                    Type type = schemaColumn.getType();
                    if (type == Type.BOOLEAN) {
                        values.add(java.lang.Boolean.toString(booleanMeaning.parse(value)));
                        continue;
                    }
                    if (type.isNumeric()) {
                        if (type.isInteger()) {
                            values.add(Long.toString(longMeaning.longValue(value)));
                            continue;
                        }
                        values.add(Double.toString(doubleMeaning.doubleValue(value)));
                        continue;
                    }
                    values.add(value);
                    continue;
                }
                values.add(null);
            }
            this.modalities.add(values);
        }

        public List<List<String>> getModalities() {
            return this.modalities;
        }

        public void postProcess() throws Exception {
        }

        public void cancel() throws Exception {
        }
    }
}

