/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.vstack;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeService;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class VStackRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private VStackRecipeService service;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.vstack.status");

    public VStackRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public VStackRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), authCtx);
    }

    @Override
    public VisualSQLRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        VStackRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
            if (init.dialect == null) {
                throw ErrorContext.iae((String)"No SQL dialect is selected");
            }
            boolean lowerCase = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)status.params, status.getSelectedSQLBasedEngine());
            status.sql = this.service.generateSQL(init.activity, init.dialect, status.params, lowerCase);
        }
        return status;
    }

    @Override
    public VStackRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) {
        VStackRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
            this.fixupStatusOutputInvalid(status);
        }
        if (status.isInvalid()) {
            return status;
        }
        VStackRecipePayloadParams params = status.params;
        SQLDialect dialect = init.dialect;
        Map<String, Dataset> datasetsMap = init.datasetsMap;
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(status.getSelectedSQLBasedEngine(), params);
        }
        try {
            HashSet<Integer> selectedColumnsIndexes;
            boolean queryBased;
            status.canDistinct = queryBased = status.getSelectedSQLBasedEngine().queryBased;
            for (int i = 0; i < params.virtualInputs.size(); ++i) {
                VStackRecipePayloadParams.InputDesc input = (VStackRecipePayloadParams.InputDesc)params.virtualInputs.get(i);
                if (input.preFilter == null || !input.preFilter.enabled && !input.preFilter.distinct) continue;
                if (status.preFilters == null) {
                    status.preFilters = new RecipeStatus.StepStatus();
                }
                this.visualRecipesService.checkFilter(input.preFilter, datasetsMap.get(input.name), dialect, status.preFilters, queryBased);
                for (InfoMessage message : status.preFilters.messages) {
                    if (!message.isFatal || message.line != null) continue;
                    message.line = i;
                }
                if (!input.preFilter.distinct || queryBased) continue;
                status.preFilters.withWarning(RecipeCodes.ERR_RECIPE_VSTACK_INVALID_FILTER, "Distinct option may not available with these input datasets.");
            }
            if (params.selectedColumns == null || params.selectedColumns.isEmpty()) {
                if (params.mode == VStackRecipePayloadParams.SchemaMergeMode.FROM_INDEX || params.mode == VStackRecipePayloadParams.SchemaMergeMode.REMAP) {
                    status.selectedColumns.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_NO_OUTPUT_COLUMN, "No output column");
                } else {
                    status.selectedColumns.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_NO_COLUMN, "Empty list of selected columns.");
                }
                return status;
            }
            if (params.selectedColumns.contains("") || params.selectedColumns.contains(null)) {
                status.selectedColumns.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_INVALID_COLUMN, "Column name is empty");
                return status;
            }
            if ((params.selectedColumnsIndexes == null || params.selectedColumnsIndexes.isEmpty()) && params.mode == VStackRecipePayloadParams.SchemaMergeMode.FROM_INDEX) {
                status.selectedColumns.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_NO_OUTPUT_COLUMN, "No list of selected columns.");
                return status;
            }
            if (params.mode == VStackRecipePayloadParams.SchemaMergeMode.FROM_INDEX && ((selectedColumnsIndexes = new HashSet<Integer>(params.selectedColumnsIndexes)).size() != params.selectedColumnsIndexes.size() || selectedColumnsIndexes.size() != params.selectedColumns.size())) {
                status.selectedColumns.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_INCONSISTENT_OUTPUT_COLUMNS, "Selected output columns names and indexes do not match.");
                return status;
            }
            if (params.mode == VStackRecipePayloadParams.SchemaMergeMode.REMAP) {
                int theoreticalSize = params.selectedColumns.size();
                for (VStackRecipePayloadParams.InputDesc virtualInput : params.virtualInputs) {
                    if (virtualInput.columnsMatch.size() == theoreticalSize) continue;
                    status.selectedColumns.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_COLUMN_MISSMATCH, "Number of target columns do not match number of selected columns.");
                    return status;
                }
            }
            if (params.mode == VStackRecipePayloadParams.SchemaMergeMode.FROM_INDEX || params.mode == VStackRecipePayloadParams.SchemaMergeMode.REMAP) {
                HashSet<Object> selectedColumns;
                boolean lowerCase = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)status.params, status.getSelectedSQLBasedEngine());
                if (lowerCase) {
                    selectedColumns = new HashSet();
                    for (String selectedColumn : params.selectedColumns) {
                        selectedColumns.add(selectedColumn.toLowerCase());
                    }
                } else {
                    selectedColumns = new HashSet<String>(params.selectedColumns);
                }
                if (selectedColumns.size() != params.selectedColumns.size()) {
                    status.selectedColumns.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_DUPLICATE_OUTPUT_COLUMNS, "Duplicate name in output columns.");
                    return status;
                }
            }
            if (params.addOriginColumn) {
                status.originColumn = new RecipeStatus.StepStatus();
                if (StringUtils.isBlank((String)params.originColumnName) || !params.isValidColumnName(params.originColumnName)) {
                    status.originColumn.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_INVALID_COLUMN, "Invalid origin column name");
                    return status;
                }
                for (String selectedCol : params.selectedColumns) {
                    if (!params.originColumnName.equals(selectedCol) && (dialect == null || !dialect.hasCaseInsensitiveColumns() || !params.originColumnName.equalsIgnoreCase(selectedCol))) continue;
                    status.originColumn.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_INVALID_COLUMN, "Invalid origin column name: duplicate");
                    break;
                }
            }
            if (params.postFilter != null) {
                if (params.postFilter.enabled) {
                    status.postFilter = new RecipeStatus.StepStatus();
                    this.visualRecipesService.checkFilter(params.postFilter, new Dataset().withSchema(status.outputSchema), dialect, status.postFilter, queryBased);
                } else if (params.postFilter.distinct) {
                    status.postFilter = new RecipeStatus.StepStatus();
                }
                if (params.postFilter.distinct && !queryBased) {
                    status.postFilter.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_INVALID_FILTER, "Distinct option is not available with the provided input datasets.");
                }
            }
            if (!(!this.needToComputeExecutionPlan(status.getSelectedSQLBasedEngine(), status, request) || status.preFilters != null && status.preFilters.anyFatal() || status.postFilter != null && status.postFilter.anyFatal())) {
                try {
                    status.executionPlan = this.getExecutionPlan(authCtx, init.sources, status.getSelectedSQLBasedEngine(), status.sql, params.engineParams);
                }
                catch (ExecutionPlanService.HiveTableNotFound e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, "Table not found in Hive global metastore: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    logger.info((Object)("Query:\n" + status.sql));
                    status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            if (init.error != null && !status.isInvalid()) {
                status.output = new RecipeStatus.StepStatus();
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, init.error);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Invalid vstack recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        this.fixupStatusOutputInvalid(status);
        return status;
    }

    private VStackRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, AuthCtx authCtx) {
        VStackRecipeStatus status = new VStackRecipeStatus();
        try {
            this.performBasicStructureChecks(status, authCtx);
            FlowRecipe fr = new FlowRecipe(this.recipe);
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(fr));
            status.params = this.service.loadParams(this.payload, this.recipe);
            status.engineParams = status.params.engineParams;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to parse params", (Throwable)e);
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Failed to parse params: %s ", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return status;
        }
        try {
            this.initEngines(authCtx, init, status);
            this.performBasicCDEChecks(status, authCtx);
            RecipeEnginesPreferenceConfig repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, status.params.enginesPreferences);
            this.visualRecipesService.selectEngine(authCtx, init.activity, status.params.engineType, status, this.recipe.type, repc);
            this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Streaming of rows");
            init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
            init.sources = new ArrayList<Dataset>();
            for (FlowDataset fd : init.activity.getSubgraph().getSourceDatasets()) {
                init.sources.add(fd.getMandatory(this.datasetsDAO));
            }
            init.datasetsMap = new HashMap<String, Dataset>();
            for (VStackRecipePayloadParams.InputDesc input : status.params.virtualInputs) {
                init.datasetsMap.put(input.name, ServiceUtils.getDataset(init.activity, this.datasetsDAO, input.name));
            }
            if (status.params.addOriginColumn && StringUtils.isBlank((String)status.params.originColumnName)) {
                status.originColumn = new RecipeStatus.StepStatus();
                status.originColumn.withFatal(RecipeCodes.ERR_RECIPE_VSTACK_INVALID_COLUMN, "Origin column name is empty");
                return status;
            }
            VStackRecipeSchemaComputer schemaComputer = new VStackRecipeSchemaComputer(authCtx, init.activity);
            schemaComputer.setParams(status.params);
            status.outputSchema = schemaComputer.getSchema();
            if (status.getSelectedSQLBasedEngine().queryBased) {
                try {
                    Schema outputSchema = this.service.getOutputSchema(init.activity, status.params, false);
                    status.sql = this.service.generateSQLIgnorePartitioning(init.datasetsMap, new Dataset().withSchema(outputSchema), status.params, init.dialect);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to generate SQL query", (Throwable)e);
                    init.error = e.getMessage();
                }
            }
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        return status;
    }

    private void initEngines(AuthCtx authCtx, StatusInitializer init, VStackRecipeStatus status) throws Exception {
        this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            if (!engine.isSelectable) continue;
            if (!engine.canDistinctSelect) {
                for (VStackRecipePayloadParams.InputDesc input : status.params.virtualInputs) {
                    if (input.preFilter == null || !input.preFilter.distinct) continue;
                    RecipeEngineStatus.setErrorStatus("Cannot use DISTINCT in pre-filter", engine);
                }
                if (status.params.postFilter != null && status.params.postFilter.distinct) {
                    RecipeEngineStatus.setErrorStatus("Cannot use DISTINCT in post-filter", engine);
                }
            }
            if (!engine.queryBased) continue;
            try {
                SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
                if (dialect == null) {
                    throw new Error("Unexpected: no dialect for engine: " + engine.type);
                }
                this.service.generateSQL(init.activity, dialect, status.params, true);
            }
            catch (Exception e) {
                if (engine.type.equals("DSS")) {
                    RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    continue;
                }
                RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
            }
        }
    }

    private void fixupStatusOutputInvalid(VisualSQLRecipeStatus status) {
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Failed to validate all recipe steps");
        }
    }

    private static class StatusInitializer {
        List<Dataset> sources;
        SQLDialect dialect;
        Map<String, Dataset> datasetsMap;
        public JobActivity activity;
        public String error;

        private StatusInitializer() {
        }
    }

    public static class VStackRecipeStatus
    extends VisualSQLRecipeStatus {
        RecipeStatus.StepStatus preFilters;
        RecipeStatus.StepStatus selectedColumns = new RecipeStatus.StepStatus();
        RecipeStatus.StepStatus originColumn;
        RecipeStatus.StepStatus postFilter;
        VStackRecipePayloadParams params;
        boolean canDistinct;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            if (this.preFilters != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.preFilters);
            }
            if (this.selectedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.selectedColumns);
            }
            if (this.originColumn != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.originColumn);
            }
            if (this.postFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.postFilter);
            }
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }
    }
}

