/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph;

import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FlowRunnable
extends GraphNode {
    public abstract String getProjectKey();

    public abstract String getName();

    public abstract String getType();

    public abstract String getId();

    public List<FlowComputable> getSources() {
        ArrayList<FlowComputable> ret = new ArrayList<FlowComputable>(this.predecessors.size());
        for (GraphNode graphNode : this.getPredecessors()) {
            assert (graphNode instanceof FlowComputable);
            ret.add((FlowComputable)graphNode);
        }
        return ret;
    }

    public List<FlowComputable> getTargets() {
        ArrayList<FlowComputable> ret = new ArrayList<FlowComputable>(this.successors.size());
        for (GraphNode graphNode : this.getSuccessors()) {
            assert (graphNode instanceof FlowComputable);
            ret.add((FlowComputable)graphNode);
        }
        return ret;
    }

    public List<FlowComputable.FlowComputableWithRole> getSourcesWithRoles() {
        ArrayList<FlowComputable.FlowComputableWithRole> ret = new ArrayList<FlowComputable.FlowComputableWithRole>(this.predecessors.size());
        for (GraphNode.AnchoredTypedGraphEdge p : this.predecessors) {
            assert (p.node instanceof FlowComputable);
            ret.add(new FlowComputable.FlowComputableWithRole((FlowComputable)p.node, p.role));
        }
        return ret;
    }

    public List<FlowComputable.FlowComputableWithRole> getTargetsWithRoles() {
        ArrayList<FlowComputable.FlowComputableWithRole> ret = new ArrayList<FlowComputable.FlowComputableWithRole>(this.successors.size());
        for (GraphNode.AnchoredTypedGraphEdge s : this.successors) {
            assert (s.node instanceof FlowComputable);
            ret.add(new FlowComputable.FlowComputableWithRole((FlowComputable)s.node, s.role));
        }
        return ret;
    }

    public Map<String, FlowComputable> getSourcesMap() {
        HashMap<String, FlowComputable> ret = new HashMap<String, FlowComputable>();
        for (GraphNode graphNode : this.getPredecessors()) {
            assert (graphNode instanceof FlowComputable);
            FlowComputable fc = (FlowComputable)graphNode;
            ret.put(fc.getFullId(), fc);
        }
        return Collections.unmodifiableMap(ret);
    }

    public Map<String, FlowComputable> getTargetsMap() {
        HashMap<String, FlowComputable> ret = new HashMap<String, FlowComputable>();
        for (GraphNode graphNode : this.getSuccessors()) {
            assert (graphNode instanceof FlowComputable);
            FlowComputable fc = (FlowComputable)graphNode;
            ret.put(fc.getFullId(), fc);
        }
        return Collections.unmodifiableMap(ret);
    }

    public void validateExactly1Source() {
        if (this.getPredecessors().size() == 0) {
            throw ErrorContext.iae((String)"Recipe needs one source, but has none");
        }
        if (this.getPredecessors().size() > 1) {
            throw ErrorContext.iaef((String)"Recipe needs one source, but has %s", (Object)this.getPredecessors().size(), (Object[])new Object[0]);
        }
    }

    public void validateExactly1Target() {
        if (this.getSuccessors().size() == 0) {
            throw ErrorContext.iae((String)"Recipe needs one target, but has none");
        }
        if (this.getSuccessors().size() > 1) {
            throw ErrorContext.iaef((String)"Recipe needs one target, but has %s", (Object)this.getSuccessors().size(), (Object[])new Object[0]);
        }
    }

    public String getSingleSourceId() {
        this.validateExactly1Source();
        return this.getPredecessors().get(0).getFullId();
    }

    public String getSingleTargetName() {
        this.validateExactly1Target();
        return this.getSuccessors().get(0).getFullId();
    }
}

