/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractUserTimeView
extends AbstractFlowTool.FlowView {
    @Autowired
    private UsersService usersService;
    protected UserTimeState state;
    private HashMap<String, String> userDisplayNames;

    protected abstract void add(String var1, TaggableObjectsService.TaggableObject var2);

    public AbstractUserTimeView(AuthCtx authCtx, String projectKey) {
        super(authCtx, projectKey);
    }

    protected void listUsers() throws IOException {
        this.userDisplayNames = new HashMap();
        for (UsersDAO.User u : this.usersService.listUsersInternalUnsafeEnabledOnly()) {
            this.userDisplayNames.put(u.login, u.displayName);
        }
    }

    protected String getUserDisplayName(String userLogin) {
        return this.userDisplayNames.get(userLogin);
    }

    protected void populateStates() throws IOException, InterruptedException {
        try (Transaction tr = this.transactionService.beginRead();){
            String nodeId;
            this.listUsers();
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forRecipe(sr.name);
                this.add(nodeId, sr);
            }
            for (LabelingTask labelingTask : this.labelingTasksDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forLabelingTask(labelingTask.projectKey, labelingTask.id);
                this.add(nodeId, labelingTask);
            }
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forDataset(sd.projectKey, sd.name);
                this.add(nodeId, sd);
            }
            for (ManagedFolder f : this.managedFolderDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forManagedFolder(f.projectKey, f.id);
                this.add(nodeId, f);
            }
            for (SavedModel sm : this.savedModelsDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forSavedModel(sm.projectKey, sm.id);
                this.add(nodeId, sm);
            }
            for (ModelEvaluationStore mes : this.modelEvaluationStoresDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forModelEvaluationStore(mes.projectKey, mes.id);
                this.add(nodeId, mes);
            }
            for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forRetrievableKnowledge(rk.projectKey, rk.id);
                this.add(nodeId, rk);
            }
        }
    }

    @Override
    public synchronized UserTimeState computeState() throws Exception {
        this.state = new UserTimeState();
        this.populateStates();
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focusedItems, String mode) throws Exception {
        super.setFocus(focusedItems, mode);
        this.state.mode = UserTimeMode.valueOf(mode);
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            UserTimeMode currentMode = this.state.mode;
            this.computeState();
            this.state.focused = currentFocus;
            this.state.mode = currentMode;
        } else {
            this.computeState();
        }
        return this.state;
    }

    public class UserTimeState
    implements AbstractFlowTool.FlowState {
        Map<String, ModificationDesc> valueByNode = new HashMap<String, ModificationDesc>();
        public UserTimeMode mode = UserTimeMode.BY_DATE;
        public Collection<String> focused = new HashSet<String>();
    }

    public static enum UserTimeMode {
        BY_USER,
        BY_DATE;

    }

    public class ModificationDesc {
        long time;
        String userLogin;
        String userDisplayName;
    }
}

