/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.dataflow.pdep.AbstractTimeEvaluator;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class CurrentWeekEvaluator
extends AbstractTimeEvaluator {
    private Date flowEpoch;
    private String firstDayInWeek;

    public CurrentWeekEvaluator(Set<Date> blacklist, Date flowEpoch, String firstDayInWeek) {
        super(blacklist);
        this.flowEpoch = flowEpoch;
        this.firstDayInWeek = firstDayInWeek;
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim) {
        Preconditions.checkArgument((boolean)(srcDim instanceof TimeDimension), (Object)"Partitioning dimension is not a time dimension");
        Calendar initialCal = this.getDayLevelCalendar(target);
        if (this.firstDayInWeek.equalsIgnoreCase("monday")) {
            initialCal.setFirstDayOfWeek(2);
        } else if (this.firstDayInWeek.equalsIgnoreCase("sunday")) {
            initialCal.setFirstDayOfWeek(1);
        } else {
            throw ErrorContext.iaef((String)"Unexpected first day of week, expected 'monday' or 'sunday', got '%s'", (Object)this.firstDayInWeek, (Object[])new Object[0]);
        }
        Calendar movingCal = (Calendar)initialCal.clone();
        ArrayList<DimensionValue> ov = new ArrayList<DimensionValue>();
        while (true) {
            if (movingCal.getTime().before(this.flowEpoch)) {
                System.out.println("flowEpoch " + String.valueOf(this.flowEpoch) + " reached at " + String.valueOf(movingCal.getTime()));
                break;
            }
            if (movingCal.get(3) != initialCal.get(3)) {
                System.out.println("Reached beginning at " + String.valueOf(movingCal.getTime()));
                break;
            }
            if (!this.isBlacklisted(movingCal.getTime())) {
                ov.add((DimensionValue)CurrentWeekEvaluator.getValueFromCalendar(movingCal, (TimeDimension)srcDim));
            }
            movingCal.add(5, -1);
        }
        return ov;
    }
}

