/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming.slave;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.autorestart.AutoRestartingLoopCurrentState;
import com.dataiku.dip.autorestart.AutoRestartingLoopThread;
import com.dataiku.dip.autorestart.AutoRestartingProcessRunner;
import com.dataiku.dip.autorestart.AutoRestartingProcessState;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.dataflow.streaming.slave.ContinuousActivityRunner;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class ContinuousActivityMonitor {
    @Autowired
    private FutureService futureService;
    @Autowired
    private ScenarioRunContext scenarioContext;
    private final ContinuousActivity activity;
    private CurrentState currentState;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.streaming.ca.monitor");

    public ContinuousActivityMonitor(ContinuousActivity activity) {
        this.activity = activity;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public FutureResponse<AutoRestartingProcessState> stopAndStart(AuthCtx authCtx, AutoRestartingLoopThread.AutoRestartingLoopParams params) throws Exception {
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to stop CA backend", (Throwable)e);
        }
        AuthCtx realAuthCtx = authCtx;
        logger.info((Object)("Starting CA backend with authCtx: " + String.valueOf(realAuthCtx)));
        this.currentState = new CurrentState();
        this.currentState.authCtx = realAuthCtx;
        this.currentState.loop = new MainLoopThread(this.currentState, params, realAuthCtx);
        this.futureService.registerAndStartNoWait(this.currentState.loop);
        return this.futureService.runFuture(new StartWaitThread(realAuthCtx), 0L, new TypeToken<FutureResponse<AutoRestartingProcessState>>(){});
    }

    public void stop() throws IOException, InterruptedException {
        logger.info((Object)"Stopping CA Kernel for continuous activity...");
        if (this.currentState != null && this.currentState.runner != null) {
            logger.info((Object)"Waiting for CA Kernel to stop ...");
            this.currentState.stop();
            logger.info((Object)"CA Kernel stopped ");
        } else {
            logger.info((Object)"CA Kernel not running, nothing to stop");
        }
    }

    public AutoRestartingProcessState getState() throws IOException {
        AutoRestartingProcessState ret = new AutoRestartingProcessState();
        if (this.currentState != null) {
            if (this.currentState.loop != null) {
                ret.futureId = this.currentState.futureId;
                ret.futureInfo = this.futureService.getProgress(this.currentState.loop);
                ret.runId = this.currentState.loop.runId;
            }
            if (this.currentState.runner != null) {
                ret.currentLogTail = this.currentState.runner.getLogTail();
                ret.attemptId = this.currentState.runner.attemptId;
            }
            if (this.currentState.startFailedException != null) {
                ret.lastError = new SerializedError((Throwable)this.currentState.startFailedException, true);
            } else if (this.currentState.diedException != null) {
                ret.lastError = new SerializedError((Throwable)this.currentState.diedException, true);
            }
            ret.lastCrashLogTail = this.currentState.lastCrashLogTail;
        }
        return ret;
    }

    public static class CurrentState
    extends AutoRestartingLoopCurrentState {
    }

    private class MainLoopThread
    extends AutoRestartingLoopThread {
        public MainLoopThread(CurrentState state, AutoRestartingLoopThread.AutoRestartingLoopParams params, AuthCtx owner) {
            super(state, params, owner, DKUDateUtils.isoFormatFileFriendlyLocalNow());
            this.setScenarioRun(ContinuousActivityMonitor.this.scenarioContext.getScenarioRun(), ContinuousActivityMonitor.this.scenarioContext.getStepRun(), ContinuousActivityMonitor.this.scenarioContext);
        }

        @Override
        protected AutoRestartingProcessRunner buildRunner() {
            return new ContinuousActivityRunner(this.owner, ContinuousActivityMonitor.this.activity, this.runId);
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.displayName = "Runner for continuous activity " + ContinuousActivityMonitor.this.activity.projectKey + " " + ContinuousActivityMonitor.this.activity.recipeId;
            this.enrichPayloadWithState(fp);
            return fp;
        }
    }

    private class StartWaitThread
    extends SimpleFutureThread<AutoRestartingProcessState> {
        private static final long WAIT_STARTED_TIMEOUT = 60000L;

        public StartWaitThread(AuthCtx owner) {
            super(owner);
        }

        @Override
        protected AutoRestartingProcessState compute() throws Exception {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < 60000L) {
                ContinuousActivityRunner car;
                if (ContinuousActivityMonitor.this.currentState != null && ContinuousActivityMonitor.this.currentState.startFailedException != null) {
                    throw ContinuousActivityMonitor.this.currentState.startFailedException;
                }
                if (ContinuousActivityMonitor.this.currentState != null && ContinuousActivityMonitor.this.currentState.runner != null && (car = (ContinuousActivityRunner)ContinuousActivityMonitor.this.currentState.runner).getPid() != null) {
                    return ContinuousActivityMonitor.this.getState();
                }
                Thread.sleep(300L);
            }
            throw new IOException("Webapp backend start timeout");
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.displayName = "Starting CA runner";
            return fp;
        }
    }
}

