/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.utils;

import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import java.util.LinkedList;
import java.util.List;

public class LastRecordsSamplingProcessorOutput
implements ProcessorOutput {
    private final MemTable table;
    private final int targetRecords;
    private final List<MemRow> rows = new LinkedList<MemRow>();
    private long maxMemoryUsed = -1L;
    private long memoryUsed = 0L;

    public LastRecordsSamplingProcessorOutput(MemTable table, int targetRecords) {
        this.table = table;
        this.targetRecords = targetRecords;
    }

    public void emitRow(Row row) throws Exception {
        MemRow memRow = (MemRow)row;
        this.rows.add(memRow);
        this.memoryUsed += memRow.getMemoryUsed();
        if (this.rows.size() > this.targetRecords) {
            MemRow removed = this.rows.remove(0);
            this.memoryUsed -= removed.getMemoryUsed();
        }
        if (this.maxMemoryUsed > 0L && this.memoryUsed >= this.maxMemoryUsed) {
            this.table.rows.addAll(this.rows);
            throw new MemTableAppendingOutput.MemTableSizeLimitReachedException(this.table.rows.size(), this.memoryUsed);
        }
    }

    public void lastRowEmitted() throws Exception {
        this.table.rows.addAll(this.rows);
    }

    public void cancel() throws Exception {
    }

    public void setMaxMemoryUsed(long size) {
        this.maxMemoryUsed = size;
    }
}

