/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@UIModel
public class DataQualityOutcome {
    public static final DataQualityOutcome NONE = new DataQualityOutcome(0, 0, 0, 0);
    public final int errorCount;
    public final int warningCount;
    public final int okCount;
    public final int emptyCount;

    public DataQualityOutcome(int errorCount, int warningCount, int okCount, int emptyCount) {
        this.errorCount = errorCount;
        this.warningCount = warningCount;
        this.okCount = okCount;
        this.emptyCount = emptyCount;
    }

    public DataQualityOutcome(Stream<AbstractCheckContext.CheckOutcome> from) {
        Map map = from.filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        this.errorCount = map.getOrDefault((Object)AbstractCheckContext.CheckOutcome.ERROR, 0L).intValue();
        this.warningCount = map.getOrDefault((Object)AbstractCheckContext.CheckOutcome.WARNING, 0L).intValue();
        this.okCount = map.getOrDefault((Object)AbstractCheckContext.CheckOutcome.OK, 0L).intValue();
        this.emptyCount = map.getOrDefault((Object)AbstractCheckContext.CheckOutcome.EMPTY, 0L).intValue();
    }

    @Nullable
    public AbstractCheckContext.CheckOutcome getOutcome() {
        if (this.errorCount > 0) {
            return AbstractCheckContext.CheckOutcome.ERROR;
        }
        if (this.warningCount > 0) {
            return AbstractCheckContext.CheckOutcome.WARNING;
        }
        if (this.okCount > 0) {
            return AbstractCheckContext.CheckOutcome.OK;
        }
        if (this.emptyCount > 0) {
            return AbstractCheckContext.CheckOutcome.EMPTY;
        }
        return null;
    }

    public int getOutcomeCount() {
        if (this.errorCount > 0) {
            return this.errorCount;
        }
        if (this.warningCount > 0) {
            return this.warningCount;
        }
        if (this.okCount > 0) {
            return this.okCount;
        }
        return this.emptyCount;
    }

    public int totalCount() {
        return this.emptyCount + this.okCount + this.warningCount + this.errorCount;
    }
}

