/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamodb;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.dynamodb.DynamoDBConnectionWrapper;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBTypeConverter;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.TableDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import com.google.common.primitives.Ints;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class DynamoDBDatasetInputHandler {
    protected DynamoDBDatasetHandler datasetHandler;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.dynamodb");

    public abstract void createManaged() throws Exception;

    public abstract List<Partition> listPartitions() throws Exception;

    public abstract void updateIndex() throws Exception;

    public abstract RowsInputSplit getPartitionSplit(Partition var1) throws Exception;

    public abstract FilterResultWithSplits getFilterSplits(InputFilter var1) throws Exception;

    public abstract RowsInputSplit getSingleSplit() throws Exception;

    public abstract RowsInputSplit getSampleSplit() throws Exception;

    public abstract long computePartitionRecords(Partition var1) throws Exception;

    public abstract void clearPartitions(List<Partition> var1) throws Exception;

    protected long executePush(QueryRequest q, ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
        DynamoDBTypeConverter typeConverter = new DynamoDBTypeConverter();
        long rowsBefore = listener == null ? 0L : listener.getReadRecords();
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            logger.info((Object)("Enumerating table :" + this.datasetHandler.config.table + (String)(q != null && !q.expressionAttributeValues().isEmpty() && !q.expressionAttributeNames().isEmpty() ? " with fields " + (String)q.expressionAttributeNames().values().iterator().next() + " = " + String.valueOf(q.expressionAttributeValues().values().iterator().next()) : "") + (String)(limit != null && limit.maxRecords > 0L ? " with limit " + limit.maxRecords : "")));
            if (limit != null && limit.maxRecords > 0L && limit.maxRecords > Integer.MAX_VALUE) {
                limit.maxRecords = Integer.MAX_VALUE;
            }
            HashMap<String, SchemaColumn> schemaColumnsMap = new HashMap<String, SchemaColumn>();
            Schema schema = this.datasetHandler.getDataset().getSchema();
            if (schema != null) {
                for (SchemaColumn col : schema.getColumns()) {
                    schemaColumnsMap.put(col.getName(), col);
                    cf.column(col.getName());
                }
            }
            long rowsPushed = 0L;
            if (q != null) {
                if (limit != null && limit.maxRecords > 0L) {
                    Iterator queryBuilder = q.toBuilder();
                    queryBuilder.limit(Ints.checkedCast((long)limit.maxRecords));
                    q = (QueryRequest)queryBuilder.build();
                }
                for (QueryResponse queryResponse : dynamoConn.client.queryPaginator(q)) {
                    if (limit == null || limit.maxRecords <= 0L || rowsPushed < limit.maxRecords) {
                        rowsPushed = this.pushItemsFromResponse(queryResponse.items(), rowsPushed, rowsBefore, typeConverter, schemaColumnsMap, out, cf, rf, limit, listener, warningsContext);
                        continue;
                    }
                    break;
                }
            } else {
                ScanRequest.Builder scanRequestBuilder = ScanRequest.builder().tableName(this.datasetHandler.config.table);
                if (limit != null && limit.maxRecords > 0L) {
                    scanRequestBuilder.limit(Integer.valueOf((int)limit.maxRecords));
                }
                ScanRequest scanRequest = (ScanRequest)scanRequestBuilder.build();
                for (ScanResponse scanResponse : dynamoConn.client.scanPaginator(scanRequest)) {
                    if (limit == null || limit.maxRecords <= 0L || rowsPushed < limit.maxRecords) {
                        rowsPushed = this.pushItemsFromResponse(scanResponse.items(), rowsPushed, rowsBefore, typeConverter, schemaColumnsMap, out, cf, rf, limit, listener, warningsContext);
                        continue;
                    }
                    break;
                }
            }
            logger.info((Object)"Finished emitting rows");
            long l = rowsPushed;
            return l;
        }
    }

    private long pushItemsFromResponse(List<Map<String, AttributeValue>> items, long currentRowsPushed, long rowsBefore, DynamoDBTypeConverter typeConverter, Map<String, SchemaColumn> schemaColumnsMap, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
        long rowsPushed = currentRowsPushed;
        for (Map<String, AttributeValue> item : items) {
            Row r = rf.row();
            for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
                String key = entry.getKey();
                if (key.equals("__dku_id__")) continue;
                JsonElement colValue = typeConverter.getDynamoValue(entry.getValue(), schemaColumnsMap.get(key), this.datasetHandler.config.readDataTypeMismatchBehavior, warningsContext);
                if (colValue == null || colValue.isJsonNull()) {
                    r.put(cf.column(key), null);
                    continue;
                }
                if (colValue.isJsonPrimitive()) {
                    r.put(cf.column(key), colValue.getAsString());
                    continue;
                }
                r.put(cf.column(key), colValue.toString());
            }
            if (listener != null && ++rowsPushed % 50L == 0L) {
                listener.setData(0L, 0L, rowsBefore + rowsPushed);
            }
            out.emitRow(r);
            if (limit == null || limit.maxRecords <= 0L || rowsPushed < limit.maxRecords) continue;
            break;
        }
        return rowsPushed;
    }

    protected void deleteAllGlobalSecondaryIndexes(DynamoDBConnectionWrapper dynamoConn, String tableName) throws InterruptedException {
        logger.info((Object)("Deleting all existing Global Secondary Index for table " + tableName));
        DescribeTableResponse describeResponse = dynamoConn.client.describeTable(builder -> builder.tableName(tableName));
        List gsiList = describeResponse.table().globalSecondaryIndexes();
        if (gsiList != null) {
            for (GlobalSecondaryIndexDescription gsiDesc : gsiList) {
                GlobalSecondaryIndexUpdate deleteIndexUpdate = (GlobalSecondaryIndexUpdate)GlobalSecondaryIndexUpdate.builder().delete((DeleteGlobalSecondaryIndexAction)DeleteGlobalSecondaryIndexAction.builder().indexName(gsiDesc.indexName()).build()).build();
                UpdateTableRequest updateRequest = (UpdateTableRequest)UpdateTableRequest.builder().tableName(tableName).globalSecondaryIndexUpdates(new GlobalSecondaryIndexUpdate[]{deleteIndexUpdate}).build();
                dynamoConn.client.updateTable(updateRequest);
                this.waitForIndexDelete(dynamoConn, tableName, gsiDesc.indexName());
            }
        }
    }

    private void waitForIndexDelete(DynamoDBConnectionWrapper dynamoConn, String tableName, String indexName) throws InterruptedException {
        TableDescription table;
        List list;
        block0: while ((list = (table = dynamoConn.client.describeTable(builder -> builder.tableName(tableName)).table()).globalSecondaryIndexes()) != null) {
            for (GlobalSecondaryIndexDescription d : list) {
                if (!d.indexName().equals(indexName)) continue;
                IndexStatus status = d.indexStatus();
                if (status == IndexStatus.DELETING) {
                    Thread.sleep(5000L);
                    continue block0;
                }
                throw new IllegalArgumentException("Global Secondary Index " + indexName + " is not being deleted (with status=" + String.valueOf(status) + ")");
            }
        }
    }

    public class GlobalSplit
    extends RowsInputSplit {
        protected InputFilter filter;

        GlobalSplit() {
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return DynamoDBDatasetInputHandler.this.executePush(null, out, cf, rf, limit, listener, warningsContext);
        }

        public String getDesc() {
            return "DynamoDB";
        }
    }
}

