/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.error.platform.NotFound;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.VolumeInfo;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.VolumesAPI;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DatabricksVolumeFSTestProvider
implements FSTestProvider {
    private final DatabricksVolumeConnection connection;
    private final BuiltinFSDatasets.DatabricksVolumeDatasetConfig config;
    private final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fstestproviders.databricksVolume");

    public DatabricksVolumeFSTestProvider(AuthCtx authCtx, DSSConnection connection, AbstractFSDatasetHandler.AbstractFSConfig config) {
        this.authCtx = authCtx;
        this.config = (BuiltinFSDatasets.DatabricksVolumeDatasetConfig)config;
        this.connection = (DatabricksVolumeConnection)connection;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, String> test(boolean listVolumes) throws IOException, CodedException, DKUSecurityException {
        HashMap connectionMetadata = Maps.newHashMap();
        VolumesAPI volumesClient = new VolumesAPI(this.connection.getApiClient(this.authCtx));
        String chvolume = this.connection.params.chvolume;
        if (StringUtils.isBlank((String)chvolume) && listVolumes) {
            logger.info((Object)"Listing volumes");
            try {
                ArrayList<String> volumes = new ArrayList<String>();
                for (VolumeInfo volume : volumesClient.list(this.connection.params.catalog, this.connection.params.schema)) {
                    volumes.add(volume.getName());
                }
                connectionMetadata.put("couldListBuckets", "true");
                connectionMetadata.put("buckets", StringUtils.join(volumes, (String)","));
                logger.info((Object)("Listed " + volumes.size() + " volumes"));
            }
            catch (Exception e) {
                connectionMetadata.put("couldListBuckets", "false");
                connectionMetadata.put("bucketsListError", e.getMessage());
                logger.info((Object)("Can't list volumes: " + e.getMessage()), (Throwable)e);
            }
        }
        String volumeName = StringUtils.isNotBlank((String)chvolume) ? chvolume : this.config.volume;
        connectionMetadata.put("constrainedBucket", this.connection.params.chvolume);
        if (StringUtils.isBlank((String)volumeName)) {
            logger.info((Object)"No volume specified, only checking connection");
            try {
                volumesClient.read("main.default.notarealvolume");
            }
            catch (NotFound e) {
                logger.info((Object)"Databricks replied");
            }
        } else {
            boolean volumeExists = false;
            logger.info((Object)("Checking volume " + volumeName));
            try {
                VolumeInfo volume;
                volume = volumesClient.read(String.format("%s.%s.%s", this.connection.params.catalog, this.connection.params.schema, volumeName));
                volumeExists = true;
            }
            catch (Exception e) {
                volumeExists = false;
                logger.info((Object)("error checking whether volume exists: " + volumeName), (Throwable)e);
            }
            connectionMetadata.put("bucketExists", Boolean.toString(volumeExists));
        }
        connectionMetadata.put("connectionValid", "true");
        return connectionMetadata;
    }
}

