/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.datasets.fs.ACLAware;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFSProvider
extends FSLikeFSProvider
implements ACLAware,
PathToURIConverter {
    private static final Logger log = LoggerFactory.getLogger(RemoteFSProvider.class);
    private final FsConnection connection;
    private final String connectionName;
    private final String executionId;
    private final String rootPath;
    private final String root;
    private final TicketBasedIntercomAPIClient client;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fs.remote");

    public RemoteFSProvider(DSSConnection connection, String rootPath) throws IOException, DKUSecurityException {
        assert (connection instanceof FsConnection);
        this.connection = (FsConnection)connection;
        this.connectionName = StringUtils.defaultIfBlank((String)connection.name, (String)"");
        this.executionId = System.getenv("DKU_EXECUTION_ID");
        this.rootPath = this.patchRootPath(rootPath);
        this.root = RemoteFSProvider.buildRoot(this.connection.params.root, rootPath);
        this.client = CDEProcessUtils.newIntercomAPIClient();
    }

    private String patchRootPath(String path) {
        String dipHome = ApplicationConfigurator.getFile((String[])new String[0]).getAbsolutePath();
        String preinstalledPluginsDir = ApplicationConfigurator.getPreInstalledPluginsFolder().getAbsolutePath();
        if (path.startsWith(dipHome)) {
            return "${dip.home}/" + path.substring(dipHome.length());
        }
        if (path.startsWith(preinstalledPluginsDir)) {
            return "${dku.install.dir.plugins}/" + path.substring(preinstalledPluginsDir.length());
        }
        return path;
    }

    private static String buildRoot(String connectionRoot, String path) {
        return ChrootUtils.getChrootedPath(connectionRoot, path, false);
    }

    private String makePath(String path) {
        if (path == null) {
            return "/";
        }
        return PathUtils.makeLeadingNoTrailing((String)PathUtils.canonical((String)path));
    }

    private String makeFile(String prefix) {
        String path = this.makePath(prefix);
        return path.isEmpty() || "/".equals(path) ? this.root : PathUtils.concatLNT((String[])new String[]{this.root, path.substring(1)});
    }

    public void close() throws IOException {
        this.client.close();
    }

    public String convertPathToURI(String path) {
        try {
            return (String)this.client.getForm("/tintercom/fsproviders/convert-to-uri", String.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
        }
        catch (IOException e) {
            logger.error((Object)"Failed to get real URI path on remote FS", (Throwable)e);
            throw new RuntimeException("Failed to resolve URI", e);
        }
    }

    @Override
    public String getConnectionRootWithinURIAuthority() {
        return StringUtils.defaultIfEmpty((String)this.connection.params.root, (String)"");
    }

    @Override
    public String getRoot() {
        try {
            return (String)this.client.getForm("/tintercom/fsproviders/root", String.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath});
        }
        catch (IOException e) {
            logger.error((Object)"Failed to get real absolute path on remote FS", (Throwable)e);
            throw new RuntimeException("Failed to resolve connection root", e);
        }
    }

    public FSBrowsePath browse(String path, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException, CodedException {
        return (FSBrowsePath)this.client.getForm("/tintercom/fsproviders/browse", FSBrowsePath.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path, "strategy", JSON.json((Object)strategy)});
    }

    public FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings enumerationSettings) throws IOException, CodedException, DKUSecurityException {
        return (FSEnumerationResult)this.client.getForm("/tintercom/fsproviders/enumerate", LocalFSProvider.LocalFSEnumerationResult.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "prefix", prefix, "enumerationSettings", JSON.json((Object)enumerationSettings)});
    }

    public FSPathOrDirectory stat(String path) throws IOException, CodedException, DKUSecurityException {
        return (FSPathOrDirectory)this.client.getForm("/tintercom/fsproviders/stat", FSPathOrDirectory.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
    }

    public void setLastModified(String path, long lastModified) throws IOException, CodedException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/last-modified", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path, "lastModified", lastModified});
    }

    public void deleteRecursive(String path) throws IOException, CodedException, DKUSecurityException {
        this.client.delete("/tintercom/fsproviders/delete", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
    }

    public void moveDirectory(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/move-directory", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "from", from, "to", to});
    }

    public void moveFile(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/move-file", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "from", from, "to", to});
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, CodedException, DKUSecurityException {
        return (Map)this.client.getForm("/tintercom/fsproviders/access-info", (TypeToken)new TypeToken<Map<String, String>>(){}, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "withSensitiveInfo", withSensitiveInfo});
    }

    public void makeEmpty(String path) throws IOException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/empty", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
    }

    public void ensureDirectory(String path) throws IOException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/ensure-directory", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "path", path});
    }

    @Override
    public void grantFullACLs(AuthCtx authCtx, String projectKey) throws IOException, InterruptedException, DKUSecurityException {
        this.client.postFormToJSON("/tintercom/fsproviders/grant-full-acls", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "projectKey", projectKey});
    }

    @Override
    public void grantReadACLs(AuthCtx authCtx, String projectKey) throws DKUSecurityException, IOException, InterruptedException {
        this.client.postFormToJSON("/tintercom/fsproviders/grant-read-acls", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath, "projectKey", projectKey});
    }

    @Override
    public void tightenAccess(AuthCtx authCtx) throws IOException, InterruptedException {
        this.client.postFormToJSON("/tintercom/fsproviders/tighten", Void.class, new Object[]{"connectionName", this.connectionName, "executionId", this.executionId, "rootPath", this.rootPath});
    }

    public EnrichedInputStream read(String path) throws IOException, CodedException, DKUSecurityException {
        FSPathOrDirectory file = this.stat(path);
        return new RemoteFSEnrichedInputStream(file.getSize(), path, PathUtils.getLastPathSegment((String)file.path()), file.path(), file.getLastModified());
    }

    public OutputStream write(String path) throws IOException, CodedException, DKUSecurityException {
        TicketBasedIntercomAPIClient writeClient = CDEProcessUtils.newIntercomAPIClient();
        String writePath = this.makeFile(path);
        String fileName = PathUtils.getLastPathSegment((String)writePath);
        RemoteFSWriteThread writerThread = new RemoteFSWriteThread(writeClient, path, fileName);
        writerThread.start();
        return writerThread.getOutputStream();
    }

    public class RemoteFSEnrichedInputStream
    extends AutoEnrichedInputStream {
        public RemoteFSEnrichedInputStream(long size, String pathWithinProvider, String filename, String desc, long lastModified) {
            super(size, pathWithinProvider, filename, desc, () -> lastModified);
        }

        protected InputStream getBasicInputStream() throws IOException {
            final TicketBasedIntercomAPIClient readClient = CDEProcessUtils.newIntercomAPIClient();
            return new FilterInputStream(readClient.getFormToInputStream("/tintercom/fsproviders/read", new Object[]{"connectionName", RemoteFSProvider.this.connectionName, "executionId", RemoteFSProvider.this.executionId, "rootPath", RemoteFSProvider.this.rootPath, "path", this.getPathWithinProvider()})){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        readClient.close();
                    }
                }
            };
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException {
            return this.getBasicInputStream();
        }
    }

    public class RemoteFSWriteThread
    extends Thread {
        private final TicketBasedIntercomAPIClient writeClient;
        private final String path;
        private final String fileName;
        private final PipedInputStream pin;
        private final PipedOutputStream pos;
        private Throwable thrown;

        public RemoteFSWriteThread(TicketBasedIntercomAPIClient writeClient, String path, String fileName) throws IOException {
            this.writeClient = writeClient;
            this.path = path;
            this.fileName = fileName;
            this.pin = new PipedInputStream();
            this.pos = new PipedOutputStream();
            this.pos.connect(this.pin);
        }

        public OutputStream getOutputStream() {
            return new FilterOutputStream(this.pos){

                @Override
                public void close() throws IOException {
                    logger.info((Object)"Close stream to remote");
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            RemoteFSWriteThread.this.join();
                        }
                        catch (Exception e) {
                            throw new IOException("Error while waiting for writer thread", e);
                        }
                        finally {
                            RemoteFSWriteThread.this.writeClient.close();
                        }
                    }
                    if (RemoteFSWriteThread.this.thrown != null) {
                        throw new IOException("Error in writer thread", RemoteFSWriteThread.this.thrown);
                    }
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.out.write(b, off, len);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block43: {
                LaggableInputStream lisToClose;
                IOException exception;
                Thread acksThread;
                String sessionId;
                block37: {
                    block36: {
                        int retryCount;
                        LaggableInputStream lis;
                        sessionId = null;
                        int bufSize = 0;
                        int hbDelay = 0;
                        acksThread = null;
                        int maxRetries = 5;
                        exception = null;
                        lisToClose = null;
                        JsonObject sessionInfo = (JsonObject)this.writeClient.postFormToJSON("/tintercom/fsproviders/start-write", JsonObject.class, new Object[]{"connectionName", RemoteFSProvider.this.connectionName, "executionId", RemoteFSProvider.this.executionId, "rootPath", RemoteFSProvider.this.rootPath, "path", this.path});
                        sessionId = sessionInfo.get("id").getAsString();
                        bufSize = sessionInfo.get("bufSize").getAsInt();
                        hbDelay = sessionInfo.get("hbDelay").getAsInt();
                        lisToClose = lis = new LaggableInputStream(this.pin, 4 * bufSize);
                        AtomicLong lastAck = new AtomicLong(0L);
                        acksThread = new AcksThread(sessionId, lis, lastAck, hbDelay, maxRetries);
                        acksThread.setDaemon(true);
                        acksThread.start();
                        for (retryCount = 0; !lis.isDone() && retryCount < maxRetries; ++retryCount) {
                            long readFrom = lastAck.get();
                            lis.seek(readFrom, retryCount);
                            logger.info((Object)("Push data from " + readFrom));
                            try {
                                SerializedError writeError = (SerializedError)this.writeClient.postFormAndStreamToJSON("/tintercom/fsproviders/push-write-data", SerializedError.class, lis, new Object[]{"sessionId", sessionId, "sessionStartAck", readFrom, "attempt", retryCount});
                                if (writeError != null && StringUtils.isNotBlank((String)writeError.errorType)) {
                                    logger.error((Object)("Error while writing data on write end: " + writeError.getLoggable()));
                                    this.thrown = new APIError.SerializedErrorException(writeError);
                                    break;
                                }
                                logger.info((Object)"Done pushing data");
                                exception = null;
                                break;
                            }
                            catch (IOException e) {
                                logger.warn((Object)("Push failed on try " + (retryCount + 1)), (Throwable)e);
                                exception = e;
                                continue;
                            }
                        }
                        if (retryCount >= maxRetries) {
                            logger.warn((Object)("Exited push thread because number of retries reached " + maxRetries));
                        }
                        if (lisToClose == null) break block36;
                        try {
                            lisToClose.closeReally();
                        }
                        catch (IOException e) {
                            logger.warn((Object)"Unable to close the input stream", (Throwable)e);
                            if (this.thrown != null) break block36;
                            this.thrown = e;
                        }
                    }
                    if (sessionId != null) {
                        try {
                            this.writeClient.postFormToStringV("/tintercom/fsproviders/finish-write", new Object[]{"sessionId", sessionId, "exception", exception != null ? ExceptionUtils.getMessageWithCauses((Throwable)exception) : ""});
                        }
                        catch (IOException e) {
                            logger.warn((Object)("Unable to finish write session " + sessionId), (Throwable)e);
                            if (this.thrown != null) break block37;
                            this.thrown = e;
                        }
                    }
                }
                if (acksThread != null) {
                    acksThread.interrupt();
                    try {
                        acksThread.join();
                    }
                    catch (InterruptedException e) {
                        logger.warn((Object)("Unable to wait for acks threads of session " + sessionId), (Throwable)e);
                        if (this.thrown == null) {
                            this.thrown = e;
                        }
                    }
                }
                break block43;
                catch (Throwable e) {
                    block39: {
                        block38: {
                            try {
                                logger.error((Object)"Failed to write data", e);
                                this.thrown = e;
                                if (lisToClose == null) break block38;
                            }
                            catch (Throwable throwable) {
                                block42: {
                                    block41: {
                                        block40: {
                                            if (lisToClose != null) {
                                                try {
                                                    lisToClose.closeReally();
                                                }
                                                catch (IOException e2) {
                                                    logger.warn((Object)"Unable to close the input stream", (Throwable)e2);
                                                    if (this.thrown != null) break block40;
                                                    this.thrown = e2;
                                                }
                                            }
                                        }
                                        if (sessionId != null) {
                                            try {
                                                this.writeClient.postFormToStringV("/tintercom/fsproviders/finish-write", new Object[]{"sessionId", sessionId, "exception", exception != null ? ExceptionUtils.getMessageWithCauses(exception) : ""});
                                            }
                                            catch (IOException e3) {
                                                logger.warn((Object)("Unable to finish write session " + sessionId), (Throwable)e3);
                                                if (this.thrown != null) break block41;
                                                this.thrown = e3;
                                            }
                                        }
                                    }
                                    if (acksThread != null) {
                                        acksThread.interrupt();
                                        try {
                                            acksThread.join();
                                        }
                                        catch (InterruptedException e4) {
                                            logger.warn((Object)("Unable to wait for acks threads of session " + sessionId), (Throwable)e4);
                                            if (this.thrown != null) break block42;
                                            this.thrown = e4;
                                        }
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                lisToClose.closeReally();
                            }
                            catch (IOException e5) {
                                logger.warn((Object)"Unable to close the input stream", (Throwable)e5);
                                if (this.thrown != null) break block38;
                                this.thrown = e5;
                            }
                        }
                        if (sessionId != null) {
                            try {
                                this.writeClient.postFormToStringV("/tintercom/fsproviders/finish-write", new Object[]{"sessionId", sessionId, "exception", exception != null ? ExceptionUtils.getMessageWithCauses(exception) : ""});
                            }
                            catch (IOException e6) {
                                logger.warn((Object)("Unable to finish write session " + sessionId), (Throwable)e6);
                                if (this.thrown != null) break block39;
                                this.thrown = e6;
                            }
                        }
                    }
                    if (acksThread != null) {
                        acksThread.interrupt();
                        try {
                            acksThread.join();
                        }
                        catch (InterruptedException e7) {
                            logger.warn((Object)("Unable to wait for acks threads of session " + sessionId), (Throwable)e7);
                            if (this.thrown == null) {
                                this.thrown = e7;
                            }
                        }
                    }
                }
            }
        }

        private class AcksThread
        extends Thread {
            private final String sessionId;
            private final LaggableInputStream lis;
            private final AtomicLong lastAck;
            private final int hbDelay;
            private final int maxRetries;

            public AcksThread(String sessionId, LaggableInputStream lis, AtomicLong lastAck, int hbDelay, int maxRetries) {
                this.sessionId = sessionId;
                this.lis = lis;
                this.lastAck = lastAck;
                this.hbDelay = hbDelay;
                this.maxRetries = maxRetries;
            }

            @Override
            public void run() {
                int retryCount;
                for (retryCount = 0; retryCount < this.maxRetries; ++retryCount) {
                    long lastHeartbeat = System.currentTimeMillis();
                    try {
                        logger.info((Object)("Start getting acks of session " + this.sessionId));
                        HttpEntity acksStream = RemoteFSWriteThread.this.writeClient.postFormToStreamWithTimeout("/tintercom/fsproviders/pull-write-acks", 3 * this.hbDelay, new Object[]{"sessionId", this.sessionId});
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(acksStream.getContent()));){
                            String line = reader.readLine();
                            while (line != null) {
                                if (!line.isBlank()) {
                                    if ((line = line.trim()).startsWith("ack:")) {
                                        long ack = Long.parseLong(line.substring("ack:".length()));
                                        logger.trace(() -> " < ack " + ack + " from reader end");
                                        this.lis.ack(ack);
                                        this.lastAck.set(ack);
                                    } else {
                                        if (line.startsWith("{")) {
                                            throw new IOException("Error from ack side");
                                        }
                                        if (line.startsWith("hb")) {
                                            lastHeartbeat = System.currentTimeMillis();
                                        } else if (line.startsWith("exc:")) {
                                            int pushRetryCount = Integer.parseInt(line.substring("exc:".length()));
                                            logger.trace(() -> " < exception on push try " + pushRetryCount);
                                            this.lis.noticeDeath(retryCount);
                                        } else {
                                            throw new IOException("Unexpected ack line : " + line);
                                        }
                                    }
                                }
                                line = reader.readLine();
                            }
                        }
                        logger.info((Object)("Done getting acks of session " + this.sessionId));
                        break;
                    }
                    catch (JsonSyntaxException | IOException e) {
                        logger.error((Object)("Failed to get acks on try " + (retryCount + 1) + ", last heartbeat on " + DKUDateUtils.isoFormatLocal((long)lastHeartbeat)), e);
                        continue;
                    }
                }
                if (retryCount >= this.maxRetries) {
                    this.lis.noticeDeath(new IOException("Exited acks thread because number of retries reached " + this.maxRetries));
                }
            }
        }
    }

    public static class LaggableInputStream
    extends InputStream
    implements InternalAPIClient.DataDestinationNotifier {
        private final InputStream in;
        private final byte[] buf;
        private long streamPos;
        private long streamBufStart;
        private int bufRead;
        private boolean eos = false;
        private OutputStream writingTo;
        private int currentRetry = 0;
        private Map<Integer, String> deadTries = new ConcurrentHashMap<Integer, String>();
        private IOException ackFailure;

        LaggableInputStream(InputStream in, int bufSize) {
            this.in = in;
            this.buf = new byte[bufSize];
            this.streamPos = 0L;
            this.streamBufStart = 0L;
            this.bufRead = 0;
        }

        @Override
        public void close() throws IOException {
        }

        public void closeReally() throws IOException {
            this.in.close();
        }

        public synchronized void accept(OutputStream outputStream) {
            this.writingTo = outputStream;
        }

        public synchronized boolean isDone() {
            int bufPos = (int)(this.streamPos - this.streamBufStart);
            return this.eos && bufPos >= this.bufRead;
        }

        @Override
        public synchronized int read() throws IOException {
            byte[] b = new byte[1];
            int r = this.read(b, 0, 1);
            if (r < 0) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        @Override
        public synchronized int read(@Nonnull byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public synchronized int read(@Nonnull byte[] b, int off, int len) throws IOException {
            if (this.ackFailure != null) {
                throw this.ackFailure;
            }
            int bufPos = (int)(this.streamPos - this.streamBufStart);
            int bufAvail = 0;
            while (bufAvail == 0) {
                while (!this.eos && this.bufRead < this.buf.length) {
                    int r = this.in.read(this.buf, this.bufRead, this.buf.length - this.bufRead);
                    if (r < 0) {
                        this.eos = true;
                        continue;
                    }
                    this.bufRead += r;
                }
                bufPos = (int)(this.streamPos - this.streamBufStart);
                bufAvail = this.bufRead - bufPos;
                if (bufAvail == 0 && this.eos) {
                    return -1;
                }
                if (bufAvail != 0) continue;
                logger.trace(() -> "Wait at " + this.streamPos + " because buffer is " + this.streamBufStart + " + " + this.bufRead);
                try {
                    long startWait = System.currentTimeMillis();
                    this.wait(30000L);
                    if (this.ackFailure != null) {
                        throw this.ackFailure;
                    }
                    if (this.deadTries.containsKey(this.currentRetry)) {
                        throw new IOException("Stream detected dead on read end");
                    }
                    if (this.writingTo == null || System.currentTimeMillis() - startWait <= 20000L) continue;
                    logger.trace(() -> "Check on the output stream");
                    this.writingTo.flush();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted while waiting for stream consumption", e);
                }
            }
            int copy = Math.min(bufAvail, len);
            if (copy > 0) {
                System.arraycopy(this.buf, bufPos, b, off, copy);
                this.streamPos += (long)copy;
            }
            return copy;
        }

        public synchronized void ack(long pos) throws IOException {
            if (pos < this.streamBufStart) {
                throw new IOException("Can't ack before buffer: " + pos + " < " + this.streamBufStart);
            }
            if (pos > this.streamPos) {
                throw new IOException("Can't ack after last read : " + pos + " > " + this.streamPos);
            }
            int shift = (int)(pos - this.streamBufStart);
            System.arraycopy(this.buf, shift, this.buf, 0, this.buf.length - shift);
            this.streamBufStart += (long)shift;
            this.bufRead -= shift;
            this.notifyAll();
        }

        public synchronized void seek(long pos, int retryCount) throws IOException {
            if (pos < this.streamBufStart) {
                throw new IOException("Can't seek before buffer: " + pos + " < " + this.streamBufStart);
            }
            long streamBufEnd = this.streamBufStart + (long)this.bufRead;
            if (pos > streamBufEnd) {
                throw new IOException("Can't seek after last read : " + pos + " > " + streamBufEnd);
            }
            this.streamPos = pos;
            this.currentRetry = retryCount;
            this.notifyAll();
        }

        public synchronized void noticeDeath(int retryCount) {
            this.deadTries.put(retryCount, "dead");
            this.notifyAll();
        }

        public synchronized void noticeDeath(IOException failure) {
            this.ackFailure = failure;
            this.notifyAll();
        }
    }
}

