/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuilder;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.LoadedFSProvider;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CustomFSProviderBuildersRegistry {
    private static final Map<String, CustomFSProviderBuilder<? extends LoadedFSProvider<? extends CustomFSProviderDesc>>> fsProviderBuilders = new HashMap<String, CustomFSProviderBuilder<? extends LoadedFSProvider<? extends CustomFSProviderDesc>>>();

    private CustomFSProviderBuildersRegistry() {
    }

    public static synchronized void register(CustomFSProviderBuilder<? extends LoadedFSProvider<? extends CustomFSProviderDesc>> fsProviderBuilder) {
        fsProviderBuilders.put(fsProviderBuilder.getType(), fsProviderBuilder);
    }

    public static synchronized void deregister(String fsProviderType) {
        fsProviderBuilders.remove(fsProviderType);
    }

    public static synchronized boolean has(String fsProviderType) {
        return fsProviderBuilders.containsKey(fsProviderType);
    }

    public static synchronized CustomFSProviderBuilder<? extends LoadedFSProvider<? extends CustomFSProviderDesc>> get(String fsProviderType) {
        if (!fsProviderBuilders.containsKey(fsProviderType)) {
            throw UnavailableDSSObjectException.fromObjectTypeAndType("fsprovider", fsProviderType);
        }
        return fsProviderBuilders.get(fsProviderType);
    }

    public static synchronized Collection<String> getTypes() {
        return new ArrayList<String>(fsProviderBuilders.keySet());
    }
}

