/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders;

import com.dataiku.dip.analysis.docgen.helpers.UrlUtil;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.resolver.GenericPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectLinkPlaceholder
implements GenericPlaceholder.RootTextPlaceholder<FlowDocumentContext> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.document.generation");

    public ProjectLinkPlaceholder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public PlaceholderOutput.Text resolve(FlowDocumentContext context, Void resolvedVariable) throws PlaceholderExpectedException {
        PlaceholderOutput.Text text;
        block10: {
            Transaction ignored = this.transactionService.beginRead();
            try {
                String rootUrl = UrlUtil.getDSSExternalRootUrl(this.generalSettingsDAO.read());
                if (rootUrl == null) {
                    logger.warn((Object)"DSS External Url is not defined, using local url instead.");
                    rootUrl = UrlUtil.getDSSLocalhostRootUrl();
                }
                if (rootUrl.endsWith("/")) {
                    rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
                }
                text = new PlaceholderOutput.Text(new HrefContext(rootUrl).project(context.projectKey));
                if (ignored == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw PlaceholderExpectedException.createWithLog("Unable to retrieve external root url", e);
                }
            }
            ignored.close();
        }
        return text;
    }
}

