/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.computations.univariate;

import com.dataiku.dip.eda.compute.computations.AvailableResult;

public abstract class PairwiseTestResult
extends AvailableResult {
    public double[] pvalues;
    public double[] adjustedPvalues;
    public double[] statistics;

    @Override
    public int getEstimatedMemoryUsageBytes() {
        int nDoubles = this.pvalues.length + this.adjustedPvalues.length + this.statistics.length;
        return 32 + 8 * nDoubles;
    }

    public int getNumberOfPairs() {
        if (this.pvalues.length != this.statistics.length) {
            throw new IllegalArgumentException(String.format("Expected as many p-values as statistics, got %d p-values and %d statistics", this.pvalues.length, this.statistics.length));
        }
        if (this.pvalues.length != this.adjustedPvalues.length) {
            throw new IllegalArgumentException(String.format("Expected as many p-values as adjusted p-values, got %d p-values and %d adjusted p-values", this.pvalues.length, this.adjustedPvalues.length));
        }
        return this.pvalues.length;
    }
}

