/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.common;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class SummaryStats {
    List<ComputableStat> computableStats = new ArrayList<ComputableStat>();

    public void addStat(ComputableStat stat) {
        this.computableStats.add(stat);
    }

    public MultiComputation getComputationPlan() {
        ArrayList<Computation> computations = new ArrayList<Computation>();
        for (ComputableStat stat : this.computableStats) {
            computations.add((Computation)((Object)stat.getComputationPlan()));
        }
        return new MultiComputation(computations);
    }

    public List<ComputedStat> getComputedStats(MultiComputation.MultiComputationResult result) {
        ArrayList<ComputedStat> computedStats = new ArrayList<ComputedStat>();
        for (int i = 0; i < this.computableStats.size(); ++i) {
            ComputationResult computationResult = result.get(i);
            ComputableStat computableStat = this.computableStats.get(i);
            ComputedStat computedStat = computationResult.isFullyAvailable() ? computableStat.buildFromFullyAvailableResult(computationResult.asAvailable()) : (computationResult.isAtLeastPartiallyFailed() ? computableStat.failedResult(computationResult.getFirstFailedResult().message) : computableStat.notComputedResult());
            computedStats.add(computedStat);
        }
        return computedStats;
    }

    public List<ComputedStat> getNotComputedStats() {
        ArrayList<ComputedStat> computedStats = new ArrayList<ComputedStat>();
        for (ComputableStat computableStat : this.computableStats) {
            ComputedStat computedStat = computableStat.notComputedResult();
            computedStats.add(computedStat);
        }
        return computedStats;
    }

    public static abstract class ComputableStat<CompParams extends Computation, CompResult extends AvailableResult> {
        public final String flagName;
        public final String shortLabel;
        public final String fullLabel;

        public abstract CompParams getComputationPlan();

        public abstract ComputedStat buildFromFullyAvailableResult(CompResult var1);

        public ComputableStat(String flagName, String shortLabel) {
            this(flagName, shortLabel, shortLabel);
        }

        public ComputableStat(String flagName, String shortLabel, String fullLabel) {
            this.flagName = flagName;
            this.shortLabel = shortLabel;
            this.fullLabel = fullLabel;
        }

        public ComputedStat resultWithFilters(Filter[] values) {
            ComputedStat stat = this.newComputedStat(ComputedStatType.FILTERS);
            stat.filterValues = values;
            return stat;
        }

        private ComputedStat newComputedStat(ComputedStatType type) {
            ComputedStat stat = new ComputedStat();
            stat.fullLabel = this.fullLabel;
            stat.shortLabel = this.shortLabel;
            stat.flagName = this.flagName;
            stat.statType = this.getStatType();
            stat.type = type;
            stat.supportsConfidenceInterval = this.supportsConfidenceInterval();
            return stat;
        }

        public ComputedStat failedResult(String failureMessage) {
            ComputedStat stat = this.newComputedStat(ComputedStatType.FAILURE);
            stat.failureMessage = failureMessage;
            return stat;
        }

        public ComputedStat notComputedResult() {
            ComputedStat stat = this.newComputedStat(ComputedStatType.NOT_COMPUTED);
            return stat;
        }

        public ComputedStat intResult(long value) {
            ComputedStat stat = this.newComputedStat(ComputedStatType.INT);
            stat.intValue = value;
            return stat;
        }

        public ComputedStat floatResult(double value) {
            ComputedStat stat = this.newComputedStat(ComputedStatType.FLOAT);
            stat.floatValue = value;
            return stat;
        }

        public ComputedStat floatResultWithPValue(double value, Double pvalue) {
            ComputedStat stat = this.newComputedStat(ComputedStatType.FLOAT);
            stat.floatValue = value;
            stat.pvalue = pvalue;
            return stat;
        }

        public ComputedStat floatResultWithInterval(double value, Double lower, Double upper) {
            ComputedStat stat = this.newComputedStat(ComputedStatType.FLOAT);
            stat.floatValue = value;
            stat.lower = lower;
            stat.upper = upper;
            return stat;
        }

        public boolean supportsConfidenceInterval() {
            return false;
        }

        public String getStatType() {
            return this.shortLabel.toUpperCase();
        }
    }

    @UIModel
    public static class ComputedStat
    extends ImmutableValueObject {
        public String shortLabel;
        public String fullLabel;
        public ComputedStatType type;
        public String flagName;
        public String statType;
        @Nullable
        public Double floatValue;
        @Nullable
        public Long intValue;
        @Nullable
        public Filter[] filterValues;
        @Nullable
        public String failureMessage;
        @Nullable
        public String warning;
        public boolean supportsConfidenceInterval;
        @Nullable
        public Double upper;
        @Nullable
        public Double lower;
        @Nullable
        public Double pvalue;
    }

    public static enum ComputedStatType {
        FILTERS,
        FLOAT,
        INT,
        FAILURE,
        NOT_COMPUTED;

    }
}

