/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eventserver;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.eventserver.Event;
import com.dataiku.dip.eventserver.dssmodel.EventServerSettings;
import com.dataiku.dip.eventserver.targets.ConnectionPathEventTargetProcessor;
import com.dataiku.dip.filters.RoutingKeyFiltering;
import com.dataiku.dip.filters.TopicsFiltering;
import com.dataiku.dip.processors.AbstractProcessor;
import com.dataiku.dip.processors.ConnectionPathTargetProcessorSettings;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessingQueue {
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private volatile boolean shutdown;
    private EventServerSettings settings;
    private List<QueueHandler> handlers = new ArrayList<QueueHandler>();
    private List<Thread> threads = new ArrayList<Thread>();
    private static final Logger logger = Logger.getLogger((String)"dku.eventserver.queue");

    @PostConstruct
    public void init() throws Exception {
        logger.info((Object)"Starting Processing queue");
        GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsDAO.getUnsafeAutoTXN();
        this.configure(gs.eventServerSettings);
    }

    public synchronized void shutdown() {
        logger.info((Object)("Stopping " + this.threads.size() + " existing threads"));
        this.shutdown = true;
        for (Thread t : this.threads) {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info((Object)"Shutdown complete");
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void configure(EventServerSettings newSettings) throws Exception {
        logger.info((Object)"Reconfiguring server");
        logger.info((Object)("Stopping " + this.threads.size() + " existing threads"));
        this.shutdown = true;
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info((Object)"Previous configuration unloaded");
        this.shutdown = false;
        this.threads.clear();
        this.handlers.clear();
        logger.info((Object)"Loading new settings");
        this.settings = (EventServerSettings)JSON.deepCopy((Object)newSettings);
        NodesDirectory directory = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectory_AutoTXN();
        if (directory.enabled && directory.getCurrentNode().configureEventServer) {
            logger.info((Object)"Autoconfiguring authentication from nodes directory");
            directory.nodes.stream().map(nr -> new EventServerSettings.EventServerAuthKey(nr.eventServerAuthKey)).forEach(this.settings.eventsAuthenticationKeys::add);
            this.settings.requireAuthenticationForEvents = true;
        }
        for (EventServerSettings.EventServerAuthKey authKey : this.settings.eventsAuthenticationKeys) {
            authKey.key = this.symetricCryptoService.decryptIfEncrypted(authKey.key);
        }
        for (EventServerSettings.EventServerAuthKey authKey : this.settings.statsAuthenticationKeys) {
            authKey.key = this.symetricCryptoService.decryptIfEncrypted(authKey.key);
        }
        boolean bl = false;
        for (ConnectionPathTargetProcessorSettings connectionPathTargetProcessorSettings : this.settings.targets) {
            void var3_7;
            ++var3_7;
            ConnectionPathEventTargetProcessor processor = null;
            switch (connectionPathTargetProcessorSettings.type) {
                case FILE_LIKE_CONNECTION_PATH: {
                    ConnectionPathEventTargetProcessor cpt = new ConnectionPathEventTargetProcessor(connectionPathTargetProcessorSettings);
                    cpt.init();
                    processor = cpt;
                    break;
                }
                default: {
                    throw new Error("unhandled");
                }
            }
            logger.info((Object)("Initialized " + String.valueOf(processor)));
            QueueHandler queueHandler = new QueueHandler();
            queueHandler.name = "target-" + processor.getClass().getSimpleName() + "-" + (int)var3_7;
            queueHandler.inQueue = new LinkedBlockingQueue(this.settings.queueSize);
            queueHandler.processor = processor;
            queueHandler.targetSettings = connectionPathTargetProcessorSettings;
            this.handlers.add(queueHandler);
        }
        for (Runnable runnable : this.handlers) {
            Thread thread = new Thread(runnable);
            this.threads.add(thread);
            thread.start();
        }
        logger.info((Object)"All handlers have started");
    }

    public synchronized EventServerSettings getSettings() {
        return this.settings;
    }

    public synchronized void push(Event req) {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.eventserver.events.enqueue");){
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("enqueue on " + this.handlers.size() + " handlers"));
            }
            for (QueueHandler handler : this.handlers) {
                try {
                    boolean success;
                    if (handler.targetSettings.topicsFiltering != TopicsFiltering.ALL && !handler.targetSettings.topics.contains(req.topic) || handler.targetSettings.routingKeysFiltering != RoutingKeyFiltering.ALL && !handler.targetSettings.routingKeys.contains(req.routingKey)) continue;
                    if (StringUtils.isNotBlank((String)handler.targetSettings.requiredAuthKey) && !handler.targetSettings.requiredAuthKey.equals(req.usedAuthKey)) {
                        logger.warn((Object)("Handler " + handler.name + " rejected event with bad authentication key"));
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Event matched for handler " + handler.name));
                    }
                    if (success = handler.inQueue.offer(req, 5L, TimeUnit.MILLISECONDS)) {
                        DSSMetrics.registry().meter("dku.eventserver.handlers." + handler.name + ".queued").mark();
                        continue;
                    }
                    DSSMetrics.registry().meter("dku.eventserver.handlers." + handler.name + ".lostInQueue").mark();
                }
                catch (Exception e) {
                    DSSMetrics.registry().meter("dku.eventserver.handlers." + handler.name + ".lostInQueue").mark();
                }
            }
        }
    }

    public class QueueHandler
    implements Runnable {
        String name;
        AbstractProcessor<Event> processor;
        ConnectionPathTargetProcessorSettings targetSettings;
        LinkedBlockingQueue<Event> inQueue;

        @Override
        public void run() {
            Thread.currentThread().setName("QueueHandler-" + this.name);
            logger.info((Object)("Processing queue starting up for " + this.name));
            while (!ProcessingQueue.this.shutdown) {
                Event req = null;
                try {
                    req = this.inQueue.poll(2000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (req == null) continue;
                try {
                    DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)("dku.eventserver.queuehandler." + this.name + ".process"));
                    try {
                        this.processor.process(req);
                    }
                    finally {
                        if (tctx == null) continue;
                        tctx.close();
                    }
                }
                catch (Exception e) {
                    DSSMetrics.registry().meter("dku.eventserver.queuehandler." + this.name + ".processFailed");
                    logger.warn((Object)"Processing error", (Throwable)e);
                }
            }
            logger.info((Object)("Processing queue thread for " + this.name + " shutting down"));
            try {
                this.processor.shutdown();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to shutdown processing queue", (Throwable)e);
            }
        }
    }
}

