/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.RowConverter;
import java.io.IOException;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;

public class DSSParquetInputFormat
extends ParquetInputFormat<Row> {
    private static Logger logger = Logger.getLogger(DSSParquetInputFormat.class);
    private final ColumnFactory columnFactory;
    private final RowFactory rowFactory;
    private final boolean representsNullFields;
    private final ParquetFormatConfig.Flavor datasetDefaultFlavor;
    private Schema detectedSchema;
    private Schema currentSchema;
    private ParquetFormatConfig.ReadTemporalMode readTemporalMode;

    public DSSParquetInputFormat(ColumnFactory cf, RowFactory rf, boolean representsNullFields, ParquetFormatConfig.Flavor datasetDefaultFlavor, Schema currentSchema, ParquetFormatConfig.ReadTemporalMode readTemporalMode) {
        super(RowConverter.class);
        this.currentSchema = currentSchema;
        this.columnFactory = cf;
        this.representsNullFields = representsNullFields;
        this.rowFactory = rf;
        this.datasetDefaultFlavor = datasetDefaultFlavor;
        this.readTemporalMode = readTemporalMode;
    }

    public RecordReader<Void, Row> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        RowConverter readSupport = new RowConverter(this, this.columnFactory, this.rowFactory, this.representsNullFields, this.datasetDefaultFlavor);
        return new ParquetRecordReader((ReadSupport)readSupport);
    }

    public Schema getDetectedSchema() {
        return this.detectedSchema;
    }

    public Schema getCurrentSchema() {
        return this.currentSchema;
    }

    void setDetectedSchema(Schema detectedSchema) {
        this.detectedSchema = detectedSchema;
    }

    public ParquetFormatConfig.ReadTemporalMode getReadTemporalMode() {
        return this.readTemporalMode;
    }
}

