/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.ArrayList;
import java.util.List;

@PolyJSON(value={@Mapping(value=ObjectDetectionVerifiedLabel.class, type="OBJECT_DETECTION"), @Mapping(value=ClassificationVerifiedLabel.class, type="CLASSIFICATION"), @Mapping(value=NamedEntityExtractionVerifiedLabel.class, type="NAMED_ENTITY_EXTRACTION"), @Mapping(value=FreeTextVerifiedLabel.class, type="FREETEXT")})
public abstract class VerifiedLabel {

    public static class FreeTextVerifiedLabel
    extends VerifiedLabel {
        public static final String TYPE = "FREETEXT";
        public List<String> verifiedTexts = new ArrayList<String>();

        public FreeTextVerifiedLabel() {
        }

        public FreeTextVerifiedLabel(List<String> verifiedTexts) {
            this.verifiedTexts.addAll(verifiedTexts);
        }
    }

    public static class NamedEntityExtractionVerifiedLabel
    extends VerifiedLabel {
        public static final String TYPE = "NAMED_ENTITY_EXTRACTION";
        public List<AnnotationPair> entityPairs = new ArrayList<AnnotationPair>();

        public NamedEntityExtractionVerifiedLabel() {
        }

        public NamedEntityExtractionVerifiedLabel(List<AnnotationPair> entityPairs) {
            this.entityPairs = entityPairs;
        }
    }

    public static class ClassificationVerifiedLabel
    extends VerifiedLabel {
        public static final String TYPE = "CLASSIFICATION";
        public List<String> verifiedCategories = new ArrayList<String>();

        public ClassificationVerifiedLabel() {
        }

        public ClassificationVerifiedLabel(List<String> verifiedCategories) {
            this.verifiedCategories.addAll(verifiedCategories);
        }
    }

    public static class ObjectDetectionVerifiedLabel
    extends VerifiedLabel {
        public static final String TYPE = "OBJECT_DETECTION";
        public List<BoundingBoxPair> boundingBoxPairs = new ArrayList<BoundingBoxPair>();

        public ObjectDetectionVerifiedLabel() {
        }

        public ObjectDetectionVerifiedLabel(List<BoundingBoxPair> boundingBoxPairs) {
            this.boundingBoxPairs = boundingBoxPairs;
        }

        public static class BoundingBoxPair
        extends AnnotationPair {
            public double iou;

            public BoundingBoxPair(double iou, String verifiedCategory, Integer annotationIdx) {
                super(verifiedCategory, annotationIdx);
                this.iou = iou;
            }
        }
    }

    public static class AnnotationPair {
        public String verifiedCategory;
        public Integer annotationIdx;

        public AnnotationPair(String verifiedCategory, Integer annotationIdx) {
            this.verifiedCategory = verifiedCategory;
            this.annotationIdx = annotationIdx;
        }
    }
}

