/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.managedfolder;

import com.dataiku.dip.coremodel.Checklists;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFolderSelection;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;

public class ManagedFolder
extends TaggableObjectsService.TaggableObject
implements Partitionable {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public String name;
    public String contentType;
    public String type;
    public AbstractFSDatasetHandler.AbstractFSConfig params;
    public PartitioningScheme partitioning;
    public ManagedFolderSelection selection;
    public SerializedDataset.FlowOptions flowOptions = new SerializedDataset.FlowOptions();
    public ProbesSet metrics = new ProbesSet();
    public ChecksSet checks = new ChecksSet();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.managedfolders");

    public ManagedFolder() {
    }

    public ManagedFolder(String projectKey, String id) {
        this.projectKey = projectKey;
        this.id = id;
    }

    public ManagedFolder(ManagedFolder other) {
        Preconditions.checkNotNull((Object)other, (Object)"Can't copy null folder");
        this.projectKey = other.projectKey;
        this.id = other.id;
        this.description = other.description;
        this.name = other.name;
        this.contentType = other.contentType;
        this.type = other.type;
        this.params = other.params;
        this.shortDesc = other.shortDesc;
        this.checklists = other.checklists;
        this.creationTag = other.creationTag;
        this.versionTag = other.versionTag;
        this.flowOptions = other.flowOptions;
        this.tags = other.tags;
        this.metrics = other.metrics;
        this.checks = other.checks;
        this.partitioning = other.partitioning;
        this.selection = other.selection;
        this.customFields = other.customFields;
    }

    public String getType() {
        return this.type;
    }

    public AbstractFSDatasetHandler.AbstractFSConfig getParams() {
        return this.params;
    }

    public void setParams(AbstractFSDatasetHandler.AbstractFSConfig params) {
        this.params = params;
    }

    public <T extends DatasetHandler.DatasetParams> T getParamsAs(Class<T> clazz) {
        return (T)((DatasetHandler.DatasetParams)clazz.cast(this.getParams()));
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.MANAGED_FOLDER;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public SerializedDataset.FlowOptions getFlowOptions() {
        return this.flowOptions;
    }

    @Override
    public PartitioningScheme getPartitioningSchema() {
        return this.partitioning == null ? new PartitioningScheme() : this.partitioning;
    }

    public boolean isPartitioned() {
        return this.partitioning != null && this.partitioning.getDimensionNames().size() > 0;
    }

    @Override
    public String getFullName() {
        return this.getFullId();
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public PartitionableHandler buildHandler(AuthCtx authCtx) {
        return new ManagedFolderHandler(authCtx, this);
    }

    public AnyLoc getLoc() {
        return AnyLoc.resolveFull(this.getFullName());
    }

    public String getSmartName(String contextProjectKey) {
        return this.getLoc().getSmartName(contextProjectKey);
    }

    public static void registerJsonAdapter() {
        JSON.registerAdapter(ManagedFolder.class, (Object)new JsonDeserializer<ManagedFolder>(){

            public ManagedFolder deserialize(JsonElement elt, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                String dtype;
                JsonObject json = elt.getAsJsonObject();
                ManagedFolder folder = new ManagedFolder();
                if (json.has("projectKey")) {
                    folder.projectKey = json.get("projectKey").getAsString();
                }
                if (json.has("id")) {
                    folder.id = json.get("id").getAsString();
                }
                if (json.has("checklists")) {
                    folder.checklists = (Checklists)ctx.deserialize(json.get("checklists"), Checklists.class);
                }
                if (json.has("creationTag")) {
                    folder.creationTag = (VersionTag)ctx.deserialize(json.get("creationTag"), VersionTag.class);
                }
                if (json.has("versionTag")) {
                    folder.versionTag = (VersionTag)ctx.deserialize(json.get("versionTag"), VersionTag.class);
                }
                if (json.has("description")) {
                    folder.description = json.get("description").getAsString();
                }
                if (json.has("shortDesc")) {
                    folder.shortDesc = json.get("shortDesc").getAsString();
                }
                if (json.has("tags")) {
                    folder.tags = (List)ctx.deserialize(json.get("tags"), List.class);
                }
                if (json.has("name")) {
                    folder.name = json.get("name").getAsString();
                }
                if (json.has("contentType")) {
                    folder.contentType = json.get("contentType").getAsString();
                }
                if (json.has("partitioning")) {
                    folder.partitioning = (PartitioningScheme)ctx.deserialize(json.get("partitioning"), PartitioningScheme.class);
                }
                if (json.has("selection")) {
                    folder.selection = (ManagedFolderSelection)ctx.deserialize(json.get("selection"), ManagedFolderSelection.class);
                }
                if (json.has("flowOptions")) {
                    folder.flowOptions = (SerializedDataset.FlowOptions)ctx.deserialize(json.get("flowOptions"), SerializedDataset.FlowOptions.class);
                }
                if (json.has("checks")) {
                    folder.checks = (ChecksSet)ctx.deserialize(json.get("checks"), ChecksSet.class);
                }
                if (json.has("metrics")) {
                    folder.metrics = (ProbesSet)ctx.deserialize(json.get("metrics"), ProbesSet.class);
                }
                folder.type = dtype = json.get("type").getAsString();
                try {
                    Class<? extends DatasetHandler.DatasetParams> paramsClass = DatasetHandlerFactory.getParamsClass(dtype);
                    if (json.has("params")) {
                        folder.params = (AbstractFSDatasetHandler.AbstractFSConfig)ctx.deserialize(json.get("params"), paramsClass);
                    }
                }
                catch (Error e) {
                    logger.error((Object)("Error instantiating dataset handler for type " + dtype), (Throwable)e);
                }
                if (json.has("customFields")) {
                    folder.customFields = json.getAsJsonObject("customFields");
                }
                return folder;
            }
        });
    }
}

