/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.output.RowNumberAwareOutputWriter;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;

public class InlineDataOutputWriter
extends RowNumberAwareOutputWriter {
    private InlineData inlineData;
    private ArrayList<Column> columns;
    private RelFile rFile;
    private RowNumberAwareOutputWriter fwdOutputWriter;
    static DKULogger logger = DKULogger.getLogger((String)"dku.output.inline");

    public InlineDataOutputWriter(RelFile rFile, Schema schema, RowNumberAwareOutputWriter fwdOutputWriter) {
        if (rFile == null) {
            logger.warn((Object)"Will drop new inline data changes");
        } else {
            this.rFile = rFile;
            this.fwdOutputWriter = fwdOutputWriter;
            this.inlineData = new InlineData();
            this.inlineData.schema = schema;
        }
    }

    public void init(ColumnFactory cf) throws Exception {
        if (this.inlineData == null) {
            return;
        }
        this.columns = new ArrayList(this.inlineData.schema.columns.size());
        ArrayList<String> header = new ArrayList<String>(this.columns.size());
        for (SchemaColumn col : this.inlineData.schema.columns) {
            this.columns.add(cf.column(col.getName()));
            header.add(col.getName());
        }
        if (this.fwdOutputWriter != null) {
            this.fwdOutputWriter.init(cf);
        }
    }

    public void emitRow(Row row, int origIndex) throws Exception {
        if (this.inlineData == null) {
            return;
        }
        ArrayList<String> line = new ArrayList<String>(this.columns.size());
        for (Column col : this.columns) {
            line.add(row.get(col));
        }
        this.inlineData.data.add(line);
        if (this.fwdOutputWriter != null) {
            this.fwdOutputWriter.emitRow(row, origIndex);
        }
    }

    public void emitRow(Row row) throws Exception {
        this.emitRow(row, -1);
    }

    public void lastRowEmitted() throws Exception {
        if (this.inlineData == null) {
            return;
        }
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(this.rFile, (Object)this.inlineData);
        if (this.fwdOutputWriter != null) {
            this.fwdOutputWriter.lastRowEmitted();
        }
    }

    public void cancel() throws Exception {
        if (this.inlineData == null) {
            return;
        }
        if (this.fwdOutputWriter != null) {
            this.fwdOutputWriter.cancel();
        }
    }

    public long writtenBytes() throws IOException {
        return -1L;
    }

    public void setMaxMemoryUsed(long size) {
    }

    public static class InlineData {
        public ArrayList<ArrayList<String>> data = new ArrayList();
        public Schema schema;
    }
}

