/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.utils.GraphUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.security.AuthCtx;

public class FromFSActivitySingleThreadPusher {
    private AuthCtx authCtx;
    private DatasetsDAO dao;
    private RecipeRunnableSubgraph subgraph;

    public FromFSActivitySingleThreadPusher(AuthCtx authCtx, DatasetsDAO dao, RecipeRunnableSubgraph subgraph) {
        this.authCtx = authCtx;
        this.dao = dao;
        this.subgraph = subgraph;
    }

    public void push(ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
        FlowDataset fds = GraphUtils.getSingleSource(this.subgraph.getRecipe());
        Dataset dataset = fds.getMandatory(this.dao);
        DatasetHandler handler = DatasetHandlerFactory.build(this.authCtx, dataset);
        if (handler instanceof AbstractFSDatasetHandler) {
            try (AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)handler;){
                InputFilter filter = new InputFilter().withSelectedPartitions(this.subgraph.getSourcePartitions(fds));
                FilePartitioner.ResolvedFilesFilterResult result = fsdh.getRequiredFiles(filter);
                for (FilePartition partition : result.matchingFilePartitions) {
                    FormatExtractor formatExtractor = FormatFactory.buildExtractor(dataset.getFormatType(), dataset.getFormatParams(), this.authCtx, dataset.getProjectKey());
                    formatExtractor.setSchema(dataset.getSchema(), false);
                    StreamsInputSplit split = fsdh.getSplitForPartition(partition);
                    formatExtractor.run(split, out, cf, rf);
                }
            }
        } else {
            handler.close();
            UniversalSingleThreadPusher.push(this.authCtx, dataset, out, cf, rf);
        }
    }
}

