/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.PivotTableUtils;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;

public class AnumAxisHandler
implements AxisHandler {
    List<String> list = new ArrayList<String>();
    Map<String, Integer> map = new HashMap<String, Integer>();
    private LinoMetaFile.ColumnHeader col;

    public AnumAxisHandler(LinoMetaFile.ColumnHeader col) {
        this.col = col;
        this.map.put("___dku_no_value___", 0);
        this.list.add("___dku_no_value___");
    }

    @Override
    public void observe(Row row) {
        throw new UnsupportedOperationException("Axis handler on rows directly");
    }

    private String getValueForDouble(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            return "___dku_no_value___";
        }
        if (this.col != null && this.col.realType != null && this.col.realType.isTemporal()) {
            return PivotTableUtils.formatTemporal(x, this.col.realType);
        }
        return PivotTableUtils.formatDouble(x);
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        BinsAndTensorsSafetyChecks.failIfTooManyBinsOnSingleAxis(null, this.map.size());
        switch (block.getMemoryType()) {
            case DOUBLE: {
                for (int i = 0; i < block.doubles.length; ++i) {
                    String v;
                    Integer bin;
                    if (filters != null && !filters[i] || (bin = this.map.get(v = this.getValueForDouble(block.doubles[i]))) != null) continue;
                    bin = this.map.size();
                    this.map.put(v, bin);
                    this.list.add(v);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < block.nbRecords(); ++i) {
                    Integer bin;
                    String v;
                    if (filters != null && !filters[i] || (v = block.getAsStringSlow(i)) == null || v.isEmpty() || (bin = this.map.get(v)) != null) continue;
                    bin = this.map.size();
                    this.map.put(v, bin);
                    this.list.add(v);
                }
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
    }

    @Override
    public int getNbBins() {
        return this.map.size();
    }

    @Override
    public void getBins(ColumnBlock block, int[] ret, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            String v = switch (block.getMemoryType()) {
                case ColumnBlock.MemoryType.DOUBLE -> this.getValueForDouble(block.doubles[i]);
                case ColumnBlock.MemoryType.STRING -> block.getAsStringSlow(i);
                default -> throw new NotImplementedException();
            };
            if (filters != null && !filters[i]) {
                ret[i] = 0;
                continue;
            }
            if (v == null || v.isEmpty()) continue;
            Integer bin = this.map.get(v);
            if (bin == null) {
                throw new Error("Bin not found for value -->" + v + "<--");
            }
            ret[i] = bin;
        }
    }

    @Override
    public List<AxisElt> getAxisElts() {
        ArrayList<AxisElt> ret = new ArrayList<AxisElt>();
        for (String label : this.list) {
            AxisElt elt = new AxisElt();
            elt.label = label;
            ret.add(elt);
        }
        return ret;
    }
}

