/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.color.DiscretePalette;
import com.dataiku.dip.pivot.frontend.color.PaletteFactory;
import com.dataiku.dip.pivot.frontend.excel.StdAggrDataSheet1DBuilder;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartSources;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartTextSource;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.axes.AxisFactory;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BarChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.LineChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.Series1D;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.SeriesFactory;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.ChartType;
import com.dataiku.dip.pivot.frontend.model.DisplayAxis;
import com.dataiku.dip.pivot.frontend.model.DisplayType;
import com.dataiku.dip.pivot.frontend.model.MeasureDef;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisPosition;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.LegendPosition;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.io.IOException;
import java.util.ArrayList;

public class BarLine1DExporter {
    public static XSSFWorkbook export(ChartDef chartDef, PivotTableTensorResponse response, int animationFrameIdx) throws IOException {
        int i;
        chartDef = (ChartDef)JSON.deepCopy((Object)chartDef);
        if (chartDef.type == ChartType.lines) {
            for (MeasureDef def : chartDef.genericMeasures) {
                def.displayType = DisplayType.line;
            }
        }
        DiscretePalette palette = PaletteFactory.buildIndexedPalette(chartDef.colorOptions.colorPalette);
        SeriesFactory seriesFactory = new SeriesFactory();
        XSSFWorkbook workbook = new XSSFWorkbook();
        StdAggrDataSheet1DBuilder.DataSheet1DRef dataSheetRef = StdAggrDataSheet1DBuilder.buildSheet(workbook, chartDef, response, animationFrameIdx);
        int columnChartCurrentColor = 0;
        XSSFSheet chartSheet = workbook.createSheet("Chart");
        XSSFChart poiChart = ChartUtils.createChart(chartSheet);
        ChartUtils.setChartTitle(poiChart, dataSheetRef.getTitleSource());
        AxisFactory axisFactory = new AxisFactory(poiChart);
        BarChart dssBarChartWithRightAxis = null;
        BarChart dssBarChartWithLeftAxis = null;
        LineChart dssLineChartWithRightAxis = null;
        LineChart dssLineChartWithLeftAxis = null;
        ArrayList<Boolean> ignoreLegendEntryBarLeft = new ArrayList<Boolean>();
        ArrayList<Boolean> ignoreLegendEntryBarRight = new ArrayList<Boolean>();
        XDDFValueAxis leftAxis = null;
        XDDFValueAxis rightAxis = null;
        XDDFCategoryAxis leftBottomAxis = null;
        XDDFCategoryAxis rightBottomAxis = null;
        for (MeasureDef measureDef : chartDef.genericMeasures) {
            if (!measureDef.displayed || measureDef.displayAxis != DisplayAxis.axis1 || leftAxis != null) continue;
            leftAxis = axisFactory.buildValueAxis(AxisPosition.LEFT);
            leftAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
            if (chartDef.xAxisFormatting.isLogScale) {
                leftAxis.setLogBase(10.0);
            }
            if (leftBottomAxis == null) {
                leftBottomAxis = axisFactory.buildCategoryAxis(AxisPosition.BOTTOM);
                leftBottomAxis.setVisible(true);
            }
            ChartUtils.crossAxes(leftBottomAxis, (XDDFChartAxis)leftAxis);
            break;
        }
        for (MeasureDef measureDef : chartDef.genericMeasures) {
            if (measureDef.displayAxis != DisplayAxis.axis2 || rightAxis != null) continue;
            rightAxis = axisFactory.buildValueAxis(AxisPosition.RIGHT);
            rightAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
            if (chartDef.xAxisFormatting.isLogScale) {
                rightAxis.setLogBase(10.0);
            }
            if (rightBottomAxis == null) {
                rightBottomAxis = axisFactory.buildCategoryAxis(AxisPosition.BOTTOM);
                rightBottomAxis.setVisible(false);
            }
            ChartUtils.crossAxes(rightBottomAxis, (XDDFChartAxis)rightAxis);
            rightAxis.setCrosses(AxisCrosses.MAX);
            break;
        }
        for (MeasureDef measureDef : chartDef.genericMeasures) {
            if (!measureDef.displayed) continue;
            if (measureDef.displayAxis == DisplayAxis.axis1) {
                if (measureDef.displayType == DisplayType.column) {
                    dssBarChartWithLeftAxis = new BarChart();
                } else if (measureDef.displayType == DisplayType.line) {
                    dssLineChartWithLeftAxis = new LineChart();
                }
            }
            if (measureDef.displayAxis != DisplayAxis.axis2) continue;
            if (measureDef.displayType == DisplayType.column) {
                dssBarChartWithRightAxis = new BarChart();
                continue;
            }
            if (measureDef.displayType != DisplayType.line) continue;
            dssLineChartWithRightAxis = new LineChart();
        }
        XDDFNumericalDataSource emptyNumericalSource = XDDFDataSourcesFactory.fromArray((Number[])new Double[]{0.0});
        XDDFCategoryDataSource emptyCategoricalSource = XDDFDataSourcesFactory.fromArray((String[])new String[]{""});
        ChartTextSource emptyTitle = ChartSources.fromString("Empty");
        seriesFactory.initIndex(ChartUtils.drawReferenceLines(response, dataSheetRef.getSheet(), (XDDFChart)poiChart, chartDef));
        ChartUtils.drawGridLines((XDDFChart)poiChart, chartDef);
        if (rightBottomAxis != null && leftBottomAxis == null) {
            rightBottomAxis.setVisible(true);
        }
        for (int mIdx = 0; mIdx < chartDef.genericMeasures.size(); ++mIdx) {
            Series1D fakeSerie;
            Series1D series;
            MeasureDef def = chartDef.genericMeasures.get(mIdx);
            if (!def.displayed) continue;
            ChartTextSource title = dataSheetRef.getAggregationTitleSource(mIdx);
            XDDFDataSource<String> axisValues = dataSheetRef.getAxisSource();
            XDDFNumericalDataSource<Double> aggregationValues = dataSheetRef.getAggregationSource(mIdx);
            if (def.displayAxis == DisplayAxis.axis1) {
                if (def.displayType == DisplayType.column) {
                    assert (dssBarChartWithLeftAxis != null);
                    series = seriesFactory.build1D(title, aggregationValues, axisValues);
                    series.setColor(palette.apply(columnChartCurrentColor++));
                    series.setSmoothed(chartDef.smoothing);
                    dssBarChartWithLeftAxis.addSeries(series);
                    ignoreLegendEntryBarLeft.add(false);
                    if (dssBarChartWithRightAxis != null) {
                        fakeSerie = seriesFactory.build1D(emptyTitle, (XDDFNumericalDataSource<Double>)emptyNumericalSource, (XDDFDataSource<String>)emptyCategoricalSource);
                        dssBarChartWithRightAxis.addSeries(fakeSerie);
                        ignoreLegendEntryBarRight.add(true);
                    }
                }
                if (def.displayType == DisplayType.line) {
                    assert (dssLineChartWithLeftAxis != null);
                    series = seriesFactory.build1D(title, aggregationValues, axisValues);
                    series.setSmoothed(chartDef.smoothing);
                    series.setColor(palette.apply(mIdx));
                    series.setMarker(mIdx);
                    dssLineChartWithLeftAxis.addSeries(series);
                }
            }
            if (def.displayAxis != DisplayAxis.axis2) continue;
            if (def.displayType == DisplayType.column) {
                assert (dssBarChartWithRightAxis != null);
                series = seriesFactory.build1D(title, aggregationValues, axisValues);
                series.setSmoothed(chartDef.smoothing);
                dssBarChartWithRightAxis.addSeries(series);
                ignoreLegendEntryBarRight.add(false);
                series.setColor(palette.apply(columnChartCurrentColor++));
                if (dssBarChartWithLeftAxis != null) {
                    fakeSerie = seriesFactory.build1D(emptyTitle, (XDDFNumericalDataSource<Double>)emptyNumericalSource, (XDDFDataSource<String>)emptyCategoricalSource);
                    dssBarChartWithLeftAxis.addSeries(fakeSerie);
                    ignoreLegendEntryBarLeft.add(true);
                }
            }
            if (def.displayType != DisplayType.line) continue;
            assert (dssLineChartWithRightAxis != null);
            series = seriesFactory.build1D(title, aggregationValues, axisValues);
            series.setSmoothed(chartDef.smoothing);
            series.setColor(palette.apply(mIdx));
            series.setMarker(mIdx);
            dssLineChartWithRightAxis.addSeries(series);
        }
        if (leftBottomAxis != null && rightBottomAxis != null) {
            rightBottomAxis.setVisible(false);
        }
        XDDFChartLegend legend = poiChart.getOrAddLegend();
        legend.setPosition(LegendPosition.RIGHT);
        ChartUtils.setOverlay(legend, false);
        if (dssBarChartWithLeftAxis != null) {
            dssBarChartWithLeftAxis.plot((XDDFChart)poiChart, new XDDFChartAxis[]{leftBottomAxis, leftAxis});
        }
        for (i = 0; i < ignoreLegendEntryBarLeft.size(); ++i) {
            if (!((Boolean)ignoreLegendEntryBarLeft.get(i)).booleanValue()) continue;
            ChartUtils.dropLegendEntry(legend, i);
        }
        if (dssBarChartWithRightAxis != null) {
            dssBarChartWithRightAxis.plot((XDDFChart)poiChart, new XDDFChartAxis[]{rightBottomAxis, rightAxis});
        }
        for (i = 0; i < ignoreLegendEntryBarRight.size(); ++i) {
            if (!((Boolean)ignoreLegendEntryBarRight.get(i)).booleanValue()) continue;
            ChartUtils.dropLegendEntry(legend, ignoreLegendEntryBarLeft.size() + i);
        }
        if (dssLineChartWithLeftAxis != null) {
            dssLineChartWithLeftAxis.plot((XDDFChart)poiChart, new XDDFChartAxis[]{leftBottomAxis, leftAxis});
        }
        if (dssLineChartWithRightAxis != null) {
            dssLineChartWithRightAxis.plot((XDDFChart)poiChart, new XDDFChartAxis[]{rightBottomAxis, rightAxis});
        }
        workbook.setSheetOrder("Chart", 0);
        chartSheet.setActiveCell(CellAddress.A1);
        workbook.setActiveSheet(0);
        return workbook;
    }
}

