/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.excel.BaseDataSheetBuilder;
import com.dataiku.dip.pivot.frontend.excel.CellStyler;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartSources;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartTextSource;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.SheetUtils;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFCell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StdAggrDataSheet1DBuilder
extends BaseDataSheetBuilder {
    public static DataSheet1DRef buildSheet(XSSFWorkbook workbook, ChartDef chartDef, final PivotTableTensorResponse response, int animationFrameIdx) {
        int[] coords;
        final XSSFSheet sheet = workbook.createSheet("Data");
        CellStyler styler = new CellStyler((Workbook)workbook);
        CellStyle titleStyle = styler.getTitleStyle();
        CellStyle headerStyle = styler.getHeaderStyle();
        SheetUtils.writeCell(sheet, 0, 0, chartDef.name).setCellStyle(titleStyle);
        SheetUtils.writeCell(sheet, 1, 0, com.dataiku.dip.pivot.frontend.ChartUtils.getNiceDimensionName(ChartUtils.getGenericDimension(chartDef))).setCellStyle(headerStyle);
        for (int i = 0; i < chartDef.genericMeasures.size(); ++i) {
            Object measureName = com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(chartDef.genericMeasures.get(i));
            if (i == 0 && chartDef.genericMeasures.get((int)i).computeMode == Aggregation.ComputeMode.AVG_RATIO) {
                measureName = (String)measureName + " (% to average)";
            }
            XSSFCell cell = SheetUtils.writeCell(sheet, 1, 1 + i, (String)measureName);
            cell.setCellStyle(headerStyle);
        }
        if (chartDef.animationDimension.isEmpty()) {
            coords = new int[1];
        } else {
            coords = new int[2];
            coords[1] = animationFrameIdx;
        }
        for (int i = 0; i < response.axisLabels[0].size(); ++i) {
            AxisElt elt = response.axisLabels[0].get(i);
            coords[0] = i;
            String label = ChartUtils.labelify(elt.label);
            CellStyle axisStyle = styler.getValueStyle(i == response.axisLabels[0].size() - 1, true);
            SheetUtils.writeCell(sheet, 2 + i, 0, label).setCellStyle(axisStyle);
            for (int j = 0; j < response.aggregations.size(); ++j) {
                CellStyler.SpecialFormat fmt = CellStyler.SpecialFormat.NONE;
                if (j == 0 && chartDef.genericMeasures.get((int)j).computeMode == Aggregation.ComputeMode.AVG_RATIO) {
                    fmt = CellStyler.SpecialFormat.PERCENTAGE;
                }
                CellStyle style = styler.getValueStyle(i == response.axisLabels[0].size() - 1, false, fmt);
                DataTensor tensor = (DataTensor)response.aggregations.get(j);
                if (tensor.type == TensorType.NUMERICAL) {
                    SheetUtils.writeCell(sheet, 2 + i, j + 1, tensor.getAsDouble(coords)).setCellStyle(style);
                    continue;
                }
                if (tensor.type == TensorType.ALPHANUM) {
                    SheetUtils.writeCell(sheet, 2 + i, j + 1, (String)tensor.get(coords)).setCellStyle(style);
                    continue;
                }
                throw new RuntimeException("Only numerical and alphanumeric values can be written on a sheet.");
            }
        }
        StdAggrDataSheet1DBuilder.appendFilteringDetails(chartDef, sheet);
        SheetUtils.autoFitColumns(sheet);
        return new DataSheet1DRef(){

            @Override
            public XSSFSheet getSheet() {
                return sheet;
            }

            @Override
            public XDDFDataSource<String> getAxisSource() {
                return XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(2, 1 + response.axisLabels[0].size(), 0, 0));
            }

            @Override
            public ChartTextSource getTitleSource() {
                return ChartSources.fromCellRange(sheet, new CellRangeAddress(0, 0, 0, 0));
            }

            @Override
            public ChartTextSource getAggregationTitleSource(int aggregationIdx) {
                if (aggregationIdx < 0 || aggregationIdx > response.aggregations.size()) {
                    throw new RuntimeException("Invalid aggregation idx: " + aggregationIdx);
                }
                return ChartSources.fromCellRange(sheet, new CellRangeAddress(1, 1, 1 + aggregationIdx, 1 + aggregationIdx));
            }

            @Override
            public XDDFNumericalDataSource<Double> getAggregationSource(int aggregationIdx) {
                return XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)this.getAggregationSourceRange(aggregationIdx));
            }

            @Override
            public CellRangeAddress getAggregationSourceRange(int aggregationIdx) {
                if (aggregationIdx < 0 || aggregationIdx > response.aggregations.size()) {
                    throw new RuntimeException("Invalid aggregation idx: " + aggregationIdx);
                }
                return new CellRangeAddress(2, 1 + response.axisLabels[0].size(), 1 + aggregationIdx, 1 + aggregationIdx);
            }
        };
    }

    public static interface DataSheet1DRef {
        public XSSFSheet getSheet();

        public XDDFDataSource<String> getAxisSource();

        public ChartTextSource getTitleSource();

        public ChartTextSource getAggregationTitleSource(int var1);

        public XDDFNumericalDataSource<Double> getAggregationSource(int var1);

        public CellRangeAddress getAggregationSourceRange(int var1);
    }
}

