/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel.xssf.charts;

import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BaseChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.Series2D;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STMarkerStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;

public class ScatterChart
extends BaseChart<Series2D> {
    @Override
    public void plot(XDDFChart chart, XDDFChartAxis ... chartAxes) {
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTScatterChart ctScatterChart = plotArea.addNewScatterChart();
        ctScatterChart.addNewVaryColors().setVal(false);
        for (Series2D series : this.getSeries()) {
            CTScatterSer scatterSer = ctScatterChart.addNewSer();
            scatterSer.addNewIdx().setVal((long)series.getId());
            scatterSer.addNewOrder().setVal((long)series.getId());
            CTShapeProperties spPr = scatterSer.addNewSpPr();
            CTSolidColorFillProperties scfp = spPr.addNewSolidFill();
            CTSRgbColor rgbColor = scfp.addNewSrgbClr();
            rgbColor.setVal(series.getColor().asByteArray());
            CTMarker ctMarker = scatterSer.addNewMarker();
            if (series.getMarker() != STMarkerStyle.NONE) {
                ctMarker.addNewSize().setVal((short)4);
                ctMarker.addNewSymbol().setVal(series.getMarker());
                CTShapeProperties markerSpPr = ctMarker.addNewSpPr();
                markerSpPr.addNewNoFill();
                markerSpPr.addNewLn().addNewSolidFill().addNewSrgbClr().setVal(ChartUtils.computeDarkenColor(series.getColor().asByteArray()));
            } else {
                ctMarker.addNewSymbol().setVal(STMarkerStyle.NONE);
            }
            CTLineProperties ln = spPr.addNewLn();
            CTSolidColorFillProperties solidFill = ln.addNewSolidFill();
            CTSRgbColor fillCol = solidFill.addNewSrgbClr();
            fillCol.setVal(series.getColor().asByteArray());
            ln.addNewRound();
            CTSerTx tx = scatterSer.addNewTx();
            ChartUtils.buildSerTx(tx, series.getTitle());
            CTAxDataSource cats = scatterSer.addNewXVal();
            ChartUtils.buildAxDataSource(cats, series.getXValues());
            CTNumDataSource vals = scatterSer.addNewYVal();
            ChartUtils.buildNumDataSource(vals, series.getYValues());
            scatterSer.addNewSmooth().setVal(series.isSmoothed());
        }
        for (XDDFChartAxis axis : chartAxes) {
            ctScatterChart.addNewAxId().setVal(axis.getId());
        }
    }
}

