/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.git.JGitLogBuilder;
import com.dataiku.dip.git.ProjectAwareDiffBuilder;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.model.BundleChangelog;
import com.dataiku.dip.projects.importexport.model.BundleExporterSettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.projects.ProjectSummaryService;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.GitLocalCommands;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.springframework.beans.factory.annotation.Autowired;

public class BundlePreparator {
    private String projectKey;
    private String previousBundleId;
    private long previousBundleTime;
    private ObjectId prevTree;
    private ObjectId prevCommit;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ProjectSummaryService projectSummaryService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.bundles.prepare");

    public BundlePreparator(String projectKey) {
        this.projectKey = projectKey;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public BundlePreparationResult run() throws Exception {
        BundlePreparationResult ret = new BundlePreparationResult();
        try (Transaction t = this.transactionService.beginRead();){
            ret.exporterSettings = this.projectsService.getMandatory((String)this.projectKey).bundleExporterSettings;
            ret.configContent = this.projectSummaryService.computeConfigContent(this.projectKey);
        }
        if (ret.exporterSettings == null) {
            ret.exporterSettings = new BundleExporterSettings();
        }
        logger.infoV("Starting to prepare for bundling of %s", new Object[]{this.projectKey});
        this.findPreviousBundle();
        logger.infoV("Done iterating repository, previous bundle id %s commit %s ", new Object[]{this.previousBundleId, this.prevCommit});
        if (this.prevCommit == null) {
            JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
            JGitManager.SubGit projectGit = gitManager.getSubGit(this.projectKey);
            Git git = projectGit.git;
            logger.info((Object)("Finding the first commit of the project with prefix: '" + projectGit.pathPrefix + "'"));
            String prefix = StringUtils.isBlank((String)projectGit.pathPrefix) ? "params.json" : projectGit.pathPrefix + "/params.json";
            try {
                LogCommand lc = git.log().add((AnyObjectId)git.getRepository().resolve("HEAD")).addPath(prefix);
                int i = 0;
                for (RevCommit commit : lc.call()) {
                    if (i++ % 100 == 0) {
                        logger.infoV("Processed %d commits", new Object[]{i});
                    }
                    this.prevCommit = commit;
                }
            }
            catch (Exception e) {
                logger.errorV("Git repository history may be corrupted or incomplete. Please run 'git fsck --full' from the project %s folder to diagnose the issue", new Object[]{this.projectKey});
                throw new IOException("Could not read the project Git history. This likely indicates a corrupted Git repository. Please contact your administrator.");
            }
            if (this.prevCommit == null) {
                logger.info((Object)"Did not find first commit for the project!");
            }
            if (this.prevCommit != null) {
                this.prevTree = git.getRepository().resolve(this.prevCommit.getName() + "^{tree}");
            }
        }
        if (this.prevCommit != null) {
            logger.infoV("prevTree=  " + String.valueOf(this.prevTree), new Object[0]);
            ret.changelog = this.prepareChangelog();
        }
        return ret;
    }

    BundleChangelog prepareChangelog() throws IOException, GitAPIException {
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        JGitManager.SubGit projectGit = gitManager.getSubGit(this.projectKey);
        GitLocalCommands localCommands = new GitLocalCommands(projectGit.git);
        assert (this.prevCommit != null);
        assert (this.prevTree != null);
        ObjectId headCommit = projectGit.git.getRepository().resolve("HEAD");
        ObjectId headTree = projectGit.git.getRepository().resolve("HEAD^{tree}");
        logger.debug((Object)("HEAD COMMIT " + String.valueOf(headCommit) + " tree " + String.valueOf(headTree)));
        logger.debug((Object)("PREV COMMIT " + String.valueOf(this.prevCommit) + " tree " + String.valueOf(this.prevTree)));
        BundleChangelog changelog = new BundleChangelog();
        changelog.previousBundleId = this.previousBundleId;
        changelog.previousBundleTime = this.previousBundleTime;
        JGitLogBuilder logBuilder = new JGitLogBuilder(projectGit.git, localCommands.getTagsByCommitId());
        long logLimit = ApplicationConfigurator.getParams().getIntParam("dku.bundle.changelog.log.limit.bytes", Integer.valueOf(0x3200000));
        logger.info((Object)("Getting log entries within " + logLimit + " bytes"));
        GitModel.LimitedDKULogEntryList limitedLog = logBuilder.buildLimited(this.prevCommit, headCommit, logLimit, projectGit.pathPrefix);
        changelog.logEntries = Lists.newArrayList((Iterable)limitedLog);
        changelog.logEntriesCount = limitedLog.getTrueCount();
        long diffLimit = ApplicationConfigurator.getParams().getIntParam("dku.bundle.changelog.diff.limit.bytes", Integer.valueOf(0x3200000));
        logger.info((Object)("Getting diff entries within " + diffLimit + " bytes"));
        ProjectAwareDiffBuilder diffBuilder = new ProjectAwareDiffBuilder(projectGit.git);
        GitModel.LimitedDKUDiffEntryList limitedDiff = diffBuilder.diffProjectLimited(ApplicationConfigurator.getGitMode(), this.projectKey, this.prevTree, headTree, diffLimit);
        changelog.diffEntries = Lists.newArrayList((Iterable)limitedDiff);
        changelog.diffEntriesCount = limitedDiff.getTrueCount();
        return changelog;
    }

    private String getTagBundleId(RevTag rt) {
        String tagName = rt.getTagName();
        logger.debug((Object)("Tag name is " + tagName));
        if (!tagName.startsWith("dss-bundle")) {
            return null;
        }
        Object[] tagChunks = tagName.split("-");
        logger.debug((Object)("CHUNKS " + StringUtils.join((Object[])tagChunks, (String)"!")));
        if (tagChunks.length < 4) {
            return null;
        }
        Object tagProjectKey = tagChunks[2];
        if (!((String)tagProjectKey).equals(this.projectKey)) {
            return null;
        }
        return StringUtils.join((Object[])ArrayUtils.subarray((Object[])tagChunks, (int)3, (int)tagChunks.length), (String)"-");
    }

    private void findPreviousBundle() throws GitAPIException, IOException {
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        Git git = gitManager.getSubGit((String)this.projectKey).git;
        List tags = git.tagList().call();
        try (RevWalk walk = new RevWalk(git.getRepository());){
            int mostRecent = 0;
            for (Ref tagRef : tags) {
                logger.debug((Object)("tagRef: " + String.valueOf(tagRef)));
                ObjectId objId = tagRef.getObjectId();
                RevObject object = walk.parseAny((AnyObjectId)objId);
                if (object instanceof RevTag) {
                    int commitTime;
                    RevTag rt = (RevTag)object;
                    logger.debug((Object)("tag  " + String.valueOf(rt) + "  on " + String.valueOf(rt.getObject())));
                    String bundleId = this.getTagBundleId(rt);
                    if (bundleId == null || (commitTime = walk.parseCommit((AnyObjectId)rt.getObject()).getCommitTime()) <= mostRecent) continue;
                    mostRecent = commitTime;
                    this.previousBundleId = bundleId;
                    this.prevCommit = rt.getObject();
                    this.previousBundleTime = 1000L * (long)walk.parseCommit((AnyObjectId)this.prevCommit).getCommitTime();
                    continue;
                }
                if (!(object instanceof RevCommit)) continue;
                RevCommit rc = (RevCommit)object;
                logger.debug((Object)("Lightweight tag " + String.valueOf(rc)));
            }
        }
        catch (Exception e) {
            logger.errorV("Git repository history may be corrupted or incomplete. Please run 'git fsck --full' from the project %s folder to diagnose the issue", new Object[]{this.projectKey});
            throw new IOException("Could not properly read the project Git history. This likely indicates a corrupted Git repository. Please contact your administrator.");
        }
        if (this.prevCommit != null) {
            logger.debug((Object)("prevCommit " + String.valueOf(this.prevCommit)));
            this.prevTree = git.getRepository().resolve(this.prevCommit.getName() + "^{tree}");
            logger.debug((Object)("prevTree " + String.valueOf(this.prevTree)));
        }
    }

    public static class BundlePreparationResult {
        public BundleExporterSettings exporterSettings;
        public ExportedProject.ExportUserInfo exportUserInfo = new ExportedProject.ExportUserInfo();
        public BundleChangelog changelog;
        public ProjectSummaryService.ProjectConfigContent configContent;
    }
}

