/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.eda.EDASchemaColumns;
import com.dataiku.dip.recipes.eda.PCARecipeOutputRole;
import com.dataiku.dip.recipes.eda.PCARecipePayloadParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class PCARecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    private PCARecipePayloadParams payloadParams;

    public PCARecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.payloadParams = (PCARecipePayloadParams)JSON.parse((String)payload, PCARecipePayloadParams.class);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            if (this.recipe.getOutputsForRole(role).isEmpty()) {
                List<Schema> list = Collections.emptyList();
                return list;
            }
            Schema schema = this.getOutputSchema_T(role);
            List<Schema> list = Collections.singletonList(schema);
            return list;
        }
    }

    public Schema getOutputSchema_T(String role) throws IOException {
        PCARecipeOutputRole validatedRole = PCARecipeOutputRole.from(role);
        switch (validatedRole) {
            case PROJECTIONS: {
                Dataset inputDs = this.getInputDataset_T();
                return this.getProjectionsSchema(inputDs);
            }
            case EIGENVECTORS: {
                Dataset inputDs = this.getInputDataset_T();
                return this.getEigenvectorsSchema(inputDs);
            }
            case EIGENVALUES: {
                return this.getEigenvaluesSchema();
            }
        }
        throw new RuntimeException(String.format("Unsupported role: %s", validatedRole.name));
    }

    private Dataset getInputDataset_T() throws IOException {
        AnyLoc inputDsLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.getProjectKey());
        return this.datasetAccessService.getMandatoryUnsafe(inputDsLoc);
    }

    private Schema getProjectionsSchema(Dataset inputDs) {
        PCARecipePayloadParams.ProjectionsSchemaDetails schemaDetails = this.payloadParams.computeProjectionsSchema(inputDs.getSchema());
        return new Schema(schemaDetails.schemaColumns, false);
    }

    private Schema getEigenvectorsSchema(Dataset inputDs) {
        ArrayList<SchemaColumn> columns = new ArrayList<SchemaColumn>();
        SchemaColumn column = new SchemaColumn(EDASchemaColumns.inputColumn(), Type.STRING);
        columns.add(column);
        int i = 0;
        for (SchemaColumn sc : inputDs.getSchema().columns) {
            if (!this.payloadParams.columns.contains(sc.getName())) continue;
            column = new SchemaColumn(EDASchemaColumns.principalComponent(i), Type.DOUBLE);
            columns.add(column);
            ++i;
        }
        if (this.payloadParams.addComputationTimestamp) {
            column = new SchemaColumn("computation_timestamp", Type.DATE);
            columns.add(column);
        }
        return new Schema(columns, false);
    }

    private Schema getEigenvaluesSchema() {
        ArrayList<SchemaColumn> columns = new ArrayList<SchemaColumn>();
        SchemaColumn column = new SchemaColumn(EDASchemaColumns.principalComponent(), Type.STRING);
        column.comment = "The principal component name. Component names are sorted by largest explained variance.";
        columns.add(column);
        column = new SchemaColumn(EDASchemaColumns.variance(), Type.DOUBLE);
        column.comment = "The amount of variance explained by each of the principal components. Corresponds to the eigenvalues of the covariance matrix of the input dataset.";
        columns.add(column);
        column = new SchemaColumn(EDASchemaColumns.varianceRatio(), Type.DOUBLE);
        column.comment = "The ratio of the amount of variance explained by each of the principal components. All values sum to 1.";
        columns.add(column);
        column = new SchemaColumn(EDASchemaColumns.cumulativeVarianceRatio(), Type.DOUBLE);
        column.comment = "The cumulative ratio of the amount of variance explained by each principal component.";
        columns.add(column);
        if (this.payloadParams.addComputationTimestamp) {
            column = new SchemaColumn("computation_timestamp", Type.DATE);
            columns.add(column);
        }
        return new Schema(columns, false);
    }
}

