/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.export;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.ParamsWithEncryptedFields;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.export.ExportRecipeCreator;
import com.dataiku.dip.recipes.export.ExportRecipeParams;
import com.dataiku.dip.recipes.export.ExportRecipeRunner;
import com.dataiku.dip.recipes.export.ExportRecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ExportRecipeMeta
extends RecipeMeta
implements IPluginifiedHolderMeta {
    public static final ExportRecipeMeta META = new ExportRecipeMeta();

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return ExportRecipeParams.class;
    }

    @Override
    public String getType() {
        return "export";
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.NONE;
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new ExportRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new ExportRecipeRunner(activity);
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return null;
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new ExportRecipeStatusComputer(recipe, payload);
    }

    @Override
    public void updateImplicitIOBeforeSave(String projectKey, SerializedRecipe sr, String payload) {
        VariablesExpansionLoopConfig veLoopConfig;
        sr.clearInputsForRole("veloop");
        if (sr.params instanceof ParamsWithVariablesExpansionLoopConfig && (veLoopConfig = ((ParamsWithVariablesExpansionLoopConfig)((Object)sr.params)).getVariablesExpansionLoopConfig()).isEnabled() && StringUtils.isNotBlank((String)veLoopConfig.datasetRef)) {
            sr.addInput("veloop", veLoopConfig.datasetRef);
        }
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        RecipeDesc desc = RecipeDesc.newSisoDesc("export", null);
        RecipeDesc.IORoleDef out = desc.outputRoles.get(0);
        out.acceptsDataset = false;
        out.acceptsManagedFolder = true;
        desc.copiable = false;
        String roleLabel = ts.translateNoContext(lang, "RECIPE.SHAKER.DESC.VELOOP_DATASET", "Parameters dataset", new Object[0]);
        RecipeDesc.IORoleDef secondaryRole = new RecipeDesc.IORoleDef("veloop", roleLabel).withEditable(false, false);
        secondaryRole.arity = RecipeDesc.IOArity.NARY;
        secondaryRole.description = ts.translateNoContext(lang, "RECIPE.SHAKER.DESC.VELOOP_DATASET.HELP", "This input is added for 'dynamic repeat' recipes.\nEdit the recipe parameters dataset to change it.", new Object[0]);
        desc.inputRoles.add(secondaryRole);
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withVisualRecipe();
    }

    @Override
    public boolean hasJsonPayload() {
        return false;
    }

    @Override
    public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
        ArrayList components = Lists.newArrayList();
        if (object instanceof SerializedRecipe) {
            ExportRecipeParams params = ((SerializedRecipe)object).getParamsAs(ExportRecipeParams.class);
            if (params.exportParams != null) {
                PluginUsagesInspector.addExporterComponentToList(components, params.exportParams);
            }
        }
        return components;
    }

    @Override
    public void prepareForSave(SerializedRecipe sr, PasswordEncryptionService cryptoService) {
        FormatParams fp;
        ExportParams exportParams;
        if (sr.params instanceof ExportRecipeParams && (exportParams = ((ExportRecipeParams)sr.params).exportParams) != null && exportParams.format != null && exportParams.format.params != null && exportParams.format.type != null && (fp = (FormatParams)JSON.parse((String)exportParams.format.params.toString(), FormatFactory.getMeta(exportParams.format.type).paramsClass())) instanceof ParamsWithEncryptedFields) {
            ((ParamsWithEncryptedFields)((Object)fp)).encryptFields(cryptoService);
            exportParams.format.params = JSON.toJsonObject((Object)fp);
        }
    }
}

