/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks;

import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.chunks.VlmExtractionChunk;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocumentPageRange;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ExtractedMetadata;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.MultimodalContent;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.SourceFile;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks.RuleChunk;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class VlmRuleChunk
extends RuleChunk {
    protected abstract String getType();

    @Override
    public String toJson() {
        JsonObject obj = JSON.toJsonObject((Object)this);
        obj.addProperty("type", this.getType());
        return obj.toString();
    }

    public static class DocumentChunk
    extends VlmRuleChunk {
        protected static final String TYPE = "document";
        DocumentPageRange pageRange;
        @JsonAdapter(value=PrimitiveChunk.PrimitiveChunkAdapter.class)
        List<? extends PrimitiveChunk> content;

        public DocumentChunk(List<? extends PrimitiveChunk> primitiveChunks) {
            this.content = primitiveChunks;
            if (primitiveChunks != null && !primitiveChunks.isEmpty()) {
                int n;
                PrimitiveChunk lastChunk = primitiveChunks.get(primitiveChunks.size() - 1);
                if (lastChunk instanceof PageChunk) {
                    PageChunk p = (PageChunk)lastChunk;
                    n = p.pageNumber;
                } else {
                    n = ((MultiPagesChunk)lastChunk).pageRange.end;
                }
                this.pageRange = new DocumentPageRange(1, n);
            }
        }

        public DocumentChunk() {
        }

        @Override
        public String getTextValue() {
            return this.content.stream().map(pageChunk -> pageChunk.getTextValue()).collect(Collectors.joining("\n"));
        }

        @Override
        @Nullable
        public MultimodalContent getMultimodalValue() {
            return null;
        }

        @Override
        public ExtractedMetadata getGeneratedMetadata(InputRefs.ManagedFolderDocumentRef sourceDocument) {
            ExtractedMetadata metadata = new ExtractedMetadata();
            metadata.sourceFile = new SourceFile(sourceDocument.managedFolderId, sourceDocument.filePath);
            metadata.pageRange = this.pageRange;
            return metadata;
        }

        @Override
        protected String getType() {
            return TYPE;
        }
    }

    public static class MultiPagesChunk
    extends PrimitiveChunk {
        protected static final String TYPE = "pages";
        DocumentPageRange pageRange;
        public List<String> images;

        public MultiPagesChunk() {
        }

        MultiPagesChunk(VlmExtractionChunk chunk) {
            this.pageRange = chunk.pageRange;
            this.images = chunk.images;
            this.text = chunk.promptOutput;
        }

        @Override
        protected String getType() {
            return TYPE;
        }

        @Override
        protected List<String> getImagePaths() {
            if (this.images == null) {
                return new ArrayList<String>();
            }
            return this.images;
        }

        @Override
        public ExtractedMetadata getGeneratedMetadata(InputRefs.ManagedFolderDocumentRef sourceDocument) {
            ExtractedMetadata metadata = new ExtractedMetadata();
            metadata.sourceFile = new SourceFile(sourceDocument.managedFolderId, sourceDocument.filePath);
            metadata.pageRange = this.pageRange;
            return metadata;
        }
    }

    public static class PageChunk
    extends PrimitiveChunk {
        protected static final String TYPE = "page";
        public int pageNumber;
        public String image;

        public PageChunk() {
        }

        PageChunk(VlmExtractionChunk chunk) {
            this.pageNumber = chunk.pageRange.start;
            this.image = chunk.images == null || chunk.images.isEmpty() ? null : chunk.images.get(0);
            this.text = chunk.promptOutput;
        }

        @Override
        protected String getType() {
            return TYPE;
        }

        @Override
        protected List<String> getImagePaths() {
            if (this.image == null) {
                return new ArrayList<String>();
            }
            return List.of(this.image);
        }

        @Override
        public ExtractedMetadata getGeneratedMetadata(InputRefs.ManagedFolderDocumentRef sourceDocument) {
            ExtractedMetadata metadata = new ExtractedMetadata();
            metadata.sourceFile = new SourceFile(sourceDocument.managedFolderId, sourceDocument.filePath);
            metadata.pageRange = new DocumentPageRange(this.pageNumber, this.pageNumber);
            return metadata;
        }
    }

    public static abstract class PrimitiveChunk
    extends VlmRuleChunk {
        public String text;

        public static PrimitiveChunk buildFromExtractionChunk(VlmExtractionChunk chunk, int lastPaginationOffset) {
            chunk.pageRange.start += lastPaginationOffset;
            chunk.pageRange.end += lastPaginationOffset;
            if (chunk instanceof VlmExtractionChunk.MultiPagesChunk) {
                return new MultiPagesChunk(chunk);
            }
            return new PageChunk(chunk);
        }

        @Override
        public String getTextValue() {
            return this.text;
        }

        protected abstract List<String> getImagePaths();

        @Override
        public MultimodalContent getMultimodalValue() {
            List<String> imagePaths = this.getImagePaths();
            if (imagePaths != null && !imagePaths.isEmpty()) {
                return new MultimodalContent.Image(imagePaths);
            }
            return new MultimodalContent.Text(this.getTextValue());
        }

        static class PrimitiveChunkAdapter
        implements JSON.Adapter<List<? extends PrimitiveChunk>> {
            PrimitiveChunkAdapter() {
            }

            public List<? extends PrimitiveChunk> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                return null;
            }

            public JsonElement serialize(List<? extends PrimitiveChunk> primitiveChunks, Type type, JsonSerializationContext jsonSerializationContext) {
                JsonArray serializedChunks = new JsonArray();
                for (PrimitiveChunk primitiveChunk : primitiveChunks) {
                    JsonObject jsonChunk;
                    String chunkType = primitiveChunk.getType();
                    if ("page".equals(chunkType)) {
                        jsonChunk = JSON.toJsonObject((Object)((PageChunk)primitiveChunk));
                    } else if ("pages".equals(chunkType)) {
                        jsonChunk = JSON.toJsonObject((Object)((MultiPagesChunk)primitiveChunk));
                    } else {
                        throw new JsonParseException("Unknown Primitive chunk type: " + chunkType);
                    }
                    jsonChunk.addProperty("type", chunkType);
                    serializedChunks.add((JsonElement)jsonChunk);
                }
                return serializedChunks;
            }
        }
    }
}

