/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.hive.HiveRecipeRunner;
import com.dataiku.dip.recipes.shaker.AbstractShakerRecipeSQLRunner;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.sql.HiveSqlQueryWithSchemaBuilder;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ShakerRecipeHiveRunner
extends AbstractShakerRecipeSQLRunner {
    @Autowired
    protected JobAuthCtxService authCtxService;

    ShakerRecipeHiveRunner(JobActivity activity) {
        super(activity);
        this.sqlQueryWithSchemaBuilder = new HiveSqlQueryWithSchemaBuilder(activity);
    }

    @Override
    protected String getEngineType() {
        return "Hive";
    }

    @Override
    protected AbortableRecipeRunner buildRecipeRunner(final ShakerSQLTranslator.TranslatorResult translatorResult) throws Exception {
        final HiveRecipeMeta.HiveRecipeParams hParams = this.recipe.getModel().getParamsAs(ShakerRecipeParams.class).engineParams.hive;
        HiveRecipeRunner hiveRunner = new HiveRecipeRunner(this.activity){

            @Override
            protected String getSql() throws IOException, SQLException, DKUSecurityException {
                return translatorResult.translated.toSQL(ShakerRecipeHiveRunner.this.sqlQueryWithSchemaBuilder.getDialect());
            }

            @Override
            protected String getPreQueries() {
                return hParams.preQueries;
            }

            @Override
            protected HiveRecipeMeta.HiveExecutionEngine getExecutionEngine() {
                return hParams.executionEngine;
            }

            @Override
            protected boolean addDkuUdf() {
                return hParams.addDkuUdf;
            }

            @Override
            protected List<SimpleKeyValue> getExtraConf() throws IOException, DKUSecurityException {
                return new HiveConfHelper().getResolvedConf(ShakerRecipeHiveRunner.this.authCtxService.getAuthCtx(), ShakerRecipeHiveRunner.this.recipe.getProjectKey(), hParams);
            }

            @Override
            protected boolean canOverrideDatabase() {
                return false;
            }
        };
        SpringUtils.getInstance().autowire((Object)hiveRunner);
        hiveRunner.init();
        return hiveRunner;
    }
}

