/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios;

import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioMeta;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunner;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Maps;
import java.util.Map;

public class ScenarioRegistry {
    private static final Map<String, ScenarioMeta> library = Maps.newLinkedHashMap();

    public static ScenarioRunner buildRunner(Scenario scenario) {
        ScenarioRunner runner = ScenarioRegistry.getMeta(scenario).buildRunner(scenario);
        SpringUtils.getInstance().autowire((Object)runner);
        return runner;
    }

    public static ScenarioMeta getMeta(Scenario scenario) {
        return ScenarioRegistry.getMeta(scenario.getType());
    }

    public static synchronized ScenarioMeta getMeta(String type) {
        if (library.containsKey(type)) {
            return library.get(type);
        }
        throw new Error("Unknown scenario type " + type);
    }

    public static synchronized void register(ScenarioMeta meta) {
        library.put(meta.getType(), meta);
    }
}

