/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.security.AuthorizationMatrixBase;
import com.dataiku.dip.security.model.PublicUser;
import java.util.ArrayList;
import java.util.List;

public class AuthorizationMatrix {
    public PerUser perUser = new PerUser();
    public PerGroup perGroup = new PerGroup();
    public PerPendingUserEmail perPendingUserEmail = new PerPendingUserEmail();

    public static class PerUser
    extends DSSAuthorizationMatrixBase {
        public List<PublicUser> users = new ArrayList<PublicUser>();
    }

    public static class PerGroup
    extends DSSAuthorizationMatrixBase {
        public List<String> groups = new ArrayList<String>();
    }

    public static class PerPendingUserEmail {
        public List<ProjectGrants> projectsGrants = new ArrayList<ProjectGrants>();
        public List<String> pendingUserEmails = new ArrayList<String>();
    }

    static class DSSAuthorizationMatrixBase
    extends AuthorizationMatrixBase {
        public List<ProjectGrants> projectsGrants = new ArrayList<ProjectGrants>();

        DSSAuthorizationMatrixBase() {
        }

        void setPermissions(UsersDAO.GroupPermissions permissions) {
            this.admin.add(permissions.isAdmin());
            this.mayCreateProjects.add(permissions.mayCreateProjects());
            this.mayCreateProjectsUsingMacros.add(permissions.mayCreateProjectsFromMacros());
            this.mayCreateProjectsUsingTemplates.add(permissions.mayCreateProjectsFromTemplates());
            this.mayCreateWorkspaces.add(permissions.mayCreateWorkspaces());
            this.mayShareToWorkspaces.add(permissions.mayShareToWorkspaces());
            this.mayCreateDataCollections.add(permissions.mayCreateDataCollections());
            this.mayPublishToDataCollections.add(permissions.mayPublishToDataCollections());
            this.mayManageFeatureStore.add(permissions.mayManageFeatureStore());
            this.mayCreateCodeEnvs.add(permissions.mayCreateCodeEnvs());
            this.mayManageCodeEnvs.add(permissions.mayManageCodeEnvs());
            this.mayCreateClusters.add(permissions.mayCreateClusters());
            this.mayManageClusters.add(permissions.mayManageClusters());
            this.mayCreateCodeStudioTemplates.add(permissions.mayCreateCodeStudioTemplates());
            this.mayManageCodeStudioTemplates.add(permissions.mayManageCodeStudioTemplates());
            this.mayDevelopPlugins.add(permissions.mayDevelopPlugins());
            this.mayEditLibFolders.add(permissions.mayEditLibFolders());
            this.mayManageUDM.add(permissions.mayManageUDM());
            this.mayWriteUnsafeCode.add(permissions.mayWriteUnsafeCode());
            this.mayWriteSafeCode.add(permissions.mayWriteSafeCode());
            this.mayCreateAuthenticatedConnections.add(permissions.mayCreateAuthenticatedConnections());
            this.mayCreatePublishedAPIServices.add(permissions.mayCreatePublishedAPIServices());
            this.mayCreatePublishedProjects.add(permissions.mayCreatePublishedProjects());
            this.mayWriteInRootProjectFolder.add(permissions.mayWriteInRootProjectFolder());
            this.mayCreateActiveWebContent.add(permissions.mayCreateActiveWebContent());
        }
    }

    public static class ProjectGrants {
        public String projectKey;
        public String projectName;
        public List<ProjectGrant> grants = new ArrayList<ProjectGrant>();
    }

    public static class ProjectGrant {
        public SerializedProject.PermissionItem item;
        public List<String> grantedBy = new ArrayList<String>();
    }
}

