/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.UsersService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectPermissionsWatcher
extends PermissionsWatcher {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UsersService usersService;
    private final String projectKey;

    public ProjectPermissionsWatcher(String projectKey) {
        SpringUtils.getInstance().autowire((Object)this);
        this.projectKey = projectKey;
    }

    @Override
    protected List<SerializedProject> getProjectsUnsafe() throws IOException {
        SerializedProject project = this.projectsService.getOrNullUnsafe(this.projectKey);
        if (project == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new SerializedProject[]{project});
    }

    @Override
    protected List<UsersDAO.User> getUsersUnsafe() throws IOException {
        return this.usersService.listUsersInternalUnsafeEnabledOnly();
    }
}

