/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projects.apps.CustomAppTemplatesService;
import com.dataiku.dip.projects.apps.LoadedCustomAppTemplate;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.fromapp.AppRecipeMeta;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;

@Controller
public class AppsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    protected TimelinesInternalDB timelinesDAO;
    @Autowired
    protected LicenseEnforcementService licenseEnforcementService;
    @Autowired
    protected AppsService appsService;
    @Autowired
    protected ProjectsService projectsService;
    @Autowired
    protected ScenariosService scenariosService;
    @Autowired
    protected PermissionsService permissionsService;
    @Autowired
    protected CustomAppTemplatesService customAppTemplatesService;
    @Autowired
    protected DiscussionsService discussionsService;
    @Autowired
    protected ImageService service;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.apps.controller");

    @AuditedCall(value={"msgType", "apps-list"})
    @RequestMapping(value={"/api/apps/list-templates"}, method={RequestMethod.GET})
    public void listAppTemplates(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean includeLimitedVisibility, @RequestParam(required=false) boolean enrichWithHomepageInfo) throws Exception {
        AppsService.AppsList notRecipes;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            notRecipes = this.appsService.listAppTemplates_T(authCtx, includeLimitedVisibility, false);
        }
        if (enrichWithHomepageInfo) {
            this.appsService.enrichAppListWithHomepageInfo_NT(authCtx, notRecipes);
        }
        AppsController.writeJSON((HttpServletResponse)resp, (Object)notRecipes);
    }

    @AuditedCall(value={"msgType", "apps-list-instances"})
    @RequestMapping(value={"/api/apps/list-instances"}, method={RequestMethod.GET})
    public void listAppInstances(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            AppsController.writeJSON((HttpServletResponse)resp, (Object)this.appsService.listAppInstances_T(authCtx));
        }
    }

    @AuditedCall(value={"msgType", "app-get-access-info", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/apps/get-access-info"})
    public void getAppAccessInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId) throws Exception {
        AppAccessInfo appAccessInfo = new AppAccessInfo();
        try (Transaction t = this.transactionService.beginRead();){
            AppManifest manifest;
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            try {
                manifest = this.appsService.getAppTemplateManifest_T(appId);
            }
            catch (Exception e) {
                throw new UnauthorizedException("Failed to read application permissions. Application does not exist or you do not have the permission to access it.", "check-failed");
            }
            appAccessInfo.hasAnyAccess = this.appsService.hasAppInstantiatePerm_T(authCtx, manifest);
            if (!appAccessInfo.hasAnyAccess) {
                GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
                appAccessInfo.isVisible = this.appsService.isVisible(manifest, generalSettings);
                appAccessInfo.isAccessRequestsEnabled = this.appsService.isAccessRequestsEnabled(manifest, generalSettings);
            }
        }
        if (!appAccessInfo.hasAnyAccess && BooleanUtils.isNotTrue((Boolean)appAccessInfo.isVisible) && BooleanUtils.isNotTrue((Boolean)appAccessInfo.isAccessRequestsEnabled)) {
            throw new UnauthorizedException("Failed to read application permissions. Application does not exist or you do not have the permission to access it.", "check-failed");
        }
        AppsController.writeJSON((HttpServletResponse)resp, (Object)appAccessInfo);
    }

    @AuditedCall(value={"msgType", "apps-get", "appId", "${appId}"})
    @RequestMapping(value={"/api/apps/get-visible-template-summary"}, method={RequestMethod.GET})
    public void getVisibleAppTemplateSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId) throws Exception {
        AppsService.AppImageInfo imageInfo;
        AppManifest manifest;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            manifest = this.appsService.getAppTemplateManifest_T(appId);
            GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (!this.appsService.isVisible(manifest, generalSettings)) {
                this.appsService.checkAppInstantiatePerm_T(authCtx, manifest);
            }
            imageInfo = this.appsService.getAppImageInfo(manifest);
        }
        AppsController.writeJSON((HttpServletResponse)resp, (Object)new AppsService.AppListItem(manifest, imageInfo));
    }

    @AuditedCall(value={"msgType", "apps-get", "appId", "${appId}"})
    @RequestMapping(value={"/api/apps/get-template-summary"}, method={RequestMethod.GET})
    public void getAppTemplateSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId) throws Exception {
        AppsService.AppTemplatePageData ret;
        AuthCtx authCtx;
        HashMap<String, List<Scenario>> scenariosMap = new HashMap<String, List<Scenario>>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkUseDataikuAppsAllowed(authCtx);
            this.appsService.checkAppInstantiatePerm_T(authCtx, appId);
            ret = this.appsService.getAppTemplatePageData_T(authCtx, appId);
            logger.info((Object)"Got instance list, getting scenarios");
            for (ProjectsService.HomepageProjectItem hpi : ret.instances) {
                ArrayList scenarios = Lists.newArrayList();
                try {
                    scenarios.addAll(this.scenariosService.listUnsafe(hpi.projectKey));
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to retrieve scenarios of project", (Throwable)e);
                }
                scenariosMap.put(hpi.projectKey, scenarios);
            }
        }
        logger.info((Object)"Got instance list, enriching");
        for (ProjectsService.HomepageProjectItem hpi : ret.instances) {
            this.projectsService.enrichHomepageProjectItem_NT(hpi, authCtx, false, false, scenariosMap);
        }
        AppsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/apps/get-template-image"}, method={RequestMethod.GET})
    public void getAppTemplateImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId, @RequestParam(value="size", required=false) String requestedSize) throws Exception {
        InputStream picData;
        AppsService.AppImageInfo imageInfo;
        MutableLong lastModified = new MutableLong();
        try (Transaction ignored = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
            AppManifest appManifest = this.appsService.getAppTemplateManifest_T(appId);
            imageInfo = this.appsService.getAppImageInfo(appManifest);
            String initials = null;
            if (BooleanUtils.isTrue((Boolean)imageInfo.showInitials)) {
                initials = appManifest.label;
                if (StringUtils.isNotBlank((String)appManifest.label) && (initials = appManifest.label.replaceAll("(?<=\\w)\\w+\\s?", "")).length() < 2) {
                    initials = appManifest.label;
                }
            }
            picData = this.service.getImage(null, "APP", appId, requestedSize, lastModified, imageInfo.imgColor != null ? imageInfo.imgColor : imageInfo.defaultImgColor, imageInfo.imgPattern, initials);
        }
        resp.setDateHeader("Last-Modified", lastModified.longValue());
        resp.setContentType("image/png");
        resp.addDateHeader("Expires", System.currentTimeMillis() + (long)(imageInfo.isAppImg ? 60000 : 86400000));
        long ifModifiedSince = req.getDateHeader("If-Modified-Since");
        try {
            if (lastModified.longValue() <= ifModifiedSince) {
                resp.setStatus(304);
            } else {
                IOUtils.copy((InputStream)picData, (OutputStream)resp.getOutputStream());
            }
        }
        finally {
            picData.close();
        }
    }

    @AuditedCall(value={"msgType", "apps-get-instance", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/apps/get-instance-summary"}, method={RequestMethod.GET})
    public void getAppInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.licenseEnforcementService.checkUseDataikuAppsAllowed(authCtx);
            AppsController.writeJSON((HttpServletResponse)resp, (Object)this.appsService.getAppInstanceData_T(authCtx, projectKey));
        }
    }

    @AuditedCall(value={"msgType", "apps-instantiate", "appId", "${appId}", "targetProjectKey", "${targetProjectKey}"})
    @RequestMapping(value={"/api/apps/instantiate"}, method={RequestMethod.POST})
    public void instantiateApp(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId, @RequestParam String targetProjectKey, @RequestParam String targetProjectLabel) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.appsService.checkAppInstantiatePerm_T(authCtx, appId);
        }
        AppsService.AppInstantiationParams appInstantiationParams = new AppsService.AppInstantiationParams(Optional.ofNullable(targetProjectKey).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "targetProjectKey is mandatory")), targetProjectLabel, null, appId);
        AppsController.writeJSON((HttpServletResponse)resp, this.appsService.startInstantiate_NT(authCtx, appId, appInstantiationParams, false, false));
    }

    @AuditedCall(value={"msgType", "apps-update-instance", "appId", "${appId}", "projectKey", "${projectKey}", "keepVariables", "${keepVariables}"})
    @RequestMapping(value={"/api/apps/update-instance"}, method={RequestMethod.POST})
    public void updateInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="true") boolean keepProjectDescription, @RequestParam(required=false, defaultValue="true") boolean keepVariables) throws Exception {
        JsonObject variables;
        SerializedProject project;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.appsService.checkAppInstantiatePerm_T(authCtx, appId);
            project = this.projectsService.getMandatoryUnsafe(projectKey);
            variables = VariablesService.readLocalUnresolvedProjectVariables((String)projectKey, (Transaction)t).local;
        }
        if (!keepVariables) {
            String projectRandomKey = null;
            if (variables.has("projectRandomKey")) {
                projectRandomKey = variables.get("projectRandomKey").getAsString();
            }
            variables = new JsonObject();
            if (projectRandomKey != null) {
                variables.addProperty("projectRandomKey", projectRandomKey);
            }
        }
        String projectDescription = keepProjectDescription ? project.shortDesc : null;
        AppsService.AppInstantiationParams appInstantiationParams = new AppsService.AppInstantiationParams(projectKey, project.name, projectDescription, appId, variables);
        AppsController.writeJSON((HttpServletResponse)resp, this.appsService.startInstantiate_NT(authCtx, appId, appInstantiationParams, true, false));
    }

    @AuditedCall(value={"msgType", "apps-skip-instance-update", "appId", "${appId}", "projectKey", "${projectKey}", "keepVariables", "${keepVariables}"})
    @RequestMapping(value={"/api/apps/skip-instance-update"}, method={RequestMethod.POST})
    public void skipInstanceUpdate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId, @RequestParam String projectKey, @RequestParam String versionToSkip) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = t.getUser();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.appsService.skipInstanceUpdate_T(projectKey, versionToSkip);
            t.commit("Skip instance update");
        }
    }

    @AuditedCall(value={"msgType", "apps-test-update", "appId", "${appId}"})
    @RequestMapping(value={"/api/apps/create-or-update-test-instance"}, method={RequestMethod.POST})
    public void createOrUpdateTestInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId, @RequestParam(required=false, defaultValue="false") boolean fullUpdate) throws Exception {
        String existing;
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.appsService.checkAppInstantiatePerm_T(authCtx, appId);
            existing = this.appsService.getTestInstance_T(authCtx, appId);
        }
        if (fullUpdate && StringUtils.isNotBlank((String)existing)) {
            logger.info((Object)("Recreating test instance => trash " + existing));
            this.projectsService.projectDeletionAttempt(authCtx, existing, true, true, true, true);
        }
        AppsController.writeJSON((HttpServletResponse)resp, this.appsService.createOrUpdateTestInstance_NT(authCtx, appId));
    }

    @AuditedCall(value={"msgType", "apps-test-get", "appId", "${appId}"})
    @RequestMapping(value={"/api/apps/get-test-instance"}, method={RequestMethod.GET})
    public void getTestInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId) throws IOException, DKUSecurityException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            AppsController.writeJSON((HttpServletResponse)resp, (Object)this.appsService.getTestInstance_T(authCtx, appId));
        }
    }

    @AuditedCall(value={"msgType", "apps-recipe-get", "recipeType", "${recipeType}"})
    @RequestMapping(value={"/api/apps/get-app-recipe-usability"}, method={RequestMethod.GET})
    public void getAppRecipeUsability(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeType) throws IOException, DKUSecurityException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            RecipeMeta meta = RecipeRegistry.getMeta(recipeType);
            if (!(meta instanceof AppRecipeMeta)) {
                throw new IllegalArgumentException("Recipe type is not a known app recipe");
            }
            AppRecipeMeta appRecipeMeta = (AppRecipeMeta)meta;
            AppRecipeUsability ret = new AppRecipeUsability();
            ret.appId = appRecipeMeta.getAppId();
            ret.origin = AppsService.AppOrigin.fromAppId(ret.appId);
            if (ret.origin == AppsService.AppOrigin.PROJECT) {
                ret.projectKey = AppsService.getProjectKey(ret.appId);
                if (!this.projectsService.projectExists(ret.projectKey)) {
                    ret.canEdit = false;
                    ret.reason = "The project providing the application template doesn't exist";
                } else if (!this.permissionsService.hasProjectPrivilege(authCtx, ret.projectKey, AppsService.minimumPermissionForEditingAppDesigner())) {
                    ret.canEdit = false;
                    ret.reason = "Insufficient rights on the project providing the application template";
                } else {
                    ret.canEdit = true;
                }
            } else if (ret.origin == AppsService.AppOrigin.PLUGIN) {
                LoadedCustomAppTemplate loadedDesc = (LoadedCustomAppTemplate)this.customAppTemplatesService.getLoadedDescByElementType(recipeType);
                if (loadedDesc == null) {
                    ret.canEdit = false;
                    ret.reason = "No plugin provides the application";
                } else {
                    ret.pluginId = loadedDesc.getOwnerPluginId();
                    if (!authCtx.isAdmin() && !this.permissionsService.hasPluginPrivilege(authCtx, ret.pluginId, Privileges.PluginLevelPrivilegeType.ADMIN)) {
                        ret.canEdit = false;
                        ret.reason = "Insufficient rights on the plugin providing the application template";
                    } else {
                        ret.canEdit = true;
                    }
                }
            } else {
                throw new IllegalArgumentException("Unknown app type");
            }
            AppsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/apps/check-instances-deletability"})
    @ResponseBody
    public InfoMessage.InfoMessages checkInstancesDeletability(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId, @RequestParam List<String> projectKeys) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.appsService.checkAppInstantiatePerm_T(authCtx, appId);
            for (String projectKey : projectKeys) {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
                TaggableObjectsDeletionService.DeletionResult deletionResult = this.projectsService.checkProjectDeletability(projectKey, false);
                ret.mergeFrom((InfoMessage.InfoMessages)deletionResult);
            }
        }
        return ret;
    }

    @AuditedCall(value={"msgType", "instances-delete", "appId", "${appId}"})
    @RequestMapping(value={"/api/apps/delete-instances"})
    @ResponseBody
    public InfoMessage.InfoMessages deleteInstances(HttpServletRequest req, HttpServletResponse resp, @RequestParam String appId, @RequestParam List<String> projectKeys, @RequestParam boolean clearManagedDatasets, @RequestParam boolean clearOutputManagedFolders, @RequestParam boolean clearJobAndScenarioLogs) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.appsService.checkAppInstantiatePerm_T(authCtx, appId);
        }
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        for (String projectKey : projectKeys) {
            ret.mergeFrom(this.projectsService.projectDeletionAttempt(authCtx, projectKey, clearManagedDatasets, clearOutputManagedFolders, clearJobAndScenarioLogs));
        }
        return ret;
    }

    static class AppAccessInfo {
        public Boolean isVisible;
        public Boolean isAccessRequestsEnabled;
        public boolean hasAnyAccess = false;

        AppAccessInfo() {
        }
    }

    public static class AppRecipeUsability {
        public String appId;
        public AppsService.AppOrigin origin;
        public String projectKey;
        public String pluginId;
        public String reason;
        public boolean canEdit;
    }
}

