/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.frontend;

import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.jobrunner.status.CoreJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.JobStatusUpdatedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JobStatusUpdatedLightEvent
extends BackendEvent
implements UserEvent,
ProjectEvent {
    public static final String NAME = "job-status-updated-light";
    public final String projectKey;
    public final String userLogin;
    public final CoreJobStatusLight status;

    private JobStatusUpdatedLightEvent(String projectKey, String userLogin, CoreJobStatusLight status) {
        this.projectKey = projectKey;
        this.userLogin = userLogin;
        this.status = status;
    }

    public static JobStatusUpdatedLightEvent fromJobStatusUpdatedEvent(JobStatusUpdatedEvent jobStatusUpdatedEvent) {
        return new JobStatusUpdatedLightEvent(jobStatusUpdatedEvent.getProjectKey(), jobStatusUpdatedEvent.getUserLogin(), CoreJobStatusLight.fromCoreJobStatus(jobStatusUpdatedEvent.status));
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getUserLogin() {
        return this.userLogin;
    }

    public static class CoreJobStatusLight {
        public Map<String, JobActivityStatusUpdateLight> activities = new HashMap<String, JobActivityStatusUpdateLight>();

        private CoreJobStatusLight(Map<String, JobActivityStatusUpdateLight> activities) {
            this.activities = activities;
        }

        public static CoreJobStatusLight fromCoreJobStatus(CoreJobStatus coreJobStatus) {
            return new CoreJobStatusLight(coreJobStatus.activities.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JobActivityStatusUpdateLight.fromSerializableJobActivityStatus((SerializedJobActivityStatus)entry.getValue()))));
        }
    }

    public static class SerializedTargetDSLight {
        public FlowComputable.FCType type;
        public String id;

        public SerializedTargetDSLight(FlowComputable.FCType type, String id) {
            this.type = type;
            this.id = id;
        }
    }

    public static class JobActivityStatusUpdateLight {
        public ActivityState state;
        public List<SerializedTargetDSLight> targets;
        public boolean skipExplicitOrWriteProtected;

        private JobActivityStatusUpdateLight(ActivityState state, List<SerializedTargetDSLight> targets, boolean skipExplicitOrWriteProtected) {
            this.state = state;
            this.targets = targets;
            this.skipExplicitOrWriteProtected = skipExplicitOrWriteProtected;
        }

        static JobActivityStatusUpdateLight fromSerializableJobActivityStatus(SerializedJobActivityStatus jobActivityStatus) {
            return new JobActivityStatusUpdateLight(jobActivityStatus.state, jobActivityStatus.targets.stream().map(t -> new SerializedTargetDSLight(t.type, t.id)).toList(), jobActivityStatus.skipExplicitOrWriteProtected);
        }
    }
}

